/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.DriverConstants;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.ParseException;
import com.tmax.tibero.jdbc.util.TbUrlParser;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class TbDriver
implements Driver {
    protected static Connection defaultConn = null;

    public boolean acceptsURL(String string) throws SQLException {
        try {
            if (TbUrlParser.parseUrl(string, null) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Connection connect(ConnectionInfo connectionInfo) throws SQLException {
        return this.connectInternal(connectionInfo);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        ConnectionInfo connectionInfo = null;
        if (TbUrlParser.isInternalUrl(string)) {
            connectionInfo = new ConnectionInfo();
            connectionInfo.setInternal(true);
        } else {
            if (!TbUrlParser.isTiberoUrl(string)) {
                return null;
            }
            try {
                connectionInfo = TbUrlParser.parseUrl(string, properties);
            }
            catch (ParseException parseException) {
                throw TbError.newSQLException(-90605, parseException);
            }
        }
        return this.connectInternal(connectionInfo);
    }

    private Connection connectInternal(ConnectionInfo connectionInfo) throws SQLException {
        if (connectionInfo == null) {
            return null;
        }
        try {
            TbConnection tbConnection = new TbConnection();
            String string = connectionInfo.getNewPassword();
            if (string != null && string.length() != 0) {
                try {
                    tbConnection.openConnection(connectionInfo, false);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 17002) {
                        // empty if block
                    }
                    tbConnection.openConnection(connectionInfo, true);
                }
            } else {
                tbConnection.openConnection(connectionInfo, false);
            }
            return tbConnection;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection defaultConnection() throws SQLException {
        Class clazz = TbDriver.class;
        synchronized (clazz) {
            if (defaultConn == null || defaultConn.isClosed()) {
                defaultConn = DriverManager.getConnection("jdbc:default:connection");
            }
        }
        return defaultConn;
    }

    public int getMajorVersion() {
        return Integer.parseInt(DriverConstants.JDBC_MAJOR);
    }

    public int getMinorVersion() {
        return Integer.parseInt(DriverConstants.JDBC_MINOR);
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getRevision() {
        return Integer.parseInt(DriverConstants.JDBC_REVISION);
    }

    public boolean jdbcCompliant() {
        return true;
    }

    static {
        try {
            DriverManager.registerDriver(new TbDriver());
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to register TiberoDriver:" + sQLException.getMessage());
        }
    }
}

