/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.remote.wlx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import weblogic.kernel.KernelStatus;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextHelper;
import weblogic.management.remote.common.WLSJMXConnector;
import weblogic.rmi.extensions.PortableRemoteObject;

public class ClientProvider
implements JMXConnectorProvider {
    private static final String WEBLOGIC_CONTEXT = "weblogic.context";

    public JMXConnector newJMXConnector(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.putAll(map);
        hashMap.put("jmx.remote.x.notification.fetch.timeout", new Long(1000L));
        hashMap.put("jmx.remote.x.client.connection.check.period", new Long(0L));
        RMIServer rMIServer = this.findRMIServer(jMXServiceURL, hashMap);
        return new WLXRMIConnectorWrapper(rMIServer, hashMap);
    }

    private RMIServer findRMIServer(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        Object object;
        String string = jMXServiceURL.getURLPath();
        if (!string.startsWith("/jndi/")) {
            throw new MalformedURLException("URL path must begin with /jndi/");
        }
        Context context = (Context)map.get(WEBLOGIC_CONTEXT);
        if (context == null) {
            if (KernelStatus.isServer()) {
                try {
                    context = new InitialContext();
                }
                catch (NamingException namingException) {
                    IOException iOException = new IOException("Unable to create InitialContext: " + namingException.toString());
                    iOException.initCause(namingException);
                    throw iOException;
                }
            } else {
                throw new IOException("weblogic.context is not defined in the environment");
            }
        }
        try {
            object = context.lookup(string.substring(6));
        }
        catch (NamingException namingException) {
            IOException iOException = new IOException(namingException.getMessage());
            iOException.initCause(namingException);
            throw iOException;
        }
        return ClientProvider.narrowServer(object);
    }

    private static RMIServer narrowServer(Object object) {
        try {
            return (RMIServer)PortableRemoteObject.narrow((Object)object, RMIServer.class);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    class WLXRMIConnectorWrapper
    extends RMIConnector
    implements WLSJMXConnector {
        private Locale locale_;
        private static final String LOCALE_KEY = "weblogic.management.remote.locale";

        public WLXRMIConnectorWrapper(RMIServer rMIServer, Map map) {
            super(rMIServer, map);
            this.locale_ = null;
            this.locale_ = (Locale)map.get(LOCALE_KEY);
        }

        public synchronized MBeanServerConnection getMBeanServerConnection() throws IOException {
            MBeanServerConnection mBeanServerConnection = super.getMBeanServerConnection();
            if (this.locale_ != null) {
                mBeanServerConnection = new WLXMBeanServerConnectionWrapper(mBeanServerConnection, this.locale_);
            }
            return mBeanServerConnection;
        }

        public synchronized MBeanServerConnection getMBeanServerConnection(Subject subject) throws IOException {
            MBeanServerConnection mBeanServerConnection = super.getMBeanServerConnection(subject);
            if (this.locale_ != null) {
                mBeanServerConnection = new WLXMBeanServerConnectionWrapper(mBeanServerConnection, this.locale_);
            }
            return mBeanServerConnection;
        }

        public synchronized MBeanServerConnection getMBeanServerConnection(Locale locale) throws IOException {
            MBeanServerConnection mBeanServerConnection = super.getMBeanServerConnection();
            return new WLXMBeanServerConnectionWrapper(mBeanServerConnection, locale);
        }

        public synchronized MBeanServerConnection getMBeanServerConnection(Subject subject, Locale locale) throws IOException {
            MBeanServerConnection mBeanServerConnection = super.getMBeanServerConnection(subject);
            return new WLXMBeanServerConnectionWrapper(mBeanServerConnection, locale);
        }
    }

    class WLXMBeanServerConnectionWrapper
    implements MBeanServerConnection {
        private MBeanServerConnection connection_;
        private Locale locale_;

        WLXMBeanServerConnectionWrapper(MBeanServerConnection mBeanServerConnection, Locale locale) {
            this.connection_ = mBeanServerConnection;
            this.locale_ = locale;
        }

        public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            return this.connection_.createMBean(string, objectName);
        }

        public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            return this.connection_.createMBean(string, objectName, objectName2);
        }

        public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            return this.connection_.createMBean(string, objectName, objectArray, stringArray);
        }

        public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            return this.connection_.createMBean(string, objectName, objectName2, objectArray, stringArray);
        }

        public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            this.connection_.unregisterMBean(objectName);
        }

        public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
            return this.connection_.getObjectInstance(objectName);
        }

        public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws IOException {
            return this.connection_.queryMBeans(objectName, queryExp);
        }

        public Set queryNames(ObjectName objectName, QueryExp queryExp) throws IOException {
            return this.connection_.queryNames(objectName, queryExp);
        }

        public boolean isRegistered(ObjectName objectName) throws IOException {
            return this.connection_.isRegistered(objectName);
        }

        public Integer getMBeanCount() throws IOException {
            return this.connection_.getMBeanCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            try {
                this.initializeJMXContext();
                Object object = this.connection_.getAttribute(objectName, string);
                return object;
            }
            finally {
                this.removeJMXContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                this.initializeJMXContext();
                AttributeList attributeList = this.connection_.getAttributes(objectName, stringArray);
                return attributeList;
            }
            finally {
                this.removeJMXContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            try {
                this.initializeJMXContext();
                this.connection_.setAttribute(objectName, attribute);
            }
            finally {
                this.removeJMXContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                this.initializeJMXContext();
                AttributeList attributeList2 = this.connection_.setAttributes(objectName, attributeList);
                return attributeList2;
            }
            finally {
                this.removeJMXContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            try {
                this.initializeJMXContext();
                Object object = this.connection_.invoke(objectName, string, objectArray, stringArray);
                return object;
            }
            finally {
                this.removeJMXContext();
            }
        }

        public String getDefaultDomain() throws IOException {
            return this.connection_.getDefaultDomain();
        }

        public String[] getDomains() throws IOException {
            return this.connection_.getDomains();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            try {
                this.initializeJMXContext();
                MBeanInfo mBeanInfo = this.connection_.getMBeanInfo(objectName);
                return mBeanInfo;
            }
            finally {
                this.removeJMXContext();
            }
        }

        public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, IOException {
            return this.connection_.isInstanceOf(objectName, string);
        }

        public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
            this.connection_.addNotificationListener(objectName, objectName2, notificationFilter, object);
        }

        public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
            this.connection_.addNotificationListener(objectName, notificationListener, notificationFilter, object);
        }

        public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.connection_.removeNotificationListener(objectName, objectName2);
        }

        public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.connection_.removeNotificationListener(objectName, objectName2, notificationFilter, object);
        }

        public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.connection_.removeNotificationListener(objectName, notificationListener);
        }

        public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.connection_.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
        }

        private void initializeJMXContext() {
            JMXContext jMXContext = JMXContextHelper.getJMXContext(true);
            jMXContext.setLocale(this.locale_);
            JMXContextHelper.putJMXContext(jMXContext);
        }

        private void removeJMXContext() {
            JMXContextHelper.removeJMXContext();
        }
    }
}

