/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;

public class HttpClientFactory {
    private HttpClientFactory() {
    }

    public static HttpClient createConnection(String scheme, String hostname, int port, String username, String password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return HttpClientFactory.createConnection(HttpFileSystemConfigBuilder.getInstance(), scheme, hostname, port, username, password, fileSystemOptions);
    }

    public static HttpClient createConnection(HttpFileSystemConfigBuilder builder, String scheme, String hostname, int port, String username, String password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        HttpClient client;
        try {
            MultiThreadedHttpConnectionManager mgr = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams connectionMgrParams = mgr.getParams();
            client = new HttpClient((HttpConnectionManager)mgr);
            HostConfiguration config = new HostConfiguration();
            config.setHost(hostname, port, scheme);
            if (fileSystemOptions != null) {
                Cookie[] cookies;
                UserAuthenticationData authData;
                UserAuthenticator proxyAuth;
                String proxyHost = builder.getProxyHost(fileSystemOptions);
                int proxyPort = builder.getProxyPort(fileSystemOptions);
                if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
                    config.setProxy(proxyHost, proxyPort);
                }
                if ((proxyAuth = builder.getProxyAuthenticator(fileSystemOptions)) != null && (authData = UserAuthenticatorUtils.authenticate(proxyAuth, new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD})) != null) {
                    UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, null)), UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, null)));
                    client.getState().setProxyCredentials(null, proxyHost, (Credentials)proxyCreds);
                }
                if ((cookies = builder.getCookies(fileSystemOptions)) != null) {
                    client.getState().addCookies(cookies);
                }
            }
            connectionMgrParams.setMaxConnectionsPerHost(config, builder.getMaxConnectionsPerHost(fileSystemOptions));
            connectionMgrParams.setMaxTotalConnections(builder.getMaxTotalConnections(fileSystemOptions));
            client.setHostConfiguration(config);
            if (username != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
                client.getState().setCredentials(null, hostname, (Credentials)creds);
            }
            client.executeMethod((HttpMethod)new HeadMethod());
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.http/connect.error", new Object[]{hostname}, (Throwable)exc);
        }
        return client;
    }
}

