/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.util;

import com.evermind.util.Base64Utils;
import java.util.ArrayList;
import java.util.Iterator;

public class NamedParameterList {
    private ArrayList m_names = new ArrayList();
    private ArrayList m_values = new ArrayList();

    public static NamedParameterList create() {
        return new NamedParameterList();
    }

    private NamedParameterList() {
    }

    public static NamedParameterList parse(String string) {
        return new NamedParameterList(string);
    }

    private NamedParameterList(String string) {
        int equalPos;
        int start = 0;
        while ((equalPos = string.indexOf(61, start)) >= 0) {
            int nameStart = Math.max(-1, string.lastIndexOf(32, equalPos));
            int valueEnd = NamedParameterList.getValueEndIndex(string, equalPos);
            String value = string.substring(equalPos + 1, valueEnd);
            if (NamedParameterList.isQuoted(value)) {
                value = value.substring(1, value.length() - 1);
            }
            this.put(string.substring(nameStart + 1, equalPos), value);
            start = valueEnd;
        }
    }

    public Iterator getParameterNames() {
        return this.m_names.iterator();
    }

    public int size() {
        return this.m_names.size();
    }

    public String get(String name) {
        int index = this.m_names.indexOf(name);
        return index < 0 ? (String)null : (String)this.m_values.get(index);
    }

    public byte[] getBase64Decoded(String key) {
        return Base64Utils.decode(this.get(key).toCharArray());
    }

    public void put(String name, String value) {
        if (this.m_names.contains(name)) {
            this.m_values.set(this.m_names.indexOf(name), value);
        } else {
            this.m_names.add(name);
            this.m_values.add(value);
        }
    }

    public void put(String name, byte[] value) {
        this.put(name, new String(Base64Utils.encode(value, -1)));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = this.getParameterNames();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            sb.append(key).append("=\"").append(this.get(key)).append('\"');
            if (!iterator.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static boolean isQuoted(String value) {
        return value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"");
    }

    private static int getValueEndIndex(String string, int equalPos) {
        int pos;
        char quote = '\u0000';
        int length = string.length();
        for (pos = equalPos; pos < length; ++pos) {
            char ch = string.charAt(pos);
            if (ch == quote) {
                quote = '\u0000';
            } else if (ch == '\'' || ch == '\"') {
                quote = ch;
            }
            if (quote == '\u0000' && Character.isWhitespace(ch)) break;
        }
        return pos;
    }
}

