/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.xa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.xa.RecoverableCommitStrategy;

public class GenericRecoverableCommitStrategy
implements RecoverableCommitStrategy {
    String m_oc4jCommitRecordTableName;

    public GenericRecoverableCommitStrategy(String oc4jCommitRecordTableName) {
        this.m_oc4jCommitRecordTableName = oc4jCommitRecordTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, Connection connection, boolean writeRecord) throws XAException {
        try {
            if (writeRecord) {
                String insert = this.getCommitSQLStatement(this.m_oc4jCommitRecordTableName);
                PreparedStatement ps = connection.prepareStatement(insert);
                try {
                    this.setValueOnPrepareStatement(ps, xid);
                    ps.execute();
                }
                finally {
                    ps.close();
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            String msg = DataSourceMessages.warningEmulatedXAResourceCommitFailed();
            XAException xaException = new XAException(msg + " : " + e);
            xaException.errorCode = -3;
            throw xaException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean isCommitted(Xid xid, Connection connection) throws XAException {
        try {
            String select = this.getIsCommittedSQLStatement(this.m_oc4jCommitRecordTableName);
            PreparedStatement ps = connection.prepareStatement(select);
            try {
                boolean bl;
                this.setValueOnPrepareStatement(ps, xid);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return bl;
            }
            finally {
                ps.close();
            }
        }
        catch (SQLException e) {
            XAException xaException = new XAException(e.toString());
            xaException.errorCode = -3;
            throw xaException;
        }
    }

    void setValueOnPrepareStatement(PreparedStatement ps, Xid xid) throws SQLException {
        ps.setString(1, GenericRecoverableCommitStrategy.getIdString(xid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(Connection connection) throws SQLException {
        if (this.m_oc4jCommitRecordTableName == null || this.m_oc4jCommitRecordTableName.length() == 0) {
            return false;
        }
        String selectAll = this.getIsAvailableSQLStatement(this.m_oc4jCommitRecordTableName);
        PreparedStatement ps = connection.prepareStatement(selectAll);
        try {
            ps.executeQuery();
        }
        finally {
            ps.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean purgeCommitRecords(Xid[] xids, Connection connection) {
        try {
            String ids = GenericRecoverableCommitStrategy.getIdsString(xids);
            String purge = this.getPurgeCommitRecordsSQLStatement(this.m_oc4jCommitRecordTableName, ids);
            Statement statement = connection.createStatement();
            try {
                statement.execute(purge);
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public byte[][] recoverCommitted(Connection connection) throws XAException {
        return new byte[0][];
    }

    protected String getCommitSQLStatement(String tableName) {
        return "insert into " + tableName + " (id) values (?)";
    }

    protected String getIsCommittedSQLStatement(String tableName) {
        return "select id from " + tableName + " where id=?";
    }

    protected String getIsAvailableSQLStatement(String tableName) {
        return "select id from " + tableName;
    }

    protected String getPurgeCommitRecordsSQLStatement(String tableName, Object ids) {
        return "delete " + tableName + " where id in (" + ids + ")";
    }

    protected static String getIdString(Xid xid) {
        byte[] bytes = xid.getGlobalTransactionId();
        StringBuffer buf = new StringBuffer();
        for (int x = 0; x < bytes.length; ++x) {
            int i;
            if (x > 0) {
                buf.append(".");
            }
            if ((i = bytes[x] & 0xFF) == 0) {
                buf.append("00");
                continue;
            }
            if (i <= 15) {
                buf.append('0').append(Integer.toString(i, 16));
                continue;
            }
            buf.append(Integer.toString(i, 16));
        }
        return buf.toString();
    }

    protected static String getIdsString(Xid[] xids) {
        StringBuffer buf = new StringBuffer();
        for (int x = 0; x < xids.length; ++x) {
            if (x > 0) {
                buf.append(",");
            }
            buf.append("'");
            buf.append(GenericRecoverableCommitStrategy.getIdString(xids[x]));
            buf.append("'");
        }
        return buf.toString();
    }
}

