/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.spi;

import com.evermind.security.User;
import com.evermind.server.ThreadState;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.ManagedDataSource;
import oracle.oc4j.sql.mbean.DMSUtils;
import oracle.oc4j.sql.security.CredentialUtility;
import oracle.oc4j.sql.spi.ConnectionHandle;
import oracle.oc4j.sql.spi.ConnectionRequestInfoImpl;
import oracle.oc4j.sql.spi.LocalTransactionImpl;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;
import oracle.oc4j.sql.spi.ManagedConnectionMetaDataImpl;
import oracle.oc4j.sql.spi.TxState;
import oracle.oc4j.sql.spi.XAResourceWrapper;

public class ManagedConnectionImpl
implements ManagedConnection,
LazyEnlistableManagedConnection,
DissociatableManagedConnection {
    public static final String ORACLE_ACTIVATE_SQL_TRACE_STATEMENT = "ALTER SESSION SET SQL_TRACE = true";
    public static final String ORACLE_DEACTIVATE_SQL_TRACE_STATEMENT = "ALTER SESSION SET SQL_TRACE = false";
    private XAConnection m_xaConnection;
    private Connection m_connection = null;
    private ManagedConnectionFactoryImpl m_managedConnectionFactory;
    private ManagedConnectionMetaDataImpl m_managedConnectionMetaDataImpl;
    private HashSet m_connectionEventListeners = new HashSet();
    private boolean m_supportsGlobalTx = true;
    private boolean m_previousCommitOption;
    private boolean m_currentCommitOption;
    private boolean m_destroyed = false;
    private PasswordCredential m_credential = null;
    private ConnectionRequestInfoImpl m_connectionRequestInfoImpl = null;
    private Subject m_subject = null;
    private TxState m_transactionState = null;
    private Map m_statementCache;
    private int m_maxStatementCacheSize = -1;
    private Map m_handles = new WeakHashMap();
    private boolean m_activateOracleSQLTrace = false;
    private boolean m_oracleSQLTraceActive = false;
    private long m_begUseTime;
    private boolean m_isValid = true;
    private boolean m_inUse = false;
    private boolean m_manageLocalTx = true;
    private boolean m_localTxDetected = false;
    private ConnectionUseStrategy m_connectionUseStrategy;
    static /* synthetic */ Class class$java$util$Properties;

    protected ManagedConnectionImpl(ManagedConnectionFactoryImpl managedConnectionFactory, XAConnection xaConnection, Subject subject, ConnectionRequestInfoImpl connectionRequestInfo) throws ResourceException {
        DataSourceConnectionPool dsConnectionPool;
        this.m_xaConnection = xaConnection;
        if (connectionRequestInfo == null) {
            connectionRequestInfo = new ConnectionRequestInfoImpl(null, null);
        }
        this.m_connectionRequestInfoImpl = connectionRequestInfo;
        this.m_subject = subject;
        this.m_credential = CredentialUtility.getCredential(managedConnectionFactory, subject, connectionRequestInfo);
        this.initForUse(managedConnectionFactory, true);
        ManagedDataSource managedDataSource = this.m_managedConnectionFactory.getManagedDataSource();
        if (managedDataSource != null) {
            this.m_manageLocalTx = managedDataSource.getManageLocalTransactions();
        }
        if ((dsConnectionPool = this.m_managedConnectionFactory.getDataSourceConnectionPool()) != null) {
            dsConnectionPool.connectionCreated();
        }
    }

    protected void initOnMatch(ManagedConnectionFactoryImpl managedConnectionFactory, ConnectionRequestInfoImpl connectionRequestInfoImpl) throws ResourceException {
        this.initForUse(managedConnectionFactory, false);
        boolean isTransactional = connectionRequestInfoImpl.isTransactional();
        this.getConnectionRequestInfo().setTransactional(isTransactional);
    }

    private ConnectionUseStrategy getConnectionUseStrategy() {
        if (this.m_connectionUseStrategy == null) {
            this.m_connectionUseStrategy = this.m_managedConnectionFactory.isOracle() ? new OracleConnectionUseStrategy() : new GenericConnectionUseStrategy();
        }
        return this.m_connectionUseStrategy;
    }

    private void initForUse(ManagedConnectionFactoryImpl managedConnectionFactory, boolean newInstance) throws ResourceException {
        ManagedDataSource mds;
        this.setManagedConnectionFactory(managedConnectionFactory);
        this.getConnectionUseStrategy().initForUse();
        if (this.m_managedConnectionFactory.isOracleSQLTraceActive() || !newInstance) {
            this.setActivateOracleSQLTrace(this.m_oracleSQLTraceActive);
        }
        if (!this.m_managedConnectionFactory.isICC() && this.m_maxStatementCacheSize != this.m_managedConnectionFactory.getNumCachedStatements()) {
            this.initStatementCache();
        }
        try {
            this.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new ResourceException(e.toString(), (Throwable)e);
        }
        this.m_begUseTime = System.currentTimeMillis();
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER && (mds = this.m_managedConnectionFactory.getManagedDataSource()) != null) {
            mds.getDebug().physicalConnectionObtained(this);
        }
    }

    private void initStatementCache() {
        int maxStatementCacheSize;
        int tempSize = this.m_managedConnectionFactory.getNumCachedStatements();
        if (tempSize < 0) {
            tempSize = 0;
        }
        this.m_maxStatementCacheSize = maxStatementCacheSize = tempSize;
        if (this.m_maxStatementCacheSize == 0) {
            this.m_statementCache = null;
            return;
        }
        LinkedHashMap cache = new LinkedHashMap(maxStatementCacheSize + 1, 0.75f, true){

            public boolean removeEldestEntry(Map.Entry eldest) {
                if (this.size() > maxStatementCacheSize) {
                    try {
                        ((Statement)((StatementCacheEntry)eldest.getValue()).getStatement()).close();
                    }
                    catch (SQLException e) {
                        DataSourceMessages.warningMCI_InitStatementCacheClosePreparedStatement(e);
                    }
                    return true;
                }
                return false;
            }
        };
        this.m_statementCache = Collections.synchronizedMap(cache);
    }

    private void destroyStatementCache() {
        if (this.m_statementCache != null) {
            Iterator iterator = this.m_statementCache.values().iterator();
            while (iterator.hasNext()) {
                Statement statement = (Statement)((StatementCacheEntry)iterator.next()).getStatement();
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    DataSourceMessages.warningMCI_DestroyStatementCacheClosePreparedStatement(e);
                }
            }
            this.m_statementCache.clear();
            this.m_statementCache = null;
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (!this.m_managedConnectionFactory.isManagedConnectionMatch(this, subject, (ConnectionRequestInfoImpl)connectionRequestInfo)) {
            throw new ResourceException("Credentials do not match : reauthentication is not supported.");
        }
        try {
            ConnectionHandle connectionHandle;
            if (this.m_activateOracleSQLTrace) {
                this.activateOracleSQLTrace();
            }
            if ((connectionHandle = (ConnectionHandle)this.getConnectionHandle()).oc4j_isTransactional() && this.m_managedConnectionFactory.isMinimalManagement()) {
                this.setupTransaction();
            }
            return connectionHandle;
        }
        catch (SQLException e) {
            throw new ResourceException("Can't create a connection handle : " + e.toString());
        }
    }

    private Object getConnectionHandle() throws SQLException {
        return ConnectionHandle.getConnectionHandle(this.m_managedConnectionFactory.getBCELProxyFactory(), this.m_connection, this);
    }

    public void destroy() throws ResourceException {
        if (this.m_destroyed) {
            return;
        }
        this._cleanup(true);
        try {
            block10: {
                try {
                    if (this.m_oracleSQLTraceActive) {
                        this.deactivateOracleSQLTrace();
                    }
                    if (this.m_statementCache != null) {
                        this.destroyStatementCache();
                    }
                    if (this.m_connection != null) {
                        this.m_connection.close();
                    }
                    if (this.m_xaConnection == null) break block10;
                    this.m_xaConnection.close();
                }
                catch (SQLException e) {
                    throw new ResourceException(e.toString(), (Throwable)e);
                }
            }
            Object var3_1 = null;
            DataSourceConnectionPool dsConnectionPool = this.m_managedConnectionFactory.getDataSourceConnectionPool();
            if (dsConnectionPool != null) {
                dsConnectionPool.connectionClosed();
            }
            this.m_destroyed = true;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            DataSourceConnectionPool dsConnectionPool = this.m_managedConnectionFactory.getDataSourceConnectionPool();
            if (dsConnectionPool != null) {
                dsConnectionPool.connectionClosed();
            }
            this.m_destroyed = true;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanup() throws ResourceException {
        ResourceException resourceException = null;
        try {
            try {
                if (this.m_transactionState != null && this.m_transactionState.isLocalTxActive()) {
                    DataSourceMessages.finerUncommittedLocalTxDetected();
                    this.commitLocal();
                }
            }
            catch (SQLException e) {
                resourceException = new ResourceException(e.toString());
                resourceException.initCause((Throwable)e);
                throw resourceException;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                this._cleanup(false);
                throw throwable;
            }
            catch (ResourceException re) {
                ResourceException resourceException2;
                if (resourceException == null) {
                    resourceException2 = re;
                    throw resourceException2;
                }
                resourceException2 = resourceException;
                throw resourceException2;
            }
        }
        try {}
        catch (ResourceException re) {
            ResourceException resourceException3;
            if (resourceException == null) {
                resourceException3 = re;
                throw resourceException3;
            }
            resourceException3 = resourceException;
            throw resourceException3;
        }
        this._cleanup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cleanup(boolean onDestroy) throws ResourceException {
        if (this.m_inUse) {
            try {
                ManagedDataSource mds;
                this.invalidateConnectionHandles();
                DataSourceConnectionPool dsConnectionPool = this.m_managedConnectionFactory.getDataSourceConnectionPool();
                if (dsConnectionPool != null && DMSUtils.isDMSActive()) {
                    dsConnectionPool.incrementUseTime(System.currentTimeMillis() - this.m_begUseTime);
                }
                if (!onDestroy) {
                    this.getConnectionUseStrategy().cleanup();
                }
                this.m_localTxDetected = false;
                Object var4_3 = null;
                this.m_inUse = false;
                if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER && (mds = this.m_managedConnectionFactory.getManagedDataSource()) != null) {
                    mds.getDebug().physicalConnectionReleased(this);
                }
            }
            catch (Throwable throwable) {
                ManagedDataSource mds;
                Object var4_4 = null;
                this.m_inUse = false;
                if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER && (mds = this.m_managedConnectionFactory.getManagedDataSource()) != null) {
                    mds.getDebug().physicalConnectionReleased(this);
                }
                throw throwable;
            }
        }
    }

    public void associateConnection(Object connectionHandle) throws ResourceException {
        ((ConnectionHandle)connectionHandle).oc4j_associateManagedConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        ManagedConnectionImpl managedConnectionImpl = this;
        synchronized (managedConnectionImpl) {
            this.m_connectionEventListeners.add(connectionEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        ManagedConnectionImpl managedConnectionImpl = this;
        synchronized (managedConnectionImpl) {
            this.m_connectionEventListeners.remove(connectionEventListener);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.m_xaConnection != null) {
            try {
                return new XAResourceWrapper(this.m_xaConnection.getXAResource(), this);
            }
            catch (SQLException e) {
                throw new ResourceException(e.toString(), (Throwable)e);
            }
        }
        throw new ResourceException("Can not get an XAResource for this connection.");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return new LocalTransactionImpl(this);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.m_managedConnectionMetaDataImpl == null) {
            try {
                DatabaseMetaData dbMetaData = this.m_connection.getMetaData();
                this.m_managedConnectionMetaDataImpl = new ManagedConnectionMetaDataImpl(dbMetaData.getDatabaseProductName(), dbMetaData.getDatabaseProductName(), dbMetaData.getMaxConnections(), dbMetaData.getUserName());
            }
            catch (SQLException e) {
                throw new ResourceException(e.toString(), (Throwable)e);
            }
        }
        return this.m_managedConnectionMetaDataImpl;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.m_managedConnectionFactory.setLogWriter(printWriter);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.m_managedConnectionFactory.getLogWriter();
    }

    public boolean isDestroyed() {
        return this.m_destroyed;
    }

    protected synchronized void associateConnectionProxy(ConnectionHandle proxy) throws SQLException {
        if (proxy == null) {
            return;
        }
        this.m_handles.put(proxy, null);
        proxy.oc4j_associate();
        this.m_inUse = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void dissociateConnectionProxy(ConnectionHandle proxy) throws SQLException {
        try {
            proxy.oc4j_dissociate();
        }
        finally {
            this.m_handles.remove(proxy);
        }
    }

    protected Connection getConnection() {
        return this.m_connection;
    }

    protected void setAutoCommit(boolean commitOption) throws SQLException {
        if (commitOption != this.m_currentCommitOption) {
            this.m_currentCommitOption = commitOption;
            this.m_connection.setAutoCommit(commitOption);
        }
    }

    protected void setCurrentCommitOption(boolean commitOption) {
        this.m_currentCommitOption = commitOption;
    }

    protected void startLocalTransaction() throws SQLException, ResourceException {
        this.getTxState();
        this.m_transactionState.localTxAction(TxState.BEGIN_LOCAL);
        this.m_previousCommitOption = this.m_currentCommitOption;
        this.m_connection.setAutoCommit(false);
        this.localTransactionStarted();
    }

    protected void callCommit() throws SQLException, ResourceException {
        this.m_localTxDetected = false;
        if (this.m_transactionState != null && this.m_transactionState.isLocalTxActive()) {
            this.commitLocal();
        } else {
            this.m_connection.commit();
        }
    }

    private void commitLocal() throws SQLException {
        this.m_transactionState.localTxAction(TxState.COMMIT_LOCAL);
        this.m_connection.commit();
        if (this.m_previousCommitOption) {
            this.m_connection.setAutoCommit(true);
        }
        this.localTransactionCommitted();
    }

    protected void callRollback() throws SQLException, ResourceException {
        this.m_localTxDetected = false;
        if (this.m_transactionState != null && this.m_transactionState.isLocalTxActive()) {
            this.rollbackLocal();
        } else {
            this.m_connection.rollback();
        }
    }

    private void rollbackLocal() throws SQLException {
        this.m_transactionState.localTxAction(TxState.ROLLBACK_LOCAL);
        this.m_connection.rollback();
        if (this.m_previousCommitOption) {
            this.m_connection.setAutoCommit(true);
        }
        this.localTransactionRolledback();
    }

    protected void callSetAutoCommit(boolean autoCommit) throws SQLException, ResourceException {
        this.m_localTxDetected = false;
        if (this.m_transactionState != null && this.m_transactionState.isLocalTxActive()) {
            this.m_transactionState.localTxAction(TxState.COMMIT_LOCAL);
            this.setAutoCommit(autoCommit);
            this.localTransactionCommitted();
        } else {
            this.setAutoCommit(autoCommit);
        }
    }

    protected synchronized void connectionClosed(ConnectionHandle connectionHandle) {
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 1);
        connectionEvent.setConnectionHandle((Object)connectionHandle);
        Iterator iterator = this.m_connectionEventListeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    protected synchronized void connectionErrorOccured() {
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 5);
        Iterator iterator = this.m_connectionEventListeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    protected synchronized void localTransactionStarted() throws SQLException {
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 2);
        Iterator<Object> iterator = this.m_connectionEventListeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.localTransactionStarted(connectionEvent);
        }
        iterator = this.m_handles.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionHandle connectionHandle = (ConnectionHandle)iterator.next();
            connectionHandle.oc4j_localTransactionStarted();
        }
    }

    protected synchronized void localTransactionCommitted() throws SQLException {
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 3);
        Iterator<Object> iterator = this.m_connectionEventListeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.localTransactionCommitted(connectionEvent);
        }
        iterator = this.m_handles.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionHandle connectionHandle = (ConnectionHandle)iterator.next();
            connectionHandle.oc4j_localTransactionCommitted();
        }
    }

    protected synchronized void localTransactionRolledback() throws SQLException {
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 4);
        Iterator<Object> iterator = this.m_connectionEventListeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.localTransactionRolledback(connectionEvent);
        }
        iterator = this.m_handles.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionHandle connectionHandle = (ConnectionHandle)iterator.next();
            connectionHandle.oc4j_localTransactionRolledback();
        }
    }

    protected synchronized void xaResourceStartCalled(int flags) throws SQLException {
        Iterator iterator = this.m_handles.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionHandle connectionHandle = (ConnectionHandle)iterator.next();
            connectionHandle.oc4j_xaResourceStartCalled(flags);
        }
    }

    protected synchronized void xaResourceEndCalled(int flags) throws SQLException {
        Iterator iterator = this.m_handles.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionHandle connectionHandle = (ConnectionHandle)iterator.next();
            connectionHandle.oc4j_xaResourceEndCalled(flags);
        }
    }

    protected synchronized void xaResourceCommitCalled() {
        Iterator iterator = this.m_handles.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionHandle connectionHandle = (ConnectionHandle)iterator.next();
            connectionHandle.oc4j_xaResourceCommitCalled();
        }
    }

    protected synchronized void xaResourceRollbackCalled() {
        Iterator iterator = this.m_handles.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionHandle connectionHandle = (ConnectionHandle)iterator.next();
            connectionHandle.oc4j_xaResourceRollbackCalled();
        }
    }

    protected final ConnectionRequestInfoImpl getConnectionRequestInfo() {
        return this.m_connectionRequestInfoImpl;
    }

    protected final PasswordCredential getCredential() {
        return this.m_credential;
    }

    protected XAConnection getXAConnection() {
        return this.m_xaConnection;
    }

    protected final void setupTransaction() throws SQLException, ResourceException {
        this.getTxState();
        if (this.m_supportsGlobalTx && !this.m_transactionState.isGlobalTxActive()) {
            try {
                this.m_managedConnectionFactory.enlist(this);
            }
            catch (ResourceException e) {
                SQLException sqlException = new SQLException(e.toString());
                sqlException.initCause(e);
                throw sqlException;
            }
        }
        if (!this.m_currentCommitOption && !this.m_transactionState.isTxActive()) {
            if (this.m_manageLocalTx) {
                this.startLocalTransaction();
            }
            this.m_localTxDetected = true;
        }
    }

    protected final boolean isGlobalTxActive() {
        if (this.m_transactionState == null) {
            return false;
        }
        return this.m_transactionState.isGlobalTxActive();
    }

    protected final boolean isLocalTxActive() {
        if (this.m_transactionState == null) {
            return false;
        }
        return this.m_transactionState.isLocalTxActive();
    }

    protected final TxState getTxState() {
        if (this.m_transactionState == null) {
            this.m_transactionState = new TxState();
        }
        return this.m_transactionState;
    }

    private void invalidateConnectionHandles() throws ResourceException {
        Iterator iterator = this.m_handles.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionHandle handle = (ConnectionHandle)iterator.next();
            try {
                handle.oc4j_invalidate();
            }
            catch (SQLException e) {
                throw new ResourceException(e.toString());
            }
        }
        this.m_handles.clear();
    }

    protected Object getCachedObject(Object key) {
        StatementCacheEntry entry;
        if (this.m_statementCache != null && (entry = (StatementCacheEntry)this.m_statementCache.get(key)) != null) {
            if (!entry.isShareable()) {
                this.m_statementCache.remove(key);
            }
            return entry.getStatement();
        }
        return null;
    }

    protected boolean addObjectToCache(Object key, Object obj, boolean shareable) {
        if (obj != null && this.m_statementCache != null) {
            this.m_statementCache.put(key, new StatementCacheEntry(obj, shareable));
            return true;
        }
        return false;
    }

    protected ManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.m_managedConnectionFactory;
    }

    protected void setManagedConnectionFactory(ManagedConnectionFactoryImpl managedConnectionFactory) {
        this.m_managedConnectionFactory = managedConnectionFactory;
        this.m_supportsGlobalTx = this.m_managedConnectionFactory.supportsGlobalTx();
    }

    protected boolean supportsGlobalTx() {
        return this.m_supportsGlobalTx;
    }

    public void setManageLocalTx(boolean manageLocalTx) {
        this.m_manageLocalTx = manageLocalTx;
    }

    public boolean isActivateOracleSQLTrace() {
        return this.m_activateOracleSQLTrace;
    }

    public void setActivateOracleSQLTrace(boolean activateOracleSQLTrace) {
        if (activateOracleSQLTrace) {
            if (this.activateOracleSQLTrace()) {
                this.m_activateOracleSQLTrace = true;
            }
        } else {
            this.deactivateOracleSQLTrace();
            this.m_activateOracleSQLTrace = false;
        }
    }

    public boolean isOracleSQLTraceActive() {
        return this.m_oracleSQLTraceActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean activateOracleSQLTrace() {
        boolean retVal = false;
        if (this.m_oracleSQLTraceActive || this.m_connection == null) return retVal;
        Statement statement = null;
        statement = this.m_connection.createStatement();
        statement.execute(ORACLE_ACTIVATE_SQL_TRACE_STATEMENT);
        this.m_oracleSQLTraceActive = true;
        retVal = true;
        Object var5_3 = null;
        if (statement == null) return retVal;
        try {
            statement.close();
            return retVal;
        }
        catch (SQLException sqlException2) {
            DataSourceMessages.warningMCI_activateOracleSQLTraceCloseException(sqlException2);
        }
        return retVal;
        {
            catch (SQLException sqlException) {
                DataSourceMessages.warningMCI_activateOracleSQLTraceException(sqlException);
                Object var5_4 = null;
                if (statement == null) return retVal;
                try {
                    statement.close();
                    return retVal;
                }
                catch (SQLException sqlException2) {
                    DataSourceMessages.warningMCI_activateOracleSQLTraceCloseException(sqlException2);
                }
                return retVal;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sqlException2) {
                DataSourceMessages.warningMCI_activateOracleSQLTraceCloseException(sqlException2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deactivateOracleSQLTrace() {
        if (!this.m_oracleSQLTraceActive || this.m_connection == null) return;
        Statement statement = null;
        statement = this.m_connection.createStatement();
        statement.execute(ORACLE_DEACTIVATE_SQL_TRACE_STATEMENT);
        this.m_oracleSQLTraceActive = false;
        Object var4_2 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException sqlException2) {
            DataSourceMessages.warningMCI_activateOracleSQLTraceCloseException(sqlException2);
        }
        return;
        {
            catch (SQLException sqlException) {
                DataSourceMessages.warningMCI_activateOracleSQLTraceException(sqlException);
                Object var4_3 = null;
                if (statement == null) return;
                try {
                    statement.close();
                    return;
                }
                catch (SQLException sqlException2) {
                    DataSourceMessages.warningMCI_activateOracleSQLTraceCloseException(sqlException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException sqlException2) {
                DataSourceMessages.warningMCI_activateOracleSQLTraceCloseException(sqlException2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dissociateConnections() throws ResourceException {
        ManagedConnectionImpl managedConnectionImpl = this;
        synchronized (managedConnectionImpl) {
            Iterator iterator = this.m_handles.keySet().iterator();
            while (iterator.hasNext()) {
                ConnectionHandle connectionHandle = (ConnectionHandle)iterator.next();
                try {
                    connectionHandle.oc4j_dissociate();
                }
                catch (SQLException e) {
                    throw new ResourceException(e.toString(), (Throwable)e);
                }
            }
            this.m_handles.clear();
        }
    }

    protected Map getStatementCache() {
        return this.m_statementCache;
    }

    protected int getMaxStatementCacheSize() {
        return this.m_maxStatementCacheSize;
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public void setValid(boolean isValid) {
        this.m_isValid = isValid;
    }

    class OracleConnectionUseStrategy
    extends GenericConnectionUseStrategy {
        OracleConnectionUseStrategy() {
        }

        public void initForUse() throws ResourceException {
            super.initForUse();
            if (ManagedConnectionImpl.this.m_managedConnectionFactory.isProxySession()) {
                try {
                    String name;
                    User user = ThreadState.getCurrentState().getUser();
                    if (user != null && (name = user.getName()) != null && !name.equalsIgnoreCase("anonymous")) {
                        Properties props = new Properties();
                        props.setProperty("PROXY_USER_NAME", name);
                        Class<?> oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection", true, Thread.currentThread().getContextClassLoader());
                        Integer proxyType = new Integer(oracleConnectionClass.getField("PROXYTYPE_USER_NAME").getInt(null));
                        Method openProxySessionMethod = oracleConnectionClass.getMethod("openProxySession", Integer.TYPE, class$java$util$Properties == null ? (class$java$util$Properties = ManagedConnectionImpl.class$("java.util.Properties")) : class$java$util$Properties);
                        openProxySessionMethod.invoke((Object)ManagedConnectionImpl.this.m_connection, proxyType, props);
                    }
                }
                catch (Exception e) {
                    throw new ResourceException(e.toString(), (Throwable)e);
                }
            }
        }

        public void cleanup() throws ResourceException {
            if (ManagedConnectionImpl.this.m_managedConnectionFactory.isProxySession()) {
                try {
                    Class<?> oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection", true, Thread.currentThread().getContextClassLoader());
                    Method isProxySessionMethod = oracleConnectionClass.getMethod("isProxySession", new Class[0]);
                    Boolean isProxy = (Boolean)isProxySessionMethod.invoke((Object)ManagedConnectionImpl.this.m_connection, new Object[0]);
                    if (isProxy.booleanValue()) {
                        Integer proxySession = new Integer(oracleConnectionClass.getField("PROXY_SESSION").getInt(null));
                        Method closeMethod = oracleConnectionClass.getMethod("close", Integer.TYPE);
                        closeMethod.invoke((Object)ManagedConnectionImpl.this.m_connection, proxySession);
                    }
                }
                catch (Exception e) {
                    throw new ResourceException(e.toString(), (Throwable)e);
                }
            }
            super.cleanup();
        }
    }

    class GenericConnectionUseStrategy
    implements ConnectionUseStrategy {
        GenericConnectionUseStrategy() {
        }

        public void initForUse() throws ResourceException {
            if (ManagedConnectionImpl.this.m_connection == null) {
                try {
                    if (ManagedConnectionImpl.this.m_xaConnection == null) {
                        ManagedConnectionImpl.this.m_xaConnection = ManagedConnectionImpl.this.m_managedConnectionFactory.createXAConnection(ManagedConnectionImpl.this.m_subject, ManagedConnectionImpl.this.m_connectionRequestInfoImpl);
                    }
                    ManagedConnectionImpl.this.m_connection = ManagedConnectionImpl.this.m_xaConnection.getConnection();
                    if (ManagedConnectionImpl.this.m_connection == null) {
                        throw new SQLException("Unable to get a physical connection from the database...there are no connections available.");
                    }
                    ManagedConnectionImpl.this.m_currentCommitOption = ManagedConnectionImpl.this.m_connection.getAutoCommit();
                }
                catch (SQLException e) {
                    ResourceException resourceException = new ResourceException(e.toString());
                    resourceException.initCause((Throwable)e);
                    throw resourceException;
                }
            }
        }

        public void cleanup() throws ResourceException {
            try {
                if (ManagedConnectionImpl.this.m_managedConnectionFactory.isEmulatedXADataSource()) {
                    if (!ManagedConnectionImpl.this.m_manageLocalTx && ManagedConnectionImpl.this.m_localTxDetected) {
                        ManagedConnectionImpl.this.m_connection.close();
                        ManagedConnectionImpl.this.m_connection = null;
                        ManagedConnectionImpl.this.m_xaConnection.close();
                        ManagedConnectionImpl.this.m_xaConnection = null;
                    }
                } else {
                    ManagedConnectionImpl.this.m_connection.close();
                    ManagedConnectionImpl.this.m_connection = null;
                }
            }
            catch (SQLException e) {
                ResourceException resourceException = new ResourceException(e.toString());
                resourceException.initCause((Throwable)e);
                throw resourceException;
            }
        }
    }

    static interface ConnectionUseStrategy {
        public void initForUse() throws ResourceException;

        public void cleanup() throws ResourceException;
    }

    class StatementCacheEntry {
        private boolean m_shareable;
        private Object m_statement;

        public boolean isShareable() {
            return this.m_shareable;
        }

        public Object getStatement() {
            return this.m_statement;
        }

        public StatementCacheEntry(Object statement, boolean shareable) {
            this.m_statement = statement;
            this.m_shareable = shareable;
        }
    }
}

