/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import javax.management.ObjectName;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.management.mbeans.JDBCBase;

public class MBeanUtils {
    public static String JDBC_DRIVER_MBEAN_NAME_SUFFIX = "-Connection Factory";
    public static final String TEST_CONNECTION_SUCCESSFUL_STRING = "Test was successful.";

    public static String getJdbcDriver(String connectionPoolName, JDBCBase mbean, String applicationName) throws JMXException {
        String pattern = mbean.getDomain() + ":j2eeType=JDBCDriver,name=" + ObjectName.quote(connectionPoolName + JDBC_DRIVER_MBEAN_NAME_SUFFIX) + ",J2EEApplication=" + applicationName + ",J2EEServer=" + mbean.getJ2eeServerName();
        ObjectName[] objs = mbean.getObjectNameForPattern(pattern);
        if (objs == null || objs.length == 0) {
            return "";
        }
        return objs[0].toString();
    }

    public static String getJDBCDataSourceObjectName(String dataSourceName, String resourceName, String applicationName, String j2eeServerName) {
        dataSourceName = dataSourceName == null ? "" : ObjectName.quote(dataSourceName);
        String string = resourceName = resourceName == null ? "" : ObjectName.quote(resourceName);
        if (applicationName == null) {
            applicationName = "";
        }
        if (j2eeServerName == null) {
            j2eeServerName = "";
        }
        return ":j2eeType=JDBCDataSource,name=" + dataSourceName + ",JDBCResource=" + resourceName + ",J2EEApplication=" + applicationName + ",J2EEServer=" + j2eeServerName;
    }
}

