/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import javax.management.MalformedObjectNameException;
import javax.management.j2ee.statistics.JDBCConnectionStats;
import javax.management.j2ee.statistics.TimeStatistic;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatsImpl;
import oracle.oc4j.sql.mbean.DMSJDBCConnectionStats;
import oracle.oc4j.sql.mbean.ManagedJDBCDataSource;

public class JDBCConnectionStatsImpl
extends DMSStatsImpl
implements JDBCConnectionStats {
    private transient ManagedJDBCDataSource m_jdbcDataSourceMBean = null;
    private transient DMSJDBCConnectionStats m_dmsJDBCConnectionStats = null;

    public JDBCConnectionStatsImpl(ManagedJDBCDataSource jdbcDataSourceMBean, DMSJDBCConnectionStats dmsJDBCConnectionStats) {
        if (jdbcDataSourceMBean == null) {
            String msg = DataSourceMessages.warningJDBCConnectionStatsImplMBeanNull();
            throw new IllegalArgumentException(msg);
        }
        this.m_jdbcDataSourceMBean = jdbcDataSourceMBean;
        if (dmsJDBCConnectionStats == null) {
            String msg = DataSourceMessages.warningJDBCConnectionStatsImplDMSConnectionStatsNull();
            throw new IllegalArgumentException(msg);
        }
        this.m_dmsJDBCConnectionStats = dmsJDBCConnectionStats;
        this.addDMSStats(dmsJDBCConnectionStats.getDMSStatisticDefinitions());
        this.initStats();
    }

    public String getJdbcDataSource() {
        try {
            return this.m_jdbcDataSourceMBean.getobjectName();
        }
        catch (MalformedObjectNameException e) {
            DataSourceMessages.warningJDBCConnectionStatsImplGetJdbcDataSource(this.m_jdbcDataSourceMBean.getName());
            return null;
        }
    }

    public TimeStatistic getWaitTime() {
        return (TimeStatistic)super.getStatistic("WaitTime");
    }

    public TimeStatistic getUseTime() {
        return (TimeStatistic)super.getStatistic("UseTime");
    }

    public ManagedJDBCDataSource getJdbcDataSourceMBean() {
        return this.m_jdbcDataSourceMBean;
    }

    public DMSJDBCConnectionStats getDmsJDBCConnectionStats() {
        return this.m_dmsJDBCConnectionStats;
    }
}

