/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import java.util.HashMap;
import java.util.Vector;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.DataSourceBaseConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.config.NativeDataSourceConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataSourcesConfig
extends ConfigObject {
    public static final String ROOT_NODE_NAME = "data-sources";
    public static final String DMS_UPDATE_INTERVAL_ATTRIBUTE = "dms-update-interval";
    public static final int DEFAULT_DMS_UPDATE_INTERVAL = 60000;
    private int m_dmsUpdateInterval = 60000;
    private ManagedDataSourceConfig[] m_managedDataSources = new ManagedDataSourceConfig[0];
    private NativeDataSourceConfig[] m_nativeDataSources = new NativeDataSourceConfig[0];
    private ConnectionPoolConfig[] m_connectionPools = new ConnectionPoolConfig[0];

    public DataSourcesConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        this.setDMSUpdateInterval();
        this.setConnectionPools();
        this.setManagedDataSources();
        this.setNativeDataSources();
    }

    public DataSourcesConfig(ManagedDataSourceConfig[] managedDataSources, NativeDataSourceConfig[] nativeDataSources, ConnectionPoolConfig[] connectionPools) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setConnectionPools(connectionPools);
        this.setManagedDataSources(managedDataSources);
        this.setNativeDataSources(nativeDataSources);
    }

    public int getDMSUpdateInterval() {
        return this.m_dmsUpdateInterval;
    }

    public void setDMSUpdateInterval(int dmsUpdateInterval) {
        this.m_dmsUpdateInterval = dmsUpdateInterval;
    }

    private void setDMSUpdateInterval() throws DataSourceConfigException {
        this.setDMSUpdateInterval(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), DMS_UPDATE_INTERVAL_ATTRIBUTE, 60000));
    }

    public ManagedDataSourceConfig[] getManagedDataSources() {
        return this.m_managedDataSources;
    }

    private void validateManagedDataSources() throws DataSourceConfigException {
        HashMap<String, ConnectionPoolConfig> connectionPools = new HashMap<String, ConnectionPoolConfig>();
        for (int i = 0; i < this.m_connectionPools.length; ++i) {
            connectionPools.put(this.m_connectionPools[i].getName(), this.m_connectionPools[i]);
        }
        HashMap<String, String> jndis = new HashMap<String, String>();
        for (int i = 0; i < this.m_nativeDataSources.length; ++i) {
            jndis.put(this.m_nativeDataSources[i].getJndiName(), this.m_nativeDataSources[i].getJndiName());
        }
        HashMap<String, ManagedDataSourceConfig> mds = new HashMap<String, ManagedDataSourceConfig>();
        for (int i = 0; i < this.m_managedDataSources.length; ++i) {
            String name = this.m_managedDataSources[i].getName();
            if (mds.get(name) != null) {
                throw new DataSourceConfigException("The managed data source name '" + name + "' must be unique.");
            }
            mds.put(name, this.m_managedDataSources[i]);
            String jndiName = this.m_managedDataSources[i].getJndiName();
            if (jndis.get(jndiName) != null) {
                throw new DataSourceConfigException("The JNDI name '" + jndiName + "' for managed data source '" + name + "' must be unique across all data sources.");
            }
            jndis.put(jndiName, jndiName);
            if (connectionPools.get(this.m_managedDataSources[i].getConnectionPoolName()) != null) continue;
            throw new DataSourceConfigException("The connection pool '" + this.m_managedDataSources[i].getConnectionPoolName() + "' referred to by managed data source '" + name + "' does not identify an existing connection pool.");
        }
    }

    public void setManagedDataSources(ManagedDataSourceConfig[] managedDataSources) throws DataSourceConfigException {
        if (managedDataSources == null) {
            managedDataSources = new ManagedDataSourceConfig[]{};
        }
        this.m_managedDataSources = managedDataSources;
        this.validateManagedDataSources();
    }

    private void setManagedDataSources() throws DataSourceConfigException {
        Vector children = this.getNamedChildren("managed-data-source");
        int numChildren = children.size();
        ManagedDataSourceConfig[] managedDataSources = new ManagedDataSourceConfig[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            managedDataSources[i] = new ManagedDataSourceConfig((Node)children.get(i));
        }
        this.setManagedDataSources(managedDataSources);
    }

    public NativeDataSourceConfig[] getNativeDataSources() {
        return this.m_nativeDataSources;
    }

    private void validateNativeDataSources() throws DataSourceConfigException {
        HashMap<String, String> jndis = new HashMap<String, String>();
        for (int i = 0; i < this.m_managedDataSources.length; ++i) {
            jndis.put(this.m_managedDataSources[i].getJndiName(), this.m_managedDataSources[i].getJndiName());
        }
        HashMap<String, NativeDataSourceConfig> dataSources = new HashMap<String, NativeDataSourceConfig>();
        for (int i = 0; i < this.m_nativeDataSources.length; ++i) {
            String name = this.m_nativeDataSources[i].getName();
            if (dataSources.get(name) != null) {
                throw new DataSourceConfigException("The native data source name '" + name + "' must be unique.");
            }
            dataSources.put(name, this.m_nativeDataSources[i]);
            String jndiName = this.m_nativeDataSources[i].getJndiName();
            if (jndis.get(jndiName) != null) {
                throw new DataSourceConfigException("The JNDI name '" + jndiName + "' for native data source '" + name + "' must be unique across all data sources.");
            }
            jndis.put(jndiName, jndiName);
        }
    }

    private boolean configNameExists(DataSourceBaseConfig[] configs, String name) {
        for (int i = 0; i < configs.length; ++i) {
            if (!configs[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean configJndiExists(String jndiName) {
        int i;
        for (i = 0; i < this.m_nativeDataSources.length; ++i) {
            if (!this.m_nativeDataSources[i].getJndiName().equals(jndiName)) continue;
            return true;
        }
        for (i = 0; i < this.m_managedDataSources.length; ++i) {
            if (!this.m_managedDataSources[i].getJndiName().equals(jndiName)) continue;
            return true;
        }
        return false;
    }

    private boolean connectionPoolExists(String name) {
        for (int i = 0; i < this.m_connectionPools.length; ++i) {
            if (!this.m_connectionPools[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addNativeDataSourceConfig(NativeDataSourceConfig newConfig) throws DataSourceConfigException {
        if (newConfig == null) {
            return;
        }
        int len = this.m_nativeDataSources.length;
        if (this.configNameExists(this.m_nativeDataSources, newConfig.getName())) {
            throw new DataSourceConfigException("The native data source name '" + newConfig.getName() + "' must be unique.");
        }
        if (this.configJndiExists(newConfig.getJndiName())) {
            throw new DataSourceConfigException("The JNDI name '" + newConfig.getJndiName() + "' for native data source '" + newConfig.getName() + "' must be unique across all data sources.");
        }
        NativeDataSourceConfig[] tempConfigs = new NativeDataSourceConfig[len + 1];
        for (int i = 0; i < len; ++i) {
            tempConfigs[i] = this.m_nativeDataSources[i];
        }
        tempConfigs[len] = newConfig;
        this.m_nativeDataSources = tempConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNativeDataSourceConfig(String dataSourceName) {
        NativeDataSourceConfig[] nativeDataSourceConfigArray = this.m_nativeDataSources;
        synchronized (this.m_nativeDataSources) {
            int len = this.m_nativeDataSources.length;
            if (dataSourceName == null || len == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Vector<NativeDataSourceConfig> configVector = new Vector<NativeDataSourceConfig>();
            for (int i = 0; i < len; ++i) {
                if (this.m_nativeDataSources[i].getName().equals(dataSourceName)) continue;
                configVector.add(this.m_nativeDataSources[i]);
            }
            int numConfigs = configVector.size();
            this.m_nativeDataSources = new NativeDataSourceConfig[numConfigs];
            for (int i = 0; i < numConfigs; ++i) {
                this.m_nativeDataSources[i] = (NativeDataSourceConfig)configVector.get(i);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized void addManagedDataSourceConfig(ManagedDataSourceConfig newConfig) throws DataSourceConfigException {
        if (newConfig == null) {
            return;
        }
        int len = this.m_managedDataSources.length;
        if (this.configNameExists(this.m_managedDataSources, newConfig.getName())) {
            throw new DataSourceConfigException("The managed data source name '" + newConfig.getName() + "' must be unique.");
        }
        if (this.configJndiExists(newConfig.getJndiName())) {
            throw new DataSourceConfigException("The JNDI name '" + newConfig.getJndiName() + "' for managed data source '" + newConfig.getName() + "' must be unique across all data sources.");
        }
        if (!this.connectionPoolExists(newConfig.getConnectionPoolName())) {
            throw new DataSourceConfigException("The connection pool '" + newConfig.getConnectionPoolName() + "' referred to by managed data source '" + newConfig.getName() + "' does not identify an existing connection pool.");
        }
        ManagedDataSourceConfig[] tempConfigs = new ManagedDataSourceConfig[len + 1];
        for (int i = 0; i < len; ++i) {
            tempConfigs[i] = this.m_managedDataSources[i];
        }
        tempConfigs[len] = newConfig;
        this.m_managedDataSources = tempConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedDataSourceConfig(String dataSourceName) {
        ManagedDataSourceConfig[] managedDataSourceConfigArray = this.m_managedDataSources;
        synchronized (this.m_managedDataSources) {
            int len = this.m_managedDataSources.length;
            if (dataSourceName == null || len == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Vector<ManagedDataSourceConfig> configVector = new Vector<ManagedDataSourceConfig>();
            for (int i = 0; i < len; ++i) {
                if (this.m_managedDataSources[i].getName().equals(dataSourceName)) continue;
                configVector.add(this.m_managedDataSources[i]);
            }
            int numConfigs = configVector.size();
            this.m_managedDataSources = new ManagedDataSourceConfig[numConfigs];
            for (int i = 0; i < numConfigs; ++i) {
                this.m_managedDataSources[i] = (ManagedDataSourceConfig)configVector.get(i);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public synchronized void addConnectionPoolConfig(ConnectionPoolConfig newConfig) throws DataSourceConfigException {
        if (newConfig == null) {
            return;
        }
        int len = this.m_connectionPools.length;
        if (this.connectionPoolExists(newConfig.getName())) {
            throw new DataSourceConfigException("The connection pool '" + newConfig.getName() + " already exists.  Connection pool names must be unique.");
        }
        ConnectionPoolConfig[] tempConfigs = new ConnectionPoolConfig[len + 1];
        for (int i = 0; i < len; ++i) {
            tempConfigs[i] = this.m_connectionPools[i];
        }
        tempConfigs[len] = newConfig;
        this.m_connectionPools = tempConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionPoolConfig(String name) {
        ConnectionPoolConfig[] connectionPoolConfigArray = this.m_connectionPools;
        synchronized (this.m_connectionPools) {
            int len = this.m_connectionPools.length;
            if (name == null || len == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Vector<ConnectionPoolConfig> configVector = new Vector<ConnectionPoolConfig>();
            for (int i = 0; i < len; ++i) {
                if (this.m_connectionPools[i].getName().equals(name)) continue;
                configVector.add(this.m_connectionPools[i]);
            }
            int numConfigs = configVector.size();
            this.m_connectionPools = new ConnectionPoolConfig[numConfigs];
            for (int i = 0; i < numConfigs; ++i) {
                this.m_connectionPools[i] = (ConnectionPoolConfig)configVector.get(i);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setNativeDataSources(NativeDataSourceConfig[] nativeDataSources) throws DataSourceConfigException {
        if (nativeDataSources == null) {
            nativeDataSources = new NativeDataSourceConfig[]{};
        }
        this.m_nativeDataSources = nativeDataSources;
        this.validateNativeDataSources();
    }

    private void setNativeDataSources() throws DataSourceConfigException {
        Vector children = this.getNamedChildren("native-data-source");
        int numChildren = children.size();
        NativeDataSourceConfig[] nativeDataSources = new NativeDataSourceConfig[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            nativeDataSources[i] = new NativeDataSourceConfig((Node)children.get(i));
        }
        this.setNativeDataSources(nativeDataSources);
    }

    public ConnectionPoolConfig[] getConnectionPools() {
        return this.m_connectionPools;
    }

    private void validateConnectionPools() throws DataSourceConfigException {
        HashMap<String, ConnectionPoolConfig> connectionPools = new HashMap<String, ConnectionPoolConfig>();
        for (int i = 0; i < this.m_connectionPools.length; ++i) {
            String name = this.m_connectionPools[i].getName();
            if (connectionPools.get(name) != null) {
                throw new DataSourceConfigException("The connection pool name '" + name + "' must be unique.");
            }
            connectionPools.put(name, this.m_connectionPools[i]);
        }
    }

    public void setConnectionPools(ConnectionPoolConfig[] connectionPools) throws DataSourceConfigException {
        if (connectionPools == null) {
            connectionPools = new ConnectionPoolConfig[]{};
        }
        this.m_connectionPools = connectionPools;
        this.validateConnectionPools();
    }

    private void setConnectionPools() throws DataSourceConfigException {
        Vector children = this.getNamedChildren("connection-pool");
        int numChildren = children.size();
        ConnectionPoolConfig[] connectionPools = new ConnectionPoolConfig[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            connectionPools[i] = new ConnectionPoolConfig((Node)children.get(i));
        }
        this.setConnectionPools(connectionPools);
    }

    private Vector getNamedChildren(String childNodeName) {
        Vector<Node> children = new Vector<Node>();
        NodeList nodes = this.getRootNode().getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals(childNodeName)) continue;
                children.add(node);
            }
        }
        return children;
    }

    protected Node createXML(Document document) throws Exception {
        int i;
        Element element = document.createElement(ROOT_NODE_NAME);
        Node rootNode = this.getRootNode();
        if (rootNode != null) {
            NamedNodeMap map = rootNode.getAttributes();
            int numAttributes = map.getLength();
            for (int i2 = 0; i2 < numAttributes; ++i2) {
                Node item = map.item(i2);
                String name = item.getNodeName();
                if (name.equals(DMS_UPDATE_INTERVAL_ATTRIBUTE)) continue;
                element.setAttribute(name, item.getNodeValue());
            }
        }
        if (this.m_dmsUpdateInterval != 60000) {
            element.setAttribute(DMS_UPDATE_INTERVAL_ATTRIBUTE, new Integer(this.m_dmsUpdateInterval).toString());
        }
        for (i = 0; i < this.m_managedDataSources.length; ++i) {
            element.appendChild(this.m_managedDataSources[i].createXML(document));
        }
        for (i = 0; i < this.m_nativeDataSources.length; ++i) {
            element.appendChild(this.m_nativeDataSources[i].createXML(document));
        }
        for (i = 0; i < this.m_connectionPools.length; ++i) {
            element.appendChild(this.m_connectionPools[i].createXML(document));
        }
        return element;
    }

    public String createXMLString() throws DataSourceConfigException {
        try {
            return DataSourceConfigUtils.createXMLString(this, false);
        }
        catch (Exception exception) {
            String msg = DataSourceMessages.severeConfigCreateXMLException(this.getRootNodeName(), exception);
            throw new DataSourceConfigException(msg, exception);
        }
    }
}

