/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import com.evermind.security.BasicUser;
import com.evermind.security.IndirectUserManager;
import com.evermind.security.SecuritySensitive;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.deployment.UserManagerConfig;
import com.evermind.util.SecurityProperties;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import oracle.oc4j.security.BasicUserProxy;
import oracle.oc4j.security.SecurityUtilWithReflection;
import oracle.oc4j.security.ShieldedUser;
import oracle.security.jazn.oc4j.JAZNUserManager;

public class SecurityUtil {
    static final int RADMON_ALPHA_NUM_PASSWORD_LEN = 16;
    private static final Map s_shieldedUserWeakCache = Collections.synchronizedMap(new WeakHashMap());

    public static Subject copyTo(Subject toSubject, Subject fromSubject) {
        if (null == fromSubject) {
            return toSubject;
        }
        if (null == toSubject) {
            toSubject = new Subject();
        }
        Iterator<Principal> iter = fromSubject.getPrincipals().iterator();
        while (iter.hasNext()) {
            toSubject.getPrincipals().add(iter.next());
        }
        return toSubject;
    }

    private static UserManager ultimate(UserManager userManager) {
        UserManager u = userManager;
        if (userManager instanceof UserManagerConfig) {
            try {
                u = ((UserManagerConfig)userManager).ultimate();
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return u;
    }

    public static boolean isJAZN(UserManager userManager) {
        return SecurityUtil.ultimate(userManager) instanceof JAZNUserManager;
    }

    public static JAZNUserManager toJAZN(UserManager userManager) {
        return (JAZNUserManager)SecurityUtil.ultimate(userManager);
    }

    public static boolean isNull(UserManager userManager) {
        while (userManager instanceof IndirectUserManager) {
            userManager = ((IndirectUserManager)userManager).getUnderlying();
        }
        return userManager == null;
    }

    public static boolean isUserAnonymous(User user) {
        User anonUser;
        if (null == user) {
            return true;
        }
        SecuritySensitive sec = SecuritySensitive.global();
        return null != sec && null != sec.getSystemUserManager() && null != (anonUser = sec.getSystemUserManager().getAnonymousUser()) && anonUser.equals(user);
    }

    public static char[] createRandomAlphaNumPassword() {
        int i = 16;
        char[] buff = new char[i];
        buff[--i] = '\u0000';
        while (i > 0) {
            int r = (int)(Math.random() * 36.0);
            if (r < 10) {
                buff[--i] = (char)(48 + r);
                continue;
            }
            buff[--i] = (char)(97 + (r -= 10));
        }
        return buff;
    }

    public static BasicUser shield(BasicUser inUser) {
        return SecurityUtil.shield(inUser, true);
    }

    public static BasicUser shield(BasicUser inUser, boolean useCache) {
        BasicUser outUser;
        BasicUser basicUser = outUser = useCache ? (BasicUser)s_shieldedUserWeakCache.get(inUser) : null;
        if (null == outUser) {
            outUser = (BasicUser)SecurityUtil.shield((Principal)inUser);
            if (null == outUser || outUser == inUser) {
                return outUser;
            }
            if (useCache) {
                s_shieldedUserWeakCache.put(inUser, outUser);
            }
        }
        return outUser;
    }

    public static Principal shield(Principal p) {
        if (SecurityProperties.getOracleOc4jSecurityShieldUsersEnabled()) {
            return SecurityUtil.isShieldedAlready(p) ? p : new BasicUserProxy((User)p);
        }
        return p;
    }

    private static boolean isShieldedAlready(Principal p) {
        if (SecurityProperties.getOracleOc4jSecurityShieldUsersEnabled()) {
            return !(p instanceof User) || p instanceof ShieldedUser;
        }
        return true;
    }

    static {
        SecurityUtilWithReflection.init(SecurityUtil.class.getClassLoader());
    }
}

