/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import com.evermind.security.User;
import com.evermind.security.UserManager;
import java.security.Principal;
import java.security.SignatureException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.Signing;
import oracle.oc4j.security.SigningAlias;
import oracle.oc4j.security.SigningContext;

public final class OC4JSigningHandler {
    private static final OC4JSigningHandler s_singleton = new OC4JSigningHandler();
    private final Signing s_signing = Signing.getInstance();
    static final Logger s_traceLogger = TraceLogger.getLogger(OC4JSigningHandler.class);

    public static OC4JSigningHandler getInstance() {
        OC4JSecurity.assertIsSafe();
        return s_singleton;
    }

    public Subject signSubject(Subject subject, Hashtable env) throws SignatureException {
        if (null == subject || null == env) {
            return null;
        }
        SigningContext context = SigningContext.create(null, this.getPrincipal(env), this.getCredentials(env));
        HashSet<Object> copyOfPublicCreds = new HashSet<Object>(subject.getPublicCredentials());
        copyOfPublicCreds.add(this.generateSignature(subject, context));
        return new Subject(subject.isReadOnly(), subject.getPrincipals(), copyOfPublicCreds, subject.getPrivateCredentials());
    }

    public boolean verifySubject(Subject subject, UserManager um) throws SignatureException {
        Signature cred = this.getProspectiveSigner(subject);
        User user = this.getVerifyUser(subject, cred, um);
        if (null == user) {
            return false;
        }
        long nonce = 0L;
        String password = user.getPassword();
        SigningContext context = SigningContext.create(cred.getContextId(), cred.getSigner(), password.getBytes());
        Signing.VerifyOperator vop = this.s_signing.getVerifyOperator(context, nonce);
        this.update(vop, subject);
        boolean success = vop.verify(cred.getSignature());
        if (success) {
            s_traceLogger.log(Level.FINE, "verified subject {0} was signed by {1}", new Object[]{subject, cred.getSigner()});
        } else {
            s_traceLogger.log(Level.SEVERE, "subject {0} was not signed by {1}", new Object[]{subject, cred.getSigner()});
        }
        return success;
    }

    public Signature generateSignature(Subject subject, SigningContext context) throws SignatureException {
        long nonce = 0L;
        Signing.SigningOperator sop = this.s_signing.getSigningOperator(context, nonce);
        this.update(sop, subject);
        return new Signature(context, sop.getSignature());
    }

    public Signature getProspectiveSigner(Subject subject) {
        Set contextSet = subject.getPublicCredentials(Signature.class);
        if (null == contextSet || contextSet.size() != 1) {
            return null;
        }
        return (Signature)contextSet.iterator().next();
    }

    private User getVerifyUser(Subject subject, Signature cred, UserManager um) {
        User user;
        if (null == cred) {
            s_traceLogger.log(Level.WARNING, "unable to verify subject {0} - not signed", subject);
            return null;
        }
        if (null == cred.getContextId() || cred.getContextId().length() > 0) {
            s_traceLogger.log(Level.WARNING, "unable to verify subject {0} - unknown context id", subject);
            return null;
        }
        User user2 = user = null == um ? null : um.getUser(cred.getSigner());
        if (null == um || null == user) {
            s_traceLogger.log(Level.WARNING, "unable to verify subject {0} - unable to find signer", subject);
        }
        return user;
    }

    private void update(Signing.Operator oper, Subject subject) throws SignatureException {
        Iterator<Principal> iter = subject.getPrincipals().iterator();
        while (iter.hasNext()) {
            Principal o = iter.next();
            oper.update(o);
        }
    }

    private String getPrincipal(Hashtable environment) {
        return null == environment ? null : environment.get("java.naming.security.principal");
    }

    private byte[] getCredentials(Hashtable environment) {
        String cred;
        String string = cred = null == environment ? null : (String)environment.get("java.naming.security.credentials");
        if (null == cred) {
            return null;
        }
        return cred.getBytes();
    }

    public static class Signature
    extends SigningAlias {
        private String m_signature;

        Signature(SigningContext context, String signature) {
            super(context.getAlias().getContextId(), context.getAlias().getSigner());
            this.m_signature = signature;
        }

        public String getSignature() {
            return this.m_signature;
        }
    }
}

