/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi.interceptors;

import com.evermind.server.IdentityPropagationConfiguration;
import com.evermind.server.rmi.RMIConnection;
import com.evermind.server.rmi.RMIInterceptorContext;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.rmi.interceptors.AbstractInterceptor;
import oracle.oc4j.rmi.interceptors.IdentityPropagationHandler;
import oracle.oc4j.rmi.interceptors.PropagatedIdentity;

public class IdentityPropagationInterceptor
extends AbstractInterceptor {
    private static int s_identifier = IdentityPropagationInterceptor.class.getName().hashCode();
    static Logger s_logger = TraceLogger.getLogger(IdentityPropagationInterceptor.class);

    protected IdentityPropagationHandler getHandler() {
        return IdentityPropagationHandler.getInstance();
    }

    boolean isIdentityPropagationEnabled() {
        return IdentityPropagationConfiguration.getConfiguration().isIdentityPropagationEnabled();
    }

    boolean isPropagatedIdentityValid(PropagatedIdentity iat) {
        return null != iat && null != iat.getUserName() && iat.getUserName().length() > 0;
    }

    boolean isTrustedSender(PropagatedIdentity iat, RMIInterceptorContext metaContext) {
        try {
            return null != metaContext && null != iat && metaContext.isTrustedSender("subject.propagation", iat.getUserName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean allowIdentityPropagation(PropagatedIdentity iat, RMIInterceptorContext metaContext) {
        return this.isIdentityPropagationEnabled() && this.isPropagatedIdentityValid(iat) && this.isTrustedSender(iat, metaContext);
    }

    public boolean isInterested(int command) {
        return RMIConnection.isMethodLookupBindOrInvocationCommand(command);
    }

    public Object processSendRequest() throws IOException {
        return this.getHandler().getCurrentIdentity();
    }

    public void processReceiveRequest(Object requestContext, RMIInterceptorContext metaContext) throws IOException {
        PropagatedIdentity iat = (PropagatedIdentity)requestContext;
        CommonThreadState cts = CommonThreadState.getCurrent();
        Object[] context = new Object[]{iat, cts.getActiveUser()};
        if (this.allowIdentityPropagation(iat, metaContext)) {
            s_logger.log(Level.FINE, "accepting propagated identity: {0}; cuser: {1}", context);
            this.getHandler().handleIdentityAssertion(iat);
        } else {
            s_logger.log(Level.FINE, "rejecting propagated identity: {0}; cuser: {1}", context);
        }
    }

    public int getIdentifier() {
        return s_identifier;
    }
}

