/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi;

import com.evermind.io.IOUtils;
import com.evermind.net.NetworkConnection;
import com.evermind.net.SocketNetworkConnection;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIConnectionException;
import com.evermind.server.rmi.RMILoginFailedException;
import com.evermind.server.rmi.RMIProtocol;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.rmi.ClientRmiTransport;
import oracle.oc4j.rmi.RmiTransport;
import oracle.oc4j.util.HexDisplay;

public class ClientSocketRmiTransport
extends ClientRmiTransport {
    private static Logger m_logger = TraceLogger.getLogger(ClientSocketRmiTransport.class);
    private InetAddress m_address;
    private int m_port;
    private boolean m_secure;
    private final Object m_sendLock = new Object();

    protected ClientSocketRmiTransport(InetAddress address, int port, boolean secure) {
        this.m_address = address;
        this.m_port = port;
        this.m_secure = secure;
    }

    public ClientRmiTransport cloneTransport() {
        return new ClientSocketRmiTransport(this);
    }

    private ClientSocketRmiTransport(ClientSocketRmiTransport other) {
        super(other);
        this.m_address = other.m_address;
        this.m_port = other.m_port;
        this.m_secure = other.m_secure;
    }

    public NetworkConnection createNetworkConnection() throws IOException {
        return new SocketNetworkConnection(RMIClientConnection.createSocket(this.m_address, this.m_port, this.m_secure));
    }

    public String getLocation() {
        return "" + this.m_address + ':' + this.m_secure;
    }

    public void connectToServer(RMIClientConnection connection, RMIProtocol protocol, String username, String password, String initialDomain) throws IOException, RMILoginFailedException, AuthenticationException {
        super.connectToServer(connection, protocol, username, password, initialDomain);
        RmiTransport.MessageOut request = protocol.createRequest(this, connection);
        request.getOutputStream().write(25);
        request.getOutputStream().writeUTF(initialDomain);
        request.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRequest(byte[] requestContents) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            throw new RMIConnectionException("Disconnected from server", 1);
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "Transmitting " + requestContents.length + " bytes" + " to: " + this.getLocation() + " port: " + this.m_port);
            m_logger.log(Level.FINER, HexDisplay.format(requestContents));
        }
        Object object = this.m_sendLock;
        synchronized (object) {
            IOUtils.writeCompressedInt(outputStream, requestContents.length);
            outputStream.write(requestContents);
            outputStream.flush();
        }
    }

    public String toString() {
        return "ClientSocketRmiTransport[ address = " + this.m_address + ", port = " + this.m_port + (this.m_secure ? ", secure" : "") + " ]";
    }

    public boolean equals(Object obj) {
        return this.equalsClass(obj) && this.equals((ClientSocketRmiTransport)obj);
    }

    private boolean equals(ClientSocketRmiTransport other) {
        return this.m_secure == other.m_secure && this.m_address.equals(other.m_address) && this.m_port == other.m_port;
    }

    public int hashCode() {
        return (this.m_address.hashCode() + this.m_port) * (this.m_secure ? -1 : 1);
    }
}

