/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.loader.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ClassLoaderScope;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.ProtectionPolicy;
import oracle.classloader.SearchPolicy;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.VersionNumber;
import oracle.oc4j.loader.config.CodeSourceType;
import oracle.oc4j.loader.config.ConfigurationException;
import oracle.oc4j.loader.config.ImportSharedLibraryType;
import oracle.oc4j.loader.config.ImportedSharedLibrariesType;
import oracle.oc4j.loader.config.OC4JConfigurationPolicy;
import oracle.oc4j.loader.config.OC4JConfigurationType;
import oracle.oc4j.loader.config.SharedLibraryType;

public class ConfigurationConsumer {
    private static final String STAR = "*";

    public static PolicyClassLoader createSharedLibrary(SharedLibraryType config, File sharedLibrariesDirectory, File serverConfigDirectory, boolean fileMustExist, String originDescription) throws ConfigurationException {
        PolicyClassLoader result = null;
        String name = config.getName();
        VersionNumber version = ConfigurationConsumer.getVersion(config.getVersion());
        String parentName = config.getParentName();
        VersionNumber parentVersion = ConfigurationConsumer.getVersion(config.getParentVersion());
        List codeSources = config.getCodeSources();
        List imports = config.getImports();
        boolean libraryCompatible = config.isLibraryCompatible();
        if (name == null || name.length() == 0) {
            throw ConfigurationException.create("library.name.required");
        }
        if (version == null) {
            throw ConfigurationException.create("version.number.required", name);
        }
        File rootDir = null;
        rootDir = libraryCompatible ? serverConfigDirectory : new File(sharedLibrariesDirectory, name + File.separatorChar + version);
        ConfigurationOrigin loaderOrigin = new ConfigurationOrigin(OC4JConfigurationType.SERVER_SHARED_LIBRARY_ELEMENT, originDescription);
        PolicyClassLoader parent = null;
        if (parentName == null) {
            parent = ClassLoaderQuery.findLatestLoader((String)ClassLoaderQuery.getAPILoader().getName());
        } else {
            parent = ClassLoaderQuery.findLoader((String)parentName, (VersionNumber)parentVersion, (VersionNumber)parentVersion);
            if (parent == null) {
                VersionNumber ver = parentVersion != null ? parentVersion : VersionNumber.ZERO;
                throw ConfigurationException.create("parent.not.found", parentName, ver);
            }
        }
        ProtectionPolicy protectionPolicy = ProtectionPolicy.sharedLibraryPolicy((String)name);
        try {
            result = new PolicyClassLoader(name, version, (ClassLoader)parent, loaderOrigin, ConfigurationPolicy.SHARED, SearchPolicy.STANDARD, protectionPolicy);
            ConfigurationOrigin codeSourceOrigin = new ConfigurationOrigin(ConfigurationType.SHARED_CODE_SOURCE_ELEMENT, loaderOrigin.getOrigin());
            Iterator iterator = codeSources.iterator();
            while (iterator.hasNext()) {
                CodeSourceType cs = (CodeSourceType)iterator.next();
                String path = cs.getPath();
                if (path.equals(STAR)) {
                    if (libraryCompatible) {
                        throw ConfigurationException.create("code.source.star.not.allowed");
                    }
                    if (!rootDir.exists()) {
                        throw ConfigurationException.create("code.source.root.not.found", rootDir);
                    }
                    ConfigurationConsumer.addArchiveCodeSourcesFrom(rootDir, result, codeSourceOrigin);
                    continue;
                }
                File csFile = ConfigurationConsumer.getCodeSourceFile(cs, rootDir, fileMustExist, name, originDescription);
                result.addCodeSource(csFile, codeSourceOrigin);
                if (!libraryCompatible || !csFile.isDirectory()) continue;
                ConfigurationConsumer.addArchiveCodeSourcesFrom(csFile, result, codeSourceOrigin);
            }
            if (imports != null) {
                ConfigurationOrigin importOrigin = null;
                Iterator iterator2 = imports.iterator();
                while (iterator2.hasNext()) {
                    ImportSharedLibraryType anImport = (ImportSharedLibraryType)iterator2.next();
                    if (importOrigin == null) {
                        importOrigin = new ConfigurationOrigin(ConfigurationType.SHARED_IMPORT_SHARED_LIBRARY_ELEMENT, loaderOrigin.getOrigin());
                    }
                    result.importLoader(ConfigurationConsumer.getSharedLibraryToImport(anImport), importOrigin);
                }
            }
            if (!result.isConfigured()) {
                result.close();
                throw ConfigurationException.create("shared.library.sub.element.required", name, originDescription);
            }
            result.commit();
        }
        catch (ConfigurationException e) {
            if (result != null) {
                result.close();
            }
            throw e;
        }
        catch (Exception e) {
            if (result != null) {
                result.close();
            }
            throw new ConfigurationException(e);
        }
        config.setInstantiated(true);
        return result;
    }

    private static int addArchiveCodeSourcesFrom(File directory, PolicyClassLoader loader, ConfigurationOrigin origin) throws IOException {
        int resultCount = 0;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String fileName = file.getName();
            if (!fileName.endsWith(".zip") && !fileName.endsWith(".jar")) continue;
            loader.addCodeSource(file, origin);
            ++resultCount;
        }
        return resultCount;
    }

    public static PolicyClassLoader createApplicationLoader(String name, String version, ClassLoader parent, String originDescription, ImportedSharedLibrariesType config, ProtectionPolicy protectionPolicy) throws ConfigurationException {
        VersionNumber vn = version == null ? VersionNumber.ZERO : new VersionNumber(version);
        return ConfigurationConsumer.createApplicationLoader(name, vn, parent, null, originDescription, config, protectionPolicy);
    }

    public static PolicyClassLoader createApplicationLoader(String name, ClassLoader parent, String originDescription, ImportedSharedLibrariesType config, ProtectionPolicy protectionPolicy) throws ConfigurationException {
        VersionNumber version = ClassLoaderQuery.getNextUnusedVersionFor((String)name);
        return ConfigurationConsumer.createApplicationLoader(name, version, parent, null, originDescription, config, protectionPolicy);
    }

    public static PolicyClassLoader createApplicationLoader(String name, VersionNumber version, ClassLoader parent, PolicyClassLoader[] additionalLibs, String originDescription, ImportedSharedLibrariesType config, ProtectionPolicy protectionPolicy) throws ConfigurationException {
        PolicyClassLoader result = null;
        ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.APPLICATION_ELEMENT, originDescription);
        if (config != null || additionalLibs != null) {
            result = new PolicyClassLoader(name, version, parent, origin, OC4JConfigurationPolicy.APPLICATION_DO_NOT_INHERIT_IMPORTS, SearchPolicy.STANDARD, protectionPolicy);
            ConfigurationConsumer.addImportedSharedLibraries(result, originDescription, config, additionalLibs);
        } else {
            result = new PolicyClassLoader(name, version, parent, origin, OC4JConfigurationPolicy.APPLICATION_INHERIT_IMPORTS, SearchPolicy.STANDARD, protectionPolicy);
        }
        return result;
    }

    public static void addImportedSharedLibraries(PolicyClassLoader loader, String originDescription, ImportedSharedLibrariesType config, PolicyClassLoader[] additionalLibs) throws ConfigurationException {
        PolicyClassLoader[] imports = ConfigurationConsumer.getImportedSharedLibraries(config, loader.parent(), additionalLibs);
        if (imports == null) {
            return;
        }
        ConfigurationOrigin origin = new ConfigurationOrigin(OC4JConfigurationType.APPLICATION_IMPORT_SHARED_LIBRARY_ELEMENT, originDescription);
        for (int i = 0; i < imports.length; ++i) {
            PolicyClassLoader anImport = imports[i];
            loader.importLoader(anImport, origin);
        }
    }

    static PolicyClassLoader[] getImportedSharedLibraries(ImportedSharedLibrariesType config, PolicyClassLoader parent, PolicyClassLoader[] additionalImports) throws ConfigurationException {
        ArrayList<PolicyClassLoader> result = new ArrayList<PolicyClassLoader>();
        PolicyClassLoader[] imports = null;
        if (parent != null && parent.getScope() == ClassLoaderScope.APPLICATION) {
            imports = parent.getImports();
        }
        if (config != null) {
            String[] removals = config.getRemovals();
            for (int i = 0; i < removals.length; ++i) {
                String removeInherited = removals[i];
                if (removeInherited.equals(STAR)) {
                    imports = null;
                    break;
                }
                ConfigurationConsumer.remove(removeInherited, imports);
                ConfigurationConsumer.remove(removeInherited, additionalImports);
            }
            ImportSharedLibraryType[] importtypes = config.getImports();
            for (int j = 0; j < importtypes.length; ++j) {
                ImportSharedLibraryType anImport = importtypes[j];
                PolicyClassLoader loader = ConfigurationConsumer.getSharedLibraryToImport(anImport);
                result.add(loader);
                ConfigurationConsumer.remove(loader.getName(), imports);
                ConfigurationConsumer.remove(loader.getName(), additionalImports);
            }
        }
        if (imports != null) {
            for (int i = 0; i < imports.length; ++i) {
                PolicyClassLoader parentImport = imports[i];
                if (parentImport == null) continue;
                result.add(parentImport);
            }
        }
        if (additionalImports != null) {
            for (int i = 0; i < additionalImports.length; ++i) {
                PolicyClassLoader loaderToImport = additionalImports[i];
                if (loaderToImport == null) continue;
                result.add(loaderToImport);
            }
        }
        HashSet<String> names = new HashSet<String>();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            PolicyClassLoader loader = (PolicyClassLoader)iterator.next();
            String name = loader.getName();
            if (names.add(name)) continue;
            iterator.remove();
        }
        return (PolicyClassLoader[])ArrayUtils.toArray((Class)PolicyClassLoader.class, result, (boolean)false);
    }

    static PolicyClassLoader[] getImportedSharedLibraries(ImportedSharedLibrariesType config, PolicyClassLoader parent) throws ConfigurationException {
        return ConfigurationConsumer.getImportedSharedLibraries(config, parent, null);
    }

    private static void remove(String name, PolicyClassLoader[] loaders) {
        if (loaders != null) {
            for (int i = 0; i < loaders.length; ++i) {
                if (loaders[i] == null || !loaders[i].getName().equals(name)) continue;
                loaders[i] = null;
                break;
            }
        }
    }

    static File getCodeSourceFile(CodeSourceType config, File relativeRoot, boolean fileMustExist, String configName, String configOrigin) throws ConfigurationException {
        String path = config.getPath();
        File file = new File(path);
        if (!file.isAbsolute()) {
            if (!relativeRoot.exists()) {
                throw ConfigurationException.create("code.source.root.not.found", relativeRoot);
            }
            file = new File(relativeRoot, path);
        }
        if (fileMustExist && !file.exists()) {
            throw ConfigurationException.create("code.source.not.found", file, configName, configOrigin);
        }
        return file;
    }

    static PolicyClassLoader getSharedLibraryToImport(ImportSharedLibraryType config) throws ConfigurationException {
        String max;
        VersionNumber maxVersion;
        String min;
        VersionNumber minVersion;
        String name = config.getName();
        PolicyClassLoader result = ClassLoaderQuery.findSharedLoader((String)name, (VersionNumber)(minVersion = (min = config.getMinVersion()) == null ? null : new VersionNumber(min)), (VersionNumber)(maxVersion = (max = config.getMaxVersion()) == null ? null : new VersionNumber(max)));
        if (result == null) {
            throw ConfigurationConsumer.createNotFoundException(name, minVersion, maxVersion);
        }
        return result;
    }

    private static ConfigurationException createNotFoundException(String name, VersionNumber minVersion, VersionNumber maxVersion) {
        if (minVersion == null && maxVersion == null) {
            return ConfigurationException.create("shared.library.not.found", name);
        }
        PolicyClassLoader[] loaders = ClassLoaderQuery.findLoaders((String)name);
        if (loaders == null || !loaders[0].isSharedLoader()) {
            return ConfigurationException.create("shared.library.not.found", name);
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < loaders.length; ++i) {
            PolicyClassLoader loader = loaders[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(loader.getVersionNumber());
        }
        String found = buffer.toString();
        if (minVersion == null) {
            return ConfigurationException.create("shared.library.version.max.not.found", name, maxVersion, found);
        }
        if (maxVersion == null) {
            return ConfigurationException.create("shared.library.version.min.not.found", name, minVersion, found);
        }
        return ConfigurationException.create("shared.library.version.not.found", name, minVersion, maxVersion, found);
    }

    private static VersionNumber getVersion(String version) {
        if (version != null) {
            return new VersionNumber(version);
        }
        return null;
    }
}

