/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.security;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.ior.IOR;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import oracle.j2ee.corba.security.CSIV2Messages;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.corba.iiop.security.ClientSecurityMechanismSelector;
import oracle.oc4j.corba.iiop.security.InvalidIdentityTokenException;
import oracle.oc4j.corba.iiop.security.InvalidMechanismException;
import oracle.oc4j.corba.iiop.security.LoginContext;
import oracle.oc4j.corba.iiop.security.LoginException;
import oracle.oc4j.corba.iiop.security.SecurityContext;
import oracle.oc4j.corba.iiop.security.SecurityMechanismException;
import oracle.oc4j.corba.iiop.security.SecurityMechanismSelector;
import oracle.oc4j.corba.iiop.security.ServerConnectionContext;
import oracle.oc4j.corba.iiop.security.ServerSecurityService;
import oracle.oc4j.corba.orb.OrbManager;
import oracle.oc4j.security.iiop.CSIv2Security;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

public class SecurityServiceImpl
implements ServerSecurityService {
    private String IS_A = "_is_a";

    public SecurityContext getSecurityContext(Object effective_target) throws InvalidMechanismException, InvalidIdentityTokenException {
        SecurityContext context = null;
        IOR ior = ORBUtility.getIOR((Object)effective_target);
        if (effective_target instanceof ObjectImpl && ((ObjectImpl)effective_target)._is_local()) {
            return null;
        }
        try {
            ClientSecurityMechanismSelector sms = OrbManager.getSecurityMechanismSelector();
            context = sms.selectSecurityContext();
        }
        catch (InvalidMechanismException ime) {
            CSIV2Messages.finerThrowableNoMsg(ime);
            throw new InvalidMechanismException(ime.getMessage());
        }
        catch (InvalidIdentityTokenException iite) {
            CSIV2Messages.finerThrowableNoMsg(iite);
            throw new InvalidIdentityTokenException(iite.getMessage());
        }
        catch (SecurityMechanismException sme) {
            CSIV2Messages.finerThrowableNoMsg(sme);
            throw new RuntimeException(sme.getMessage());
        }
        return context;
    }

    public void receivedReply(int reply_status, Object effective_target) {
        if (reply_status == 1) {
            System.out.println("Failed status");
            throw new RuntimeException("Target did not accept security context");
        }
        if (reply_status == 2) {
            CSIV2Messages.finestMsg("Retry status");
        } else {
            CSIV2Messages.finestMsg("Passed status");
        }
    }

    public int setSecurityContext(SecurityContext context, byte[] object_id, String method) {
        CSIV2Messages.finestMsg("ABOUT TO EVALUATE TRUST");
        SecurityContext ssc = null;
        Class cls = null;
        try {
            Subject s = null;
            SecurityMechanismSelector sms = (SecurityMechanismSelector)OrbManager.getSecurityMechanismSelector();
            ssc = sms.evaluateTrust(context, object_id);
            if (ssc == null) {
                return 0;
            }
            cls = ssc.authcls != null ? ssc.authcls : ssc.identcls;
            s = ssc.subject;
            this.authenticate(s, cls, object_id);
        }
        catch (Exception e) {
            if (!method.equals(this.IS_A)) {
                CSIV2Messages.finerThrowableNoMsg(e);
            }
            return 1;
        }
        return 0;
    }

    public void sendingReply(SecurityContext context) {
    }

    public void unsetSecurityContext() {
        boolean isLocal = true;
        ServerConnectionContext scc = SecurityMechanismSelector.getServerConnectionContext();
        if (scc != null && scc.getSocket() != null) {
            isLocal = false;
        }
        if (!isLocal) {
            CommonThreadState.getCurrent().user = null;
        }
        CSIv2Security.setPublicCredentials(null);
    }

    private void authenticate(Subject s, Class cls, byte[] object_id) throws SecurityMechanismException {
        try {
            final LoginContext lc = new LoginContext();
            final Subject fs = s;
            final Class cl = cls;
            final byte[] oid = object_id;
            AccessController.doPrivileged(new PrivilegedAction(){

                public java.lang.Object run() {
                    try {
                        lc.login(fs, cl, oid);
                    }
                    catch (LoginException e) {
                        CSIV2Messages.finerThrowableNoMsg(e);
                        throw new RuntimeException("Cannot login user:" + e.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            CSIV2Messages.finerThrowableNoMsg(t);
            throw new SecurityMechanismException("Cannot login user: unexpected exception: " + t.getMessage());
        }
    }
}

