/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.security;

import com.evermind.security.User;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import oracle.oc4j.common.CommonThreadState;
import oracle.oc4j.corba.iiop.security.AnonCredential;
import oracle.oc4j.corba.iiop.security.GSSUPName;
import oracle.oc4j.corba.iiop.security.LoginException;
import oracle.oc4j.corba.security.auth.login.PasswordCredential;
import oracle.oc4j.corba.security.auth.login.X509CertificateCredential;
import oracle.oc4j.corba.transport.EJBObjectID;
import oracle.oc4j.security.iiop.CSIv2Security;
import sun.security.x509.X500Name;

public class LoginContext {
    boolean debug = false;

    public void login(Subject subject, Class cls, byte[] oid) throws LoginException {
        Set credset = null;
        final Subject fs = subject;
        credset = cls.equals(PasswordCredential.class) ? (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (LoginContext.this.debug) {
                    System.out.println("Logging in :" + fs);
                }
                return fs.getPrivateCredentials(class$oracle$oc4j$corba$security$auth$login$PasswordCredential == null ? (class$oracle$oc4j$corba$security$auth$login$PasswordCredential = LoginContext.class$("oracle.oc4j.corba.security.auth.login.PasswordCredential")) : class$oracle$oc4j$corba$security$auth$login$PasswordCredential);
            }
        }) : subject.getPublicCredentials(cls);
        final Iterator iter = credset.iterator();
        while (iter.hasNext()) {
            String user;
            Object obj = null;
            try {
                obj = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return iter.next();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (obj instanceof PasswordCredential) {
                PasswordCredential p = obj;
                user = p.getUser();
                String pwd = p.getPassword();
                if (this.debug) {
                    System.out.println("Logging in:" + user + " password:" + pwd);
                }
                this.loginUser(user, pwd, oid);
                continue;
            }
            if (obj instanceof X509CertificateCredential) {
                X509CertificateCredential xp = obj;
                CSIv2Security.setPublicCredentials(obj);
                user = xp.getAlias();
                this.loginUsingAlias(user, oid);
                continue;
            }
            if (obj instanceof AnonCredential) continue;
            String user2 = "";
            if (obj instanceof GSSUPName) {
                user2 = ((GSSUPName)obj).getUser();
                CSIv2Security.setPublicCredentials(obj);
            } else if (obj instanceof X500Name) {
                user2 = ((X500Name)obj).getName();
                CSIv2Security.setPublicCredentials(obj);
            }
            this.loginWithNoPassword(user2, oid);
        }
    }

    private void loginWithNoPassword(String user, byte[] oid) throws LoginException {
        this.getAndSetUser(user, oid);
    }

    private void loginUser(String user, String passwd, byte[] oid) throws LoginException {
        User _user = this.getAndSetUser(user, oid);
        if (!_user.authenticate(passwd)) {
            throw new LoginException("Authentication failed:");
        }
    }

    private void loginUsingAlias(String user, byte[] oid) throws LoginException {
        this.loginWithNoPassword(user, oid);
    }

    private User getAndSetUser(String userName, byte[] oid) throws LoginException {
        CommonThreadState state = CommonThreadState.getCurrent();
        User _user = null;
        EJBObjectID objectId = null;
        try {
            if (EJBObjectID.hasEJBObjectID(oid)) {
                objectId = (EJBObjectID)EJBObjectID.extract(oid, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new LoginException(e.toString());
        }
        if (objectId == null) {
            throw new LoginException("Authentication failed: Couldn't find the application being accessed");
        }
        state.user = _user = this.getUser(objectId, userName, _user);
        return _user;
    }

    private User getUser(EJBObjectID objectId, String userName, User _user) throws LoginException {
        Application app = null;
        try {
            app = ApplicationServer.getInstance().getApplication(objectId.getApplicationName());
        }
        catch (InstantiationException e) {
            throw new LoginException(e.toString());
        }
        if (app != null) {
            _user = app.getUserManager().getUser(userName);
        }
        if (_user == null) {
            throw new LoginException("Authentication failed: user " + userName + "doesn't exist");
        }
        return _user;
    }
}

