/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.jts.pi;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.EJBObjectKey;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerTransaction;
import com.evermind.util.DBProperties;
import java.io.IOException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.transaction.NotSupportedException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import oracle.oc4j.corba.iiop.jts.pi.OTSPolicyImpl;
import oracle.oc4j.corba.transport.CorbaEJBHome;
import oracle.oc4j.corba.transport.EJBObjectID;
import oracle.oc4j.corba.transport.HomeLocator;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_UNAVAILABLE;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTransactions.OTSPolicy;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.PropagationContextHolder;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorImpl
extends LocalObject
implements ClientRequestInterceptor,
ServerRequestInterceptor {
    private static final String name = "com.sun.jts.pi";
    private static final int TransactionServiceId = 0;
    private static final SystemException SYS_EXC = new SystemException("", 0, CompletionStatus.COMPLETED_MAYBE){};
    public static final int NO_REPLY_SLOT = 0;
    public static final int NULL_CTX_SLOT = 1;
    public static final Integer PROPER_CTX = new Integer(0);
    public static final Integer NULL_CTX = new Integer(1);
    public static final Integer REPLY = new Integer(0);
    public static final Integer NO_REPLY = new Integer(1);
    public static final String CLIENT_POLICY_CHECKING = "com.sun.jts.pi.CLIENT_POLICY_CHECKING";
    public static final String INTEROP_MODE = "com.sun.jts.pi.INTEROP_MODE";
    public static ThreadLocal otsThreadLocal = new ThreadLocal(){

        protected Object initialValue() {
            Object[] threadLocalState = new Object[]{new Stack(), new Stack()};
            return threadLocalState;
        }
    };
    private static PropagationContext nullContext = null;
    private static PropagationContext dummyContext = null;
    public static ORB txOrb;
    Current pic = null;
    Codec codec = null;
    int[] slotIds = null;
    private boolean created = false;
    private boolean checkPolicy = true;
    private boolean interopMode = true;

    public InterceptorImpl(Current pic, Codec codec, int[] slotIds) {
        this.pic = pic;
        this.codec = codec;
        this.slotIds = slotIds;
        String prop = System.getProperty(CLIENT_POLICY_CHECKING, "true");
        this.checkPolicy = prop.equals("true");
        prop = System.getProperty(INTEROP_MODE, "true");
        this.interopMode = prop.equals("true");
    }

    public String name() {
        return name;
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_request(ri): begin");
        }
        short otsPolicyValue = OTSPolicyImpl._ADAPTS.value();
        if (this.getTransaction() == null) {
            if (DBProperties.getTransactionDebug()) {
                this.debug("send_request(ri): end--No Txn associated with the thread");
            }
            return;
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_request(ri)---sending_request[" + ri.request_id() + "] : " + ri.operation());
        }
        PropagationContextHolder hctx = new PropagationContextHolder();
        ObjectImpl target = (ObjectImpl)ri.effective_target();
        if (target._is_local()) {
            hctx.value = dummyContext;
        } else if (!this.interopMode) {
            hctx.value = nullContext;
        }
        Any any = txOrb.create_any();
        PropagationContextHelper.insert((Any)any, (PropagationContext)hctx.value);
        byte[] ctxData = null;
        try {
            ctxData = this.codec.encode_value(any);
        }
        catch (InvalidTypeForEncoding e) {
            throw new INTERNAL();
        }
        ServiceContext svc = new ServiceContext(0, ctxData);
        ri.add_request_service_context(svc, false);
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_request(ri): end");
        }
    }

    public void send_poll(ClientRequestInfo ri) {
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_poll(ri): begin");
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_poll(ri): end");
        }
    }

    public void receive_reply(ClientRequestInfo ri) {
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_reply(ri): begin");
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_reply(ri): end");
        }
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_exception(ri): begin");
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_exception(ri): end");
        }
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_other(ri): begin");
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_other(ri): end");
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_request_service_contexts(ri): begin");
        }
        OTSPolicy otsPolicy = null;
        try {
            otsPolicy = (OTSPolicy)ri.get_server_policy(56);
        }
        catch (INV_POLICY e) {
            // empty catch block
        }
        int otsPolicyValue = -1;
        otsPolicyValue = otsPolicy == null ? (int)OTSPolicyImpl._ADAPTS.value() : (int)otsPolicy.value();
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_request_service_contexts(ri)---recd-otsPolicyValue=" + otsPolicyValue);
        }
        ServiceContext svc = null;
        try {
            svc = ri.get_request_service_context(0);
        }
        catch (BAD_PARAM e) {
            // empty catch block
        }
        if (svc == null) {
            if (DBProperties.getTransactionDebug()) {
                this.debug("receive_request_service_contexts(ri)---recd-Txnal_ServiceContext is NULL");
            }
            InterceptorImpl.setThreadLocalData(0, NO_REPLY);
        } else {
            if (DBProperties.getTransactionDebug()) {
                this.debug("receive_request_service_contexts(ri)---recd-Txnal_ServiceContext is NOT_NULL--need to send-reply");
            }
            InterceptorImpl.setThreadLocalData(0, REPLY);
        }
        InterceptorImpl.setThreadLocalData(1, PROPER_CTX);
        try {
            if (svc != null && otsPolicyValue == 1) {
                throw new TRANSACTION_UNAVAILABLE();
            }
            if (svc == null) {
                if (otsPolicyValue == 1) {
                    if (DBProperties.getTransactionDebug()) {
                        this.debug("receive_request_service_contexts(ri)---otsPolicyValue == REQUIRES.value");
                    }
                    throw new TRANSACTION_REQUIRED();
                }
                if (DBProperties.getTransactionDebug()) {
                    this.debug("receive_request_service_contexts(ri): end---recd-Txnal ServiceContext is NULL");
                }
                return;
            }
            if (otsPolicyValue == 2) {
                if (DBProperties.getTransactionDebug()) {
                    this.debug("receive_request_service_contexts(ri)---recd_otsPolicyValue == FORBIDS.value");
                }
                throw new INVALID_TRANSACTION();
            }
            if (svc.context_id != 0) {
                if (DBProperties.getTransactionDebug()) {
                    this.debug("receive_request_service_contexts(ri)---svc.context_id != TransactionServiceId---Something is WRONG");
                }
                throw new INVALID_TRANSACTION();
            }
            if (this.isDummyContext(svc)) {
                InterceptorImpl.getThreadLocalData(0);
                InterceptorImpl.setThreadLocalData(0, NO_REPLY);
                if (DBProperties.getTransactionDebug()) {
                    this.debug("receive_request_service_contexts(ri): end---received dummyContext");
                }
                return;
            }
            if (this.isNullContext(svc)) {
                InterceptorImpl.getThreadLocalData(1);
                InterceptorImpl.setThreadLocalData(1, NULL_CTX);
                InterceptorImpl.getThreadLocalData(0);
                InterceptorImpl.setThreadLocalData(0, NO_REPLY);
            }
        }
        catch (RuntimeException r) {
            InterceptorImpl.getThreadLocalData(0);
            InterceptorImpl.getThreadLocalData(1);
            throw r;
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_request_service_contexts(ri): end");
        }
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        block34: {
            if (DBProperties.getTransactionDebug()) {
                this.debug("receive_request(ri): begin");
                this.debug("receive_request(ri)---received_request[" + ri.request_id() + "] : " + ri.operation());
            }
            ServiceContext svc = null;
            try {
                svc = ri.get_request_service_context(0);
            }
            catch (BAD_PARAM e) {
                // empty catch block
            }
            if (svc == null) {
                if (DBProperties.getTransactionDebug()) {
                    this.debug("receive_request(ri): end--No txnal Context recd");
                }
                return;
            }
            if (this.isDummyContext(svc)) {
                if (DBProperties.getTransactionDebug()) {
                    this.debug("receive_request(ri): end---received a dummyContext");
                }
                return;
            }
            BeanDescriptor descriptor = this.getBeanDescriptor(ri);
            String methodName = ri.operation();
            String[] parameters = null;
            if (methodName.indexOf("__CORBA_") > 0) {
                Vector<String> v = null;
                StringTokenizer st = new StringTokenizer(methodName, "_");
                if (DBProperties.getTransactionDebug()) {
                    this.debug("receive_request(ri)---stringTokenizer.countTokens()=" + st.countTokens());
                }
                if (st.countTokens() > 2) {
                    v = new Vector<String>();
                }
                int i = 0;
                while (st.hasMoreTokens()) {
                    String ss = st.nextToken();
                    if (i == 0) {
                        methodName = ss;
                    }
                    if (i > 1) {
                        v.add(ss);
                    }
                    ++i;
                }
                if (v != null) {
                    parameters = new String[v.size()];
                }
                for (i = 0; v != null && i < v.size(); ++i) {
                    String param = (String)v.elementAt(i);
                    parameters[i] = this.getJavaMapping(param);
                }
            }
            if (DBProperties.getTransactionDebug()) {
                this.debug("receive_request(ri)---BeanDescriptor=" + descriptor);
                this.debug("receive_request(ri)---methodName=" + methodName);
                for (int i = 0; parameters != null && i < parameters.length; ++i) {
                    this.debug("receive_request(ri)---parameters[" + i + "]=" + parameters[i]);
                }
                if (descriptor != null) {
                    this.debug("receive_request(ri)---ejb-name=" + descriptor.getName());
                    this.debug("receive_request(ri)---txn-Type(Container-Managed=0, Bean-Managed=1)=" + descriptor.getTransactionType());
                }
            }
            if (descriptor != null) {
                if (descriptor.getTransactionType() == 1) {
                    if (DBProperties.getTransactionDebug()) {
                        this.debug("receive_request(ri): end--Bean Managed Txn");
                    }
                    return;
                }
                int txnAttr = descriptor.getTransactionType(methodName, parameters, false, false);
                if (DBProperties.getTransactionDebug()) {
                    this.debug("receive_request(ri)---txnAttr = " + ContainerTransaction.getTransactionName(txnAttr));
                }
                if (txnAttr == 3 || txnAttr == 1 || txnAttr == 4) {
                    throw new UNKNOWN();
                }
                Transaction tx = this.getTransaction();
                if (tx == null && (txnAttr == 6 || txnAttr == 2 || txnAttr == 5)) {
                    if (DBProperties.getTransactionDebug()) {
                        this.debug("receive_request(ri)---Creating a new Transaction...");
                    }
                    try {
                        descriptor.getPackage().getContainer().getApplication().getServer().getTransactionManager().begin();
                        tx = this.getTransaction();
                        if (tx == null) {
                            throw new NullPointerException("Transaciton should not be null.");
                        }
                        tx.setRollbackOnly();
                        this.created = true;
                        if (DBProperties.getTransactionDebug()) {
                            if (tx != null) {
                                this.debug("receive_request(ri)---state.transaction = " + tx);
                            } else {
                                this.debug("receive_request(ri)---state.transaction is NULL after trying to start a NEW-Txn");
                            }
                        }
                    }
                    catch (NotSupportedException e) {
                        if (DBProperties.getTransactionDebug()) {
                            this.debug("receive_request(ri)---NotSupportedException caught...");
                            e.printStackTrace();
                        }
                    }
                    catch (javax.transaction.SystemException e) {
                        if (!DBProperties.getTransactionDebug()) break block34;
                        this.debug("receive_request(ri)---javax.transaction.SystemException caught...");
                        e.printStackTrace();
                    }
                }
            }
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("receive_request(ri): end");
        }
    }

    private BeanDescriptor getBeanDescriptor(ServerRequestInfo ri) {
        EJBObjectID objectID = null;
        CorbaEJBHome home = null;
        BeanDescriptor descriptor = null;
        try {
            if (EJBObjectID.hasEJBObjectID(ri.object_id())) {
                objectID = (EJBObjectID)EJBObjectID.extract(ri.object_id());
                home = HomeLocator.getHome(objectID);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (home != null) {
            descriptor = ((EJBObjectKey)((Object)home)).getBeanDescriptor();
        } else if (DBProperties.getTransactionDebug()) {
            this.debug("receive_request(ri)---home is NULL");
        }
        return descriptor;
    }

    public void send_reply(ServerRequestInfo ri) {
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_reply(ri): begin");
            this.printServerRequestInfo(ri, "send_reply(ri)---");
        }
        Transaction tx = this.getTransaction();
        if (this.created && tx != null) {
            if (DBProperties.getTransactionDebug()) {
                this.debug("send_reply(ri)---resetting the state.transaction to NULL...");
            }
            tx = null;
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_reply(ri): end");
        }
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_exception(ri): begin");
            this.printServerRequestInfo(ri, "send_exception(ri)---");
        }
        Transaction tx = this.getTransaction();
        if (this.created && tx != null) {
            if (DBProperties.getTransactionDebug()) {
                this.debug("send_exception(ri)---resetting the state.transaction to NULL...");
            }
            tx = null;
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_exception(ri): end");
        }
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_other(ri): begin");
            this.printServerRequestInfo(ri, "send_other(ri)---");
        }
        Transaction tx = this.getTransaction();
        if (this.created && tx != null) {
            if (DBProperties.getTransactionDebug()) {
                this.debug("send_other(ri)---resetting the state.transaction to NULL...");
            }
            tx = null;
        }
        if (DBProperties.getTransactionDebug()) {
            this.debug("send_other(ri): end");
        }
    }

    public boolean isNullContext(ServiceContext svc) throws INTERNAL {
        return this.isNullContext(this.getPropagationContext(svc));
    }

    public boolean isNullContext(PropagationContext ctx) {
        return ctx.current.coord == null && ctx.current.term == null;
    }

    public boolean isDummyContext(ServiceContext svc) throws INTERNAL {
        return this.isDummyContext(this.getPropagationContext(svc));
    }

    public boolean isDummyContext(PropagationContext ctx) {
        boolean proceed = false;
        try {
            proceed = ctx.implementation_specific_data.extract_boolean();
        }
        catch (BAD_OPERATION e) {
            return false;
        }
        return proceed && this.isNullContext(ctx) && ctx.timeout == -1;
    }

    public static void setThreadLocalData(int slot, Integer data) {
        Object[] threadLocalState = (Object[])otsThreadLocal.get();
        ((Stack)threadLocalState[slot]).push(data);
    }

    public static Integer getThreadLocalData(int slot) {
        Object[] threadLocalState = (Object[])otsThreadLocal.get();
        return (Integer)((Stack)threadLocalState[slot]).pop();
    }

    public static void setOrb(ORB orb) {
        txOrb = orb;
    }

    private PropagationContext getPropagationContext(ServiceContext svc) throws INTERNAL {
        if (svc == null) {
            throw new INTERNAL();
        }
        Any any = null;
        try {
            TypeCode typeCode = PropagationContextHelper.type();
            any = this.codec.decode_value(svc.context_data, typeCode);
        }
        catch (TypeMismatch e) {
            throw new INTERNAL();
        }
        catch (FormatMismatch e) {
            throw new INTERNAL();
        }
        return PropagationContextHelper.extract((Any)any);
    }

    protected void debug(String msg) {
        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-InterceptorImpl." + msg);
    }

    private void printServerRequestInfo(ServerRequestInfo ri, String s) {
        this.debug(s + "ri.request_id = " + ri.request_id());
        this.debug(s + "ri.operation = " + ri.operation());
        if (ri.response_expected()) {
            this.debug(s + "ri.response_expected is TRUE");
        } else {
            this.debug(s + "ri.response_expected is FALSE");
        }
        if (ri.reply_status() == 0) {
            this.debug(s + "ri.reply_status = SUCCESSFUL");
        } else if (ri.reply_status() == 1) {
            this.debug(s + "ri.reply_status = SYSTEM_EXCEPTION");
        } else if (ri.reply_status() == 2) {
            this.debug(s + "ri.reply_status = USER_EXCEPTION");
        } else if (ri.reply_status() == 3) {
            this.debug(s + "ri.reply_status = LOCATION_FORWARD");
        } else if (ri.reply_status() == 4) {
            this.debug(s + "ri.reply_status = TRANSPORT_RETRY");
        } else {
            this.debug(s + "ri.reply_status = UNKNOWN");
        }
    }

    private Transaction getTransaction() {
        ApplicationServer appserver = ApplicationServer.getInstance();
        if (appserver == null) {
            return null;
        }
        TransactionManager tm = appserver.getTransactionManager();
        if (tm == null) {
            return null;
        }
        try {
            return tm.getTransaction();
        }
        catch (javax.transaction.SystemException systemException) {
            this.debug("Tecieved SystemException from getTrasnaction : " + (Object)((Object)systemException));
            return null;
        }
    }

    private String getJavaMapping(String idlConstruct) {
        if (idlConstruct == null) {
            return null;
        }
        if (idlConstruct.equals("wchar")) {
            return "char";
        }
        if (idlConstruct.equals("octet")) {
            return "byte";
        }
        if (idlConstruct.equals("string") || idlConstruct.equals("WStringValue")) {
            return "java.lang.String";
        }
        if (idlConstruct.equals("short") || idlConstruct.equals("unsigned short")) {
            return "short";
        }
        if (idlConstruct.equals("long") || idlConstruct.equals("unsigned long")) {
            return "int";
        }
        if (idlConstruct.equals("long long") || idlConstruct.equals("unsigned long long")) {
            return "long";
        }
        if (idlConstruct.equals("fixed")) {
            return "java.math.BigDecimal";
        }
        return idlConstruct;
    }

    static {
        System.setProperty("org.omg.CORBA.ORBSingletonClass", "com.sun.corba.ee.impl.orb.ORBImpl");
        Any any = ORB.init().create_any();
        any.insert_boolean(false);
        nullContext = new PropagationContext(0, new TransIdentity(null, null, new otid_t(0, 0, new byte[0])), new TransIdentity[0], any);
        any.insert_boolean(true);
        dummyContext = new PropagationContext(-1, new TransIdentity(null, null, new otid_t(-1, 0, new byte[0])), new TransIdentity[0], any);
        txOrb = null;
    }
}

