/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop;

import com.sun.corba.ee.impl.legacy.connection.EndPointInfoImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.legacy.connection.EndPointInfo;
import com.sun.corba.ee.spi.legacy.connection.GetEndPointInfoAgainException;
import com.sun.corba.ee.spi.legacy.connection.ORBSocketFactory;
import com.sun.corba.ee.spi.orb.ORB;
import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import oracle.oc4j.corba.iiop.AlternateIIOPAddressComponent;
import oracle.oc4j.corba.iiop.AlternateIIOPAddressComponentHelper;
import oracle.oc4j.corba.iiop.security.ClientSecurityMechanismSelector;
import oracle.oc4j.corba.iiop.security.ConnectionContext;
import oracle.oc4j.corba.orb.OrbManager;
import oracle.oc4j.corba.security.IIOPSSLUtils;
import oracle.oc4j.corba.security.J2EEKeyManager;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;

public class ClientIIOPSSLSocketFactory
implements ORBSocketFactory,
Serializable {
    private static Logger _logger = null;
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String PERSISTENT_SSL = "PERSISTENT_SSL";
    private static final String clientStr = "true";
    private String type = null;
    private SSLContext ctx = null;
    private static SecureRandom sr;
    private Hashtable endpointTable = new Hashtable();
    private Codec codec;
    private static KeyManager[] keyManagers;
    private static TrustManager[] trustManagers;

    private void init() {
        try {
            if (ClientIIOPSSLSocketFactory.AreKeyAndTrustManagersNotReady()) {
                IIOPSSLUtils.getInstance().initStores();
            }
            this.ctx = SSLContext.getInstance("TLS");
            this.ctx.init(keyManagers, trustManagers, sr);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.init_exception", e);
        }
    }

    private void clientInit() {
        try {
            if (ClientIIOPSSLSocketFactory.AreKeyAndTrustManagersNotReady()) {
                IIOPSSLUtils.getInstance().initStores();
            }
            this.ctx = SSLContext.getInstance("TLS");
            KeyManager[] old = keyManagers;
            KeyManager[] mgrs = new J2EEKeyManager[old.length];
            for (int i = 0; i < old.length; ++i) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Setting J2EEKeyManager...");
                }
                mgrs[i] = new J2EEKeyManager((X509KeyManager)old[i]);
            }
            this.ctx.init(mgrs, trustManagers, sr);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.client_init_exception", e);
        }
    }

    public ServerSocket createServerSocket(String type, int port) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating server socket for type=" + type + " port=" + port);
        }
        if (type.equals(SSL_MUTUALAUTH) || type.equals(SSL) || type.equals(PERSISTENT_SSL)) {
            return this.createSSLServerSocket(type, port);
        }
        return new ServerSocket(port);
    }

    private ServerSocket createSSLServerSocket(String type, int port) throws IOException {
        if (this.ctx == null) {
            this.init();
        }
        if (keyManagers == null) {
            System.out.println("Keystore may not have been specified - It is needed when starting up the server");
            throw new RuntimeException("Keystore may not have been specified - It is needed when starting up the server");
        }
        SSLServerSocketFactory ssf = this.ctx.getServerSocketFactory();
        String[] cs = null;
        if (_logger.isLoggable(Level.FINE)) {
            cs = ssf.getSupportedCipherSuites();
            for (int i = 0; i < cs.length; ++i) {
                _logger.log(Level.FINE, "Cipher Suite: " + cs[i]);
            }
        }
        ServerSocket ss = null;
        try {
            ss = ssf.createServerSocket(port);
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "iiop.createsocket_exception", new java.lang.Object[]{type, String.valueOf(port)});
            _logger.log(Level.SEVERE, "", e);
            throw e;
        }
        try {
            if (type.equals(SSL_MUTUALAUTH)) {
                _logger.log(Level.FINE, "Setting Mutual auth");
                ((SSLServerSocket)ss).setNeedClientAuth(true);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.cipher_exception", e);
            throw new IOException(e.getMessage());
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Created server socket:" + ss);
        }
        return ss;
    }

    public EndPointInfo getEndPointInfo(org.omg.CORBA.ORB orb, IOR ior, EndPointInfo endPointInfo) {
        try {
            IIOPAddress primary = null;
            ClientSecurityMechanismSelector selector = OrbManager.getSecurityMechanismSelector();
            IIOPProfile iiopProfile = ior.getProfile();
            if (!(iiopProfile instanceof IIOPProfileTemplate)) {
                System.out.print("ClientIIOPSSLSocketFactory.getEndpointInfo: iopprofile is not an instance of IIOPProfileTemplate");
                return null;
            }
            IIOPProfileTemplate iiopProfileTempl = (IIOPProfileTemplate)iiopProfile;
            primary = iiopProfileTempl.getPrimaryAddress();
            String host = primary.getHost().toLowerCase();
            int port = 0;
            ConnectionContext ctx = new ConnectionContext();
            EndPointInfo info = (EndPointInfo)selector.getSSLPort(ior, ctx);
            selector.setClientConnectionContext(ctx);
            if (info == null) {
                this.type = "IIOP_CLEAR_TEXT";
                port = primary.getPort();
            } else {
                this.type = info.getType();
                port = info.getPort();
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Connection Context:" + ctx);
                _logger.log(Level.FINE, "ENDPOINT INFO:type=" + this.type + ",host=" + host + ", port=" + port);
            }
            if (this.type != "IIOP_CLEAR_TEXT") {
                if (info != null) {
                    return info;
                }
                return new EndPointInfoImpl(this.type, port, host);
            }
            endPointInfo = (EndPointInfoImpl)this.endpointTable.get(host + port);
            if (endPointInfo != null) {
                return endPointInfo;
            }
            TaggedComponent[] alternateAddressTaggedComponents = iiopProfileTempl.getIOPComponents((ORB)orb, 89374);
            if (alternateAddressTaggedComponents.length > 0) {
                this.getCodec(orb);
                for (int i = 0; i < alternateAddressTaggedComponents.length; ++i) {
                    byte[] data = alternateAddressTaggedComponents[i].component_data;
                    Any any = null;
                    try {
                        any = this.codec.decode_value(data, AlternateIIOPAddressComponentHelper.type());
                    }
                    catch (TypeMismatch e) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Exception codec TypeMismatch", e);
                        }
                        throw new RuntimeException(e.toString());
                    }
                    catch (FormatMismatch e) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Exception codec FormatMismatch", e);
                        }
                        throw new RuntimeException(e.toString());
                    }
                    AlternateIIOPAddressComponent iiopAddress = AlternateIIOPAddressComponentHelper.extract(any);
                    endPointInfo = (EndPointInfoImpl)this.endpointTable.get(iiopAddress.host + iiopAddress.port);
                    if (endPointInfo == null) continue;
                    this.endpointTable.put(host + port, endPointInfo);
                    return endPointInfo;
                }
                endPointInfo = new EndPointInfoImpl(this.type, port, host);
                this.endpointTable.put(host + port, endPointInfo);
            } else {
                endPointInfo = new EndPointInfoImpl(this.type, port, host);
                this.endpointTable.put(host + port, endPointInfo);
            }
            return endPointInfo;
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception getting End point info", ex);
            }
            throw new RuntimeException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Codec getCodec(org.omg.CORBA.ORB orb) {
        if (this.codec == null) {
            ClientIIOPSSLSocketFactory clientIIOPSSLSocketFactory = this;
            synchronized (clientIIOPSSLSocketFactory) {
                CodecFactory codecFactory = null;
                try {
                    codecFactory = CodecFactoryHelper.narrow((Object)orb.resolve_initial_references("CodecFactory"));
                }
                catch (InvalidName e) {
                    System.out.println("Getting org.omg.CORBA.ORBPackage.InvalidName exception");
                }
                Encoding encoding = new Encoding(0, 1, 2);
                try {
                    this.codec = codecFactory.create_codec(encoding);
                }
                catch (UnknownEncoding e) {
                    System.out.println("Getting org.omg.IOP.CodecFactoryPackage.UnknownEncoding exception");
                }
            }
        }
        return this.codec;
    }

    public Socket createSocket(EndPointInfo endPointInfo) throws IOException, GetEndPointInfoAgainException {
        try {
            String type = endPointInfo.getType();
            String host = endPointInfo.getHost();
            int port = endPointInfo.getPort();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "createSocket(" + type + ", " + host + ", " + port + ")");
            }
            if (type.equals(SSL) || type.equals(SSL_MUTUALAUTH)) {
                return this.createSSLSocket(host, port);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Creating CLEAR_TEXT socket for:" + port);
            }
            return new Socket(host, port);
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception creating socket", ex);
            }
            throw new RuntimeException(ex);
        }
    }

    private Socket createSSLSocket(String host, int port) throws IOException {
        SSLSocket socket = null;
        SSLSocketFactory factory = null;
        try {
            if (clientStr != null && clientStr.equals(clientStr)) {
                if (this.ctx == null) {
                    this.clientInit();
                }
                factory = this.ctx.getSocketFactory();
            } else {
                factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Creating SSL Socket for host:" + host + " port:" + port);
            }
            socket = (SSLSocket)factory.createSocket(host, port);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "iiop.createsocket_exception", new java.lang.Object[]{host, String.valueOf(port)});
                _logger.log(Level.FINE, "", e);
            }
            IOException e2 = new IOException("Error opening SSL socket to host=" + host + " port=" + port);
            e2.initCause(e);
            throw e2;
        }
        return socket;
    }

    public static void setManagers(KeyManager[] kms, TrustManager[] tms) {
        keyManagers = kms;
        trustManagers = tms;
    }

    private static boolean AreKeyAndTrustManagersNotReady() {
        return keyManagers == null || trustManagers == null;
    }

    static {
        _logger = Logger.getLogger("oc4j.orb.logger");
        sr = new SecureRandom();
        sr.setSeed(System.currentTimeMillis());
    }
}

