/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.jmx.shared.deploy.NotificationUserData;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.ResourceAdapterModuleCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEModuleBase;
import oracle.oc4j.admin.management.mbeans.ResourceAdapterModuleMBean;

public class ResourceAdapterModule
extends J2EEModuleBase
implements ResourceAdapterModuleMBean {
    private static Logger logger_ = TraceLogger.getLogger(ResourceAdapterModule.class);
    ResourceAdapterModuleCallBackIf callBackIf_ = null;

    public ResourceAdapterModule(ResourceAdapterModuleCallBackIf callBackIf, String j2eeAppName, String j2eeServerName, String moduleName, String domain) {
        super(callBackIf, moduleName, j2eeAppName, j2eeServerName, domain);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=ResourceAdapterModule,name=" + this.getModuleName() + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName());
        this.init();
    }

    public ResourceAdapterModule(ResourceAdapterModuleCallBackIf callBackIf, String j2eeAppName, String moduleName) {
        super(callBackIf, moduleName, j2eeAppName);
        this.callBackIf_ = callBackIf;
        this.setBaseObjectName(":j2eeType=ResourceAdapterModule,name=" + this.getModuleName() + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName());
        this.init();
    }

    public ResourceAdapterModule(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        HashMap<String, String> persistenceDescriptorProperties = new HashMap<String, String>();
        persistenceDescriptorProperties.put("persistPolicy", "OnUpdate");
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("persistPolicy", "OnUpdate");
        metaData.put("requireRestart", "applicationRestart");
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("ResourceAdapters", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("resourceadaptermodule_resourceAdapters"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("resourceAdapters", "[Ljava.lang.String;", this.getLocalizedMessage("resourceadaptermodule_resourceAdapters"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("nativeLibraryPath", "java.lang.String", this.getLocalizedMessage("resourceadaptermodule_nativeLibraryPath"), true, true, false), metaData);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("startOrder", "int", this.getLocalizedMessage("resourceadaptermodule_startOrder"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("path", "java.lang.String", this.getLocalizedMessage("resourceadaptermodule_path"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("eisType", "java.lang.String", this.getLocalizedMessage("resourceadaptermodule_eisType"), true, false, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("persistConfigChange", this.getLocalizedMessage("resourceadaptermodule_persistConfigChange"), null, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("start", this.getLocalizedMessage("resourceadaptermodule_start"), new MBeanParameterInfo[0], "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("stop", this.getLocalizedMessage("resourceadaptermodule_stop"), new MBeanParameterInfo[0], "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("startRecursive", this.getLocalizedMessage("resourceadaptermodule_startRecursive"), new MBeanParameterInfo[0], "void", 1));
    }

    public String getDescription() {
        return this.getLocalizedMessage("resourceadaptermodule_description");
    }

    public ObjectName[] getResourceAdapters() throws JMXException {
        ObjectName[] res = null;
        String entityPattern = "*:j2eeType=ResourceAdapter,ResourceAdapterModule=" + this.getModuleName() + ",J2EEApplication=" + this.getApplicationName() + ",J2EEServer=" + this.getJ2eeServerName() + ",*";
        res = this.getObjectNameForPattern(entityPattern);
        return res;
    }

    public String[] getresourceAdapters() throws JMXException {
        ObjectName[] objs = this.getResourceAdapters();
        if (objs == null) {
            return null;
        }
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return res;
    }

    public String getnativeLibraryPath() throws JMXException {
        return this.callBackIf_.getNativeLibraryPath();
    }

    public void setnativeLibraryPath(String newPath) throws JMXException {
        this.callBackIf_.setNativeLibraryPath(newPath);
    }

    public int getstartOrder() throws JMXException {
        return this.callBackIf_.getStartOrder();
    }

    public void setStartOrder(int newStartOrder) throws JMXException {
        this.callBackIf_.setStartOrder(newStartOrder);
    }

    public String getdeploymentDescriptor() {
        return this.callBackIf_.getdeploymentDescriptor();
    }

    public String getproprietaryDeploymentDescriptor() {
        return this.callBackIf_.getproprietaryDeploymentDescriptor();
    }

    public void persistConfigChange() {
        this.callBackIf_.persistConfigChange();
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        try {
            this.persistConfigChange();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String getpath() throws JMXException {
        return this.callBackIf_.getPath();
    }

    public String geteisType() throws JMXException {
        ObjectName[] resourceAdapterMBeans = this.getResourceAdapters();
        MBeanServer mbeanServer = this.getMBeanServer();
        if (resourceAdapterMBeans.length == 1) {
            try {
                String eisType = (String)mbeanServer.getAttribute(resourceAdapterMBeans[0], "eisType");
                return eisType;
            }
            catch (Exception e) {
                throw new JMXException("Unable to get EIS type via resource adapter MBean");
            }
        }
        throw new JMXException("Unable to get handle of descriptor information to determining EIS type");
    }

    public void start() {
        try {
            ResourceBundle bundle = this.getResourceBundle();
            MessageLocalizationHelper locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
            ObjectName[] resourceAdapterMBeans = this.getResourceAdapters();
            MBeanServer mbeanServer = this.getMBeanServer();
            for (int i = 0; i < resourceAdapterMBeans.length; ++i) {
                mbeanServer.invoke(resourceAdapterMBeans[i], "start", new Object[0], new String[0]);
                this.reportStateManagementSuccess("j2ee.state.running", locHelp.getLocalizedMessage("statemanageable_success_start"));
            }
        }
        catch (Exception jmxException) {
            System.out.println("ResourceAdapterModule.start");
            jmxException.printStackTrace();
            throw new JMXRuntimeException((Throwable)jmxException);
        }
    }

    public void stop() {
        try {
            ResourceBundle bundle = this.getResourceBundle();
            MessageLocalizationHelper locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
            ObjectName[] resourceAdapterMBeans = this.getResourceAdapters();
            MBeanServer mbeanServer = this.getMBeanServer();
            for (int i = 0; i < resourceAdapterMBeans.length; ++i) {
                mbeanServer.invoke(resourceAdapterMBeans[i], "stop", new Object[0], new String[0]);
                this.reportStateManagementSuccess("j2ee.state.stopped", locHelp.getLocalizedMessage("statemanageable_success_stop"));
            }
        }
        catch (Exception jmxException) {
            System.out.println("ResourceAdapterModule.stop");
            jmxException.printStackTrace();
            throw new JMXRuntimeException((Throwable)jmxException);
        }
    }

    public void stop(Map params) {
        this.stop();
    }

    public void startRecursive() {
        try {
            ResourceBundle bundle = this.getResourceBundle();
            MessageLocalizationHelper locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
            ObjectName[] resourceAdapterMBeans = this.getResourceAdapters();
            MBeanServer mbeanServer = this.getMBeanServer();
            for (int i = 0; i < resourceAdapterMBeans.length; ++i) {
                mbeanServer.invoke(resourceAdapterMBeans[i], "startRecursive", new Object[0], new String[0]);
                this.reportStateManagementSuccess("j2ee.state.running", locHelp.getLocalizedMessage("statemanageable_success_start"));
            }
        }
        catch (Exception jmxException) {
            System.out.println("ResourceAdapterModule.start");
            jmxException.printStackTrace();
            throw new JMXRuntimeException((Throwable)jmxException);
        }
    }

    private void reportStateManagementSuccess(String nofifType, String notifMsg) {
        block2: {
            try {
                Notification notification = new Notification(nofifType, this.getObjectName(), 0L, new Date().getTime(), notifMsg + this.getObjectName());
                NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                notification.setUserData(userData);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

