/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.xml.EntityResolverUtil;
import com.evermind.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.mbeans.J2EEResourceBase;
import oracle.oc4j.admin.management.mbeans.JNDINamespaceMBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JNDINamespace
extends J2EEResourceBase
implements JNDINamespaceMBean {
    private static Logger logger_ = TraceLogger.getLogger(JNDINamespace.class);
    private static final String SCHEMA_NAMESPACE_LOCATION = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_NAME = "oc4j-jndi-bindings-10_0.xsd";
    private static final String SCHEMA_LOCATION = "http://xmlns.oracle.com/oracleas/schema/oc4j-jndi-bindings-10_0.xsd";
    private static final ObjectName JNDI_RESOURCE_OBJECT_NAME = ObjectNameFactory.create((String)"*:j2eeType=JNDIResource,*");

    public JNDINamespace() {
        super("JNDINamespace");
        super.setBaseObjectName(":j2eeType=JNDINamespace,name=JNDINamespace,J2EEServer=" + this.getJ2eeServerName());
        this.setupMetaData();
    }

    public JNDINamespace(Locale locale) {
        super(locale);
        this.setupMetaData();
    }

    private void setupMetaData() {
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getAllBindingsAsXMLString", this.getLocalizedMessage("jndinamespace_getAllBindingsAsXMLString"), new MBeanParameterInfo[]{}, String.class.getName(), 0));
    }

    public String getAllBindingsAsXMLString() {
        String strToReturn = null;
        try {
            strToReturn = this.buildFullBindingListAsXML();
        }
        catch (ParserConfigurationException e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            strToReturn = null;
        }
        catch (IOException e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            strToReturn = null;
        }
        catch (InstantiationException e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            strToReturn = null;
        }
        catch (SAXException e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
            strToReturn = null;
        }
        catch (TransformerException e) {
            strToReturn = null;
        }
        return strToReturn;
    }

    private String buildFullBindingListAsXML() throws ParserConfigurationException, IOException, InstantiationException, SAXException, TransformerException {
        MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
        Set<ObjectName> setOfMBeans = oc4jMBeanServer.queryNames(JNDI_RESOURCE_OBJECT_NAME, null);
        DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = buildFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element rootElement = document.createElement("oc4j-jndi-bindings");
        document.appendChild(rootElement);
        rootElement.setAttribute("xmlns:xsi", SCHEMA_NAMESPACE_LOCATION);
        rootElement.setAttribute("xsi:noNamespaceSchemaLocation", SCHEMA_LOCATION);
        Iterator<ObjectName> iterator = setOfMBeans.iterator();
        String strToReturn = new String();
        while (iterator.hasNext()) {
            ObjectName objName = iterator.next();
            try {
                String xmlBindings = (String)oc4jMBeanServer.invoke(objName, "getBindingsAsXMLString", null, new String[0]);
                InputSource inputSource = new InputSource(new ByteArrayInputStream(xmlBindings.getBytes()));
                Document appDocument = XMLUtils.getDocument(inputSource, null, EntityResolverUtil.getConfiguredEntityResolver(), true);
                Element appBindingsDoc = appDocument.getDocumentElement();
                Element appRootElement = (Element)appBindingsDoc.getElementsByTagName("application").item(0);
                Node clonedNode = document.importNode(appRootElement, true);
                rootElement.appendChild(clonedNode);
            }
            catch (InstanceNotFoundException e) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, e.getMessage(), e);
                }
                strToReturn = null;
            }
            catch (MBeanException e) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, e.getMessage(), e);
                }
                strToReturn = null;
            }
            catch (ReflectionException e) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, e.getMessage(), e);
                }
                strToReturn = null;
            }
        }
        strToReturn = JNDINamespace.buildStringFromDocument(document);
        return strToReturn;
    }

    private static String buildStringFromDocument(Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(document), new StreamResult(writer));
        return writer.getBuffer().toString();
    }
}

