/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.config;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import oracle.oc4j.admin.config.ConfigUtils;
import oracle.oc4j.admin.config.CreationException;
import oracle.oc4j.admin.config.LocalizationHelper;
import oracle.security.jazn.JAZNConfig;
import oracle.security.jazn.realm.Realm;
import oracle.security.jazn.realm.RealmManager;
import oracle.security.jazn.realm.RealmUser;
import oracle.security.jazn.realm.UserManager;
import oracle.security.jazn.spi.xml.XMLRealmUser;

public class InstanceConfig {
    String _oracleHome = null;
    String _configHome = null;
    String _oc4jName = null;
    String _oc4jPath = null;
    private File _oc4jDir = null;
    static final String SEP = File.separator;
    static LocalizationHelper _locHelper = null;

    public InstanceConfig(String oracleHome, String configHome, String oc4jName) {
        this._oracleHome = oracleHome;
        this._configHome = configHome;
        this._oc4jName = oc4jName;
        if (this._oracleHome.charAt(this._oracleHome.length() - 1) == File.separatorChar) {
            this._oracleHome = this._oracleHome.substring(0, this._oracleHome.length() - 1);
        }
        if (this._configHome.charAt(this._configHome.length() - 1) == File.separatorChar) {
            this._configHome = this._configHome.substring(0, this._configHome.length() - 1);
        }
        this._oc4jPath = this._configHome + SEP + "j2ee" + SEP + this._oc4jName;
        _locHelper = new LocalizationHelper();
    }

    public void activateUser(String password) throws CreationException {
        ConfigUtils.log("Activating the oc4jadmin user for the new OC4J instance " + this._oc4jName);
        try {
            String jaznPath = this._oc4jPath + SEP + "config" + SEP + "jazn.xml";
            ConfigUtils.log("Reading JAAS configuration settings in the file " + jaznPath);
            ConfigUtils.log("jaznPath.exists() = " + new File(jaznPath).exists());
            JAZNConfig jaznconfig = new JAZNConfig(jaznPath);
            RealmManager realmManager = jaznconfig.getRealmManager();
            Realm realm = realmManager.getRealm(jaznconfig.getDefaultRealm());
            if (realm == null) {
                throw new Exception(_locHelper.getMessage("default_realm_not_found"));
            }
            UserManager userManager = realm.getUserManager();
            RealmUser realmUser = userManager.getAdminUser();
            if (realmUser == null) {
                throw new Exception(_locHelper.getMessage("admin_user_not_found", realmUser.getName()));
            }
            XMLRealmUser xmlRealmUser = (XMLRealmUser)realmUser;
            if (!xmlRealmUser.isDeactivated()) {
                throw new CreationException(_locHelper.getMessage("admin_user_not_deactivated", realmUser.getName(), this._oc4jPath));
            }
            xmlRealmUser.setCredentialsNoCheck(password);
            xmlRealmUser.setDeactivated(false);
            jaznconfig.getJAZNProvider().persist();
        }
        catch (CreationException ce) {
            throw ce;
        }
        catch (IOException ioe) {
            throw new CreationException(ioe, ioe.getMessage());
        }
        catch (SecurityException se) {
            throw new CreationException(se, se.getMessage());
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
    }

    public void checkExistingDirectory() throws CreationException {
        File oc4jDirectory = new File(this._oc4jPath);
        try {
            ConfigUtils.log(_locHelper.getMessage("check_existing_directory", oc4jDirectory.getCanonicalFile().toString()));
            if (oc4jDirectory.exists()) {
                if (oc4jDirectory.getCanonicalFile().getName().equals(this._oc4jName)) {
                    throw new CreationException(_locHelper.getMessage("directory_exists", this._oc4jPath));
                }
                throw new CreationException(_locHelper.getMessage("directory_exists_case_insensitive", this._oc4jPath));
            }
        }
        catch (IOException ioe) {
            throw new CreationException(ioe, ioe.getMessage());
        }
        catch (CreationException ce) {
            throw ce;
        }
    }

    public void installNewInstance() throws CreationException {
        String TEMPLATE_JAR = "template.jar";
        String j2eePath = this._oracleHome + SEP + "j2ee";
        String defaultTemplateJarName = j2eePath + SEP + "home" + SEP + "lib" + SEP + TEMPLATE_JAR;
        File defaultTemplateJar = new File(defaultTemplateJarName);
        ConfigUtils.log(_locHelper.getMessage("unjar_template_jar", defaultTemplateJarName));
        if (!defaultTemplateJar.exists()) {
            throw new CreationException(_locHelper.getMessage("file_not_exist", defaultTemplateJarName));
        }
        File oc4jDir = new File(this._oc4jPath);
        try {
            if (!oc4jDir.exists() && !oc4jDir.mkdirs()) {
                throw new CreationException(_locHelper.getMessage("fail_create_directory", this._oc4jPath));
            }
            ConfigUtils.unjar(this._oc4jPath, defaultTemplateJar);
            String oc4jDotPropertiesPath = this._oc4jPath + SEP + "config" + SEP + "oc4j.properties";
            File oc4jDotProperties = new File(oc4jDotPropertiesPath);
            if (!oc4jDotProperties.exists()) {
                ConfigUtils.log(_locHelper.getMessage("create_file", oc4jDotPropertiesPath));
                oc4jDotProperties.createNewFile();
            }
        }
        catch (CreationException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new CreationException(t, _locHelper.getMessage("fail_initialize_oc4j", this._oc4jPath) + ": " + t.getMessage());
        }
    }

    public void updateXML(Map extraParams) throws CreationException {
        String xmlPath = this._oc4jPath + SEP + "config" + SEP;
        try {
            if (extraParams.get("asc.routable") != null && extraParams.get("asc.routable").equals("true")) {
                ConfigUtils.updateXML(xmlPath + "default-web-site.xml", "web-app", "ascontrol", "ohs-routing", "true");
            } else {
                ConfigUtils.updateXML(xmlPath + "default-web-site.xml", "web-app", "ascontrol", "ohs-routing", "false");
            }
            if (extraParams.get("asc.enable") != null && extraParams.get("asc.enable").equals("true")) {
                ConfigUtils.updateXML(xmlPath + "server.xml", "application", "ascontrol", "start", "true");
            } else {
                ConfigUtils.updateXML(xmlPath + "server.xml", "application", "ascontrol", "start", "false");
            }
            ConfigUtils.updateXML(xmlPath + "server.xml", "application", "javasso", "start", "false");
            ConfigUtils.instantiateVarsInXmls(xmlPath + "server.xml", null, "%s_oraclehome%", this._oracleHome);
            ConfigUtils.instantiateVarsInXmls(xmlPath + "application.xml", null, "%s_oraclehome%", this._oracleHome);
            ConfigUtils.instantiateVarsInXmls(xmlPath + "system-application.xml", null, "%s_oraclehome%", this._oracleHome);
            ConfigUtils.instantiateVarsInXmls(xmlPath + "java2.policy", "connector", "${oracle.oc4j.instancename}", this._oc4jName);
            ConfigUtils.instantiateVarsInXmls(xmlPath + "j2ee-logging.xml", null, "%s_oracleconfighome%", this._configHome);
        }
        catch (CreationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
    }

    public void permitRemove(boolean continueOnError) throws CreationException {
        try {
            boolean ready = this.prepareRemoveInstance(continueOnError);
            if (ready) {
                ConfigUtils.recursiveRemove(this.getOc4jDir());
            }
        }
        catch (CreationException ce) {
            throw ce;
        }
        catch (Exception ce) {
            throw new CreationException(ce, _locHelper.getMessage("error_delete_directory", this._oc4jName) + ": " + ce.getMessage());
        }
    }

    private boolean prepareRemoveInstance(boolean continueOnError) throws CreationException {
        File oc4jDir = new File(this._oc4jPath);
        if (oc4jDir.exists()) {
            this.setOc4jDir(oc4jDir);
            return true;
        }
        if (continueOnError) {
            return false;
        }
        throw new CreationException(_locHelper.getMessage("file_not_exist", oc4jDir.toString()));
    }

    private void setOc4jDir(File dir) {
        this._oc4jDir = dir;
    }

    private File getOc4jDir() {
        return this._oc4jDir;
    }
}

