/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.config;

import com.evermind.security.User;
import com.evermind.util.CharString;
import com.evermind.util.ConsoleObfuscator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import oracle.ias.opmn.optic.CharBuf;
import oracle.ias.opmn.optic.OpmnHostPort;
import oracle.ias.opmn.optic.OpmnQuery;
import oracle.ias.opmn.optic.OpticBadConnectException;
import oracle.ias.opmn.optic.OpticException;
import oracle.oc4j.admin.config.CreationException;
import oracle.oc4j.admin.config.LocalizationHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigUtils {
    static LocalizationHelper _locHelper = new LocalizationHelper();
    private static boolean _isDebug = false;

    static String getNextArgument(List args, String description) throws CreationException {
        if (args == null || args.isEmpty()) {
            throw new CreationException(_locHelper.getMessage("missing_argument") + description);
        }
        return (String)args.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unjar(String dirName, File archive) throws IOException {
        dirName = dirName + System.getProperty("file.separator");
        JarFile jarfile = new JarFile(archive);
        File directory = null;
        boolean canAccess = false;
        Object errMsg = null;
        try {
            directory = new File(dirName);
            if (directory.canWrite()) {
                canAccess = true;
            }
        }
        catch (SecurityException se) {
            throw new IOException(_locHelper.getMessage("can_not_write") + dirName);
        }
        if (!canAccess) {
            throw new IOException(_locHelper.getMessage("can_not_write") + dirName);
        }
        byte[] buf = new byte[1024];
        Enumeration<JarEntry> e = jarfile.entries();
        while (e.hasMoreElements()) {
            InputStream entryStream;
            block10: {
                Object var14_14;
                JarEntry entry = new JarEntry((ZipEntry)e.nextElement());
                if (entry.getName().equals("META-INF/") || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                String entryName = dirName + entry.getName();
                if (entry.isDirectory()) {
                    new File(entryName).mkdir();
                    continue;
                }
                File entryFile = new File(entryName);
                entryFile.createNewFile();
                entryStream = null;
                FileOutputStream fileStream = null;
                try {
                    entryStream = jarfile.getInputStream(entry);
                    fileStream = new FileOutputStream(entryFile);
                    ConfigUtils.copy(entryStream, fileStream, buf);
                    var14_14 = null;
                    if (fileStream == null) break block10;
                }
                catch (Throwable throwable) {
                    var14_14 = null;
                    if (fileStream != null) {
                        fileStream.close();
                    }
                    if (entryStream != null) {
                        entryStream.close();
                    }
                    throw throwable;
                }
                fileStream.close();
            }
            if (entryStream == null) continue;
            entryStream.close();
            {
            }
        }
    }

    static void copy(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        int bytes;
        while ((bytes = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytes);
        }
    }

    static void recursiveRemove(File file) throws IOException {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; files != null && i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        ConfigUtils.recursiveRemove(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException(_locHelper.getMessage("cannot_delete_file") + new String[]{files[i].getName()});
                }
            }
            if (!file.delete()) {
                throw new IOException(_locHelper.getMessage("cannot_delete_file") + new String[]{file.getName()});
            }
        }
    }

    static boolean isValidName(String name) {
        int i;
        char[] reserved = new char[]{' ', '\"', '\'', '@', '|', '&', ',', ':', '#', '?', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0005', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001f', '\u007f'};
        if (name == null || name.equals("")) {
            return false;
        }
        for (int i2 = 0; i2 < reserved.length; ++i2) {
            if (name.indexOf(reserved[i2]) == -1) continue;
            System.err.println(_locHelper.getMessage("error_name_contains_reserved_character") + String.valueOf(reserved[i2]));
            return false;
        }
        int j = 0;
        int stringLength = name.length();
        for (j = 0; j < stringLength && name.indexOf(".", j) == j; ++j) {
        }
        if (j == stringLength) {
            return false;
        }
        char[] specialCharacters = new char[]{'/', '*', '~', '\\', '[', ']', '$', '%', '^', '*', '(', ')', '+', '=', '{', '}', ';', '<', '>', '\''};
        for (i = 0; i < specialCharacters.length; ++i) {
            if (name.indexOf(specialCharacters[i]) == -1) continue;
            System.err.println(_locHelper.getMessage("error_name_contains_special_character") + String.valueOf(specialCharacters[i]));
            return false;
        }
        for (i = 0; i < name.length(); ++i) {
            if (name.charAt(i) <= '\u0080') continue;
            System.err.println(_locHelper.getMessage("error_name_contains_nonascii_character") + name);
            return false;
        }
        return true;
    }

    static String queryPasswordFromUser(String oc4jName) throws CreationException, IOException {
        String firstPrompt = _locHelper.getMessage("enter_password");
        String secondPrompt = _locHelper.getMessage("confirm_password");
        String password = null;
        System.out.print(_locHelper.getMessage("set_password", oc4jName));
        char[] firstPwd = ConfigUtils.readPassword(System.out, System.in, firstPrompt);
        char[] secondPwd = ConfigUtils.readPassword(System.out, System.in, secondPrompt);
        if (firstPwd == null || secondPwd == null) {
            throw new CreationException(_locHelper.getMessage("password_null"));
        }
        if (!ConfigUtils.isValidPwd(firstPwd) || !ConfigUtils.isValidPwd(secondPwd)) {
            throw new CreationException(_locHelper.getMessage("no_special_characters_in_password"));
        }
        CharString first = new CharString(firstPwd);
        CharString second = new CharString(secondPwd);
        if (!first.equals(second)) {
            throw new CreationException(_locHelper.getMessage("password_mismatch"));
        }
        password = new String(firstPwd);
        return password;
    }

    static char[] testReadPassword(PrintStream out, InputStream in) throws IOException {
        return ConfigUtils.readPassword(out, in, "Enter password:");
    }

    /*
     * WARNING - void declaration
     */
    private static char[] readPassword(PrintStream outs, InputStream ins, String prompt) throws IOException {
        char[] lineBuffer;
        ConsoleObfuscator obfuscator = new ConsoleObfuscator(outs, prompt);
        obfuscator.start();
        InputStream in = ins;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    void var10_9;
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)var10_9;
                    continue block4;
                }
            }
            break;
        }
        obfuscator.finishObfuscate();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    private static boolean isValidPwd(char[] c) {
        char[] specialPwd = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '-'};
        boolean found = false;
        for (int i = 0; i < c.length; ++i) {
            found = false;
            for (int j = 0; j < specialPwd.length; ++j) {
                if (c[i] != specialPwd[j]) continue;
                found = true;
                break;
            }
            if (!found) break;
        }
        return found;
    }

    static void updateXML(String xmlFile, String elementName, String attrIdValue, String attrToBeUpdated, String value) throws CreationException {
        if (_isDebug) {
            System.out.println("Update the attribute '" + attrToBeUpdated + "' in the line containing " + elementName + "=" + attrIdValue + " with the new value '" + value + "' in " + xmlFile);
        }
        try {
            XMLDocument xdoc = ConfigUtils.loadDoc(xmlFile);
            Element theNode = ConfigUtils.traverseToNode(xdoc, elementName, attrIdValue);
            if (theNode == null) {
                throw new CreationException(_locHelper.getMessage("fail_get_element", elementName, attrIdValue) + xmlFile);
            }
            String attribute = ConfigUtils.getAttributeByName(theNode, attrToBeUpdated);
            if (attribute == null || attribute.equals("")) {
                throw new CreationException(_locHelper.getMessage("attribute_not_exist", attrToBeUpdated));
            }
            ConfigUtils.updateElement(theNode, attrToBeUpdated, value);
            ConfigUtils.saveDoc(xdoc, xmlFile);
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void instantiateVarsInXmls(String filePath, String index, String stringToBeUpdated, String newValue) throws CreationException {
        ConfigUtils.log("Instantiate '" + stringToBeUpdated + " 'variable with the value " + newValue + " in " + filePath);
        BufferedReader reader = null;
        StringBuffer contents = new StringBuffer();
        try {
            try {
                reader = new BufferedReader(new FileReader(filePath));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int pos = line.indexOf(stringToBeUpdated);
                    if (pos >= 0 && (index == null || index != null && line.indexOf(index) >= 0)) {
                        line = line.substring(0, pos) + newValue + line.substring(pos + stringToBeUpdated.length(), line.length());
                    }
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
                Object var9_10 = null;
            }
            catch (IOException e) {
                throw new CreationException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new CreationException(e.getMessage());
            }
        }
        try {}
        catch (IOException e) {
            throw new CreationException(e.getMessage());
        }
        if (reader != null) {
            reader.close();
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            writer.write(contents.toString());
            return;
        }
        catch (IOException e) {
            throw new CreationException(e.getMessage());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    static void reloadOPMN(String oracleHome) throws CreationException {
        ConfigUtils.log(_locHelper.getMessage("reload_opmn", oracleHome));
        String reloadCommand = "/reload";
        String pingCommand = "/ping";
        OpmnQuery oq = new OpmnQuery(null, 0, OpmnHostPort.LOCAL, oracleHome);
        try {
            CharBuf resultBuf = oq.getBuf(reloadCommand);
        }
        catch (OpticBadConnectException e) {
        }
        catch (OpticException e) {
            throw new CreationException(e, e.getMessage());
        }
        boolean dead = false;
        for (int i = 0; i < 60; ++i) {
            dead = true;
            try {
                ConfigUtils.log(_locHelper.getMessage("trying_ping"));
                CharBuf cb = oq.getBuf(pingCommand);
                dead = false;
            }
            catch (OpticBadConnectException e) {
            }
            catch (OpticException e) {
                throw new CreationException(e, e.getMessage());
            }
            if (!dead) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        ConfigUtils.log(_locHelper.getMessage("opmn_dead_alive", dead ? "dead" : "alive"));
    }

    static boolean pingOPMN(String oracleHome) throws CreationException {
        ConfigUtils.log(_locHelper.getMessage("ping_opmn", oracleHome));
        boolean isAlive = true;
        OpmnHostPort type = OpmnHostPort.LOCAL;
        OpmnQuery oq = new OpmnQuery(null, 0, type, oracleHome);
        try {
            CharBuf cb = oq.getBuf("/ping");
        }
        catch (OpticBadConnectException e) {
            isAlive = false;
        }
        catch (Exception e) {
            throw new CreationException(e.getMessage());
        }
        return isAlive;
    }

    private static XMLDocument loadDoc(String xmlFile) throws CreationException {
        XMLDocument xdoc = null;
        try {
            xdoc = ConfigUtils.getDoc(xmlFile);
            if (xdoc == null) {
                throw new CreationException("Error: xdoc for " + xmlFile + " is null.");
            }
        }
        catch (Exception e) {
            throw new CreationException(e.getMessage());
        }
        return xdoc;
    }

    private static Element traverseToNode(XMLDocument xdoc, String elementName, String attrIdValue) throws CreationException {
        String idValue = attrIdValue;
        Element node = null;
        int numNodes = 0;
        try {
            NodeList nodeList = xdoc.getDocumentElement().getElementsByTagName(elementName);
            numNodes = nodeList.getLength();
            if (numNodes == 0) {
                throw new CreationException("No element " + elementName + " in the xml file.");
            }
            for (int idx = 0; idx < numNodes; ++idx) {
                Element thisNode = (Element)nodeList.item(idx);
                String nameValue = thisNode.getAttribute("name");
                if (!nameValue.equals(idValue)) continue;
                node = thisNode;
                break;
            }
            if (node == null) {
                throw new CreationException("No element " + elementName + " with name=\"" + attrIdValue + "\".");
            }
        }
        catch (Exception e) {
            throw new CreationException("Failed to find the element " + elementName + ". " + e.getMessage());
        }
        return node;
    }

    private static String getAttributeByName(Element theNode, String attrName) {
        String attrValue = theNode.getAttribute(attrName);
        return attrValue;
    }

    private static void updateElement(Element theNode, String elementName, String elementValue) {
        theNode.setAttribute(elementName, elementValue);
    }

    private static boolean saveDoc(XMLDocument xdoc, String xmlFile) throws CreationException {
        try {
            ConfigUtils.writeDoc(xdoc, xmlFile);
            return true;
        }
        catch (IOException e) {
            throw new CreationException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized XMLDocument getDoc(String fileName) throws CreationException {
        DOMParser theParser = null;
        FileInputStream fileInput = null;
        XMLDocument srcDoc = null;
        try {
            try {
                fileInput = new FileInputStream(fileName);
                theParser = new DOMParser();
                theParser.setPreserveWhitespace(false);
                theParser.setValidationMode(0);
                theParser.retainCDATASection(true);
                theParser.setDebugMode(true);
                theParser.showWarnings(true);
                theParser.parse((InputStream)fileInput);
                srcDoc = theParser.getDocument();
            }
            catch (FileNotFoundException e) {
                throw new CreationException("File not found. can not build DOM " + e.getMessage());
            }
            catch (XMLParseException e) {
                throw new CreationException("caught XMLParseException. cannot build DOM " + e.getMessage());
            }
            catch (SAXException e) {
                throw new CreationException("caught SAXException. cannot build DOM " + e.getMessage());
            }
            catch (IOException e) {
                throw new CreationException("caught IOException. cannot build DOM" + e.getMessage());
            }
            Object var6_4 = null;
            if (fileInput == null) return srcDoc;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fileInput == null) throw throwable;
            try {
                fileInput.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new CreationException("can not close FileReader. " + e.getMessage());
            }
        }
        try {}
        catch (IOException e) {
            throw new CreationException("can not close FileReader. " + e.getMessage());
        }
        fileInput.close();
        return srcDoc;
    }

    private static synchronized void writeDoc(XMLDocument xmlDoc, String fileName) throws IOException {
        String fName = fileName;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fName);
            xmlDoc.print((OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException fe) {
            throw new IOException("Failed to write the file.\n" + fe.getMessage());
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    static void syncLocalOpmnMBeans(String oh, String oc4jName) {
        try {
            ConfigUtils.log("oh = " + oh + ", oc4jName = " + oc4jName + ".");
            ConfigUtils.log("Calling syncLocalOpmnMBeans() method on oracle.oc4j.admin.ias.runtime.TopologyUtil.");
            Class<?> cl = Class.forName("oracle.oc4j.admin.ias.runtime.TopologyUtil");
            Class[] paramTypes = new Class[]{String.class, String.class};
            Method methodSync = cl.getMethod("syncLocalOpmnMBeans", paramTypes);
            Object[] params = new Object[]{oh, oc4jName};
            methodSync.invoke(null, params);
        }
        catch (Exception e) {
            ConfigUtils.log("invoke syncLocalOpmnMBeans fails.");
            ConfigUtils.log(e);
        }
    }

    static void syncLocalOpmnMBeans(String oh, User user) {
        try {
            ConfigUtils.log("oh = " + oh + ", user = " + user + ".");
            ConfigUtils.log("Calling syncLocalOpmnMBeans() method on oracle.oc4j.admin.ias.runtime.TopologyUtil.");
            Class<?> cl = Class.forName("oracle.oc4j.admin.ias.runtime.TopologyUtil");
            Class[] paramTypes = new Class[]{String.class, User.class};
            Method methodSync = cl.getMethod("syncLocalOpmnMBeans", paramTypes);
            Object[] params = new Object[]{oh, user};
            methodSync.invoke(null, params);
        }
        catch (Exception e) {
            ConfigUtils.log("invoke syncLocalOpmnMBeans fails.");
            ConfigUtils.log(e);
        }
    }

    static User getAdminUser(String oh, String oc4jName) {
        try {
            ConfigUtils.log("oh = " + oh + ", oc4jName = " + oc4jName + ".");
            ConfigUtils.log("Calling getAdminUser() method on oracle.oc4j.admin.ias.runtime.TopologyUtil.");
            Class<?> cl = Class.forName("oracle.oc4j.admin.ias.runtime.TopologyUtil");
            Class[] paramTypes = new Class[]{String.class, String.class};
            Method methodGetAdminUser = cl.getMethod("getAdminUser", paramTypes);
            Object[] params = new Object[]{oh, oc4jName};
            Object ret = methodGetAdminUser.invoke(null, params);
            return (User)ret;
        }
        catch (Exception e) {
            ConfigUtils.log("invoke getAdminUser fails.");
            ConfigUtils.log(e);
            return null;
        }
    }

    static ObjectName getCompOc4jGroupMBean(MBeanServer mbeanServer, String oc4jName) throws CreationException {
        String CONFIG_MBEAN_NAME = "default";
        String DEFAULT_DOMAIN = "oc4j";
        try {
            ObjectName procOc4jName = new ObjectName("*:type=OpmnProcOc4j,OpmnConfig=" + CONFIG_MBEAN_NAME + ",name=" + oc4jName + ",*");
            Object[] procOc4jMBeans = mbeanServer.queryNames(procOc4jName, null).toArray();
            String groupName = null;
            if (procOc4jMBeans.length == 0) {
                throw new CreationException(_locHelper.getMessage("oc4j_not_exist", oc4jName));
            }
            if (procOc4jMBeans.length >= 1) {
                for (int i = 0; i < procOc4jMBeans.length; ++i) {
                    if (!((ObjectName)procOc4jMBeans[i]).getDomain().equals(DEFAULT_DOMAIN)) continue;
                    groupName = ((ObjectName)procOc4jMBeans[i]).getKeyProperty("OpmnCompOc4jGroup");
                }
            }
            if (groupName == null) {
                throw new CreationException(_locHelper.getMessage("not_find_group", oc4jName));
            }
            ObjectName compOc4jGroupName = new ObjectName("*:type=OpmnCompOc4jGroup,OpmnConfig=" + CONFIG_MBEAN_NAME + ",name=" + groupName);
            Object[] compOc4jGroupMBeans = mbeanServer.queryNames(compOc4jGroupName, null).toArray();
            if (compOc4jGroupMBeans.length == 0) {
                throw new CreationException(_locHelper.getMessage("group_not_exist", groupName));
            }
            if (compOc4jGroupMBeans.length >= 1) {
                for (int i = 0; i < compOc4jGroupMBeans.length; ++i) {
                    if (!((ObjectName)compOc4jGroupMBeans[i]).getDomain().equals(DEFAULT_DOMAIN)) continue;
                    return (ObjectName)compOc4jGroupMBeans[i];
                }
            }
        }
        catch (Exception e) {
            throw new CreationException(e, e.getMessage());
        }
        return null;
    }

    static boolean doDebug(boolean debug) {
        _isDebug = debug;
        return _isDebug;
    }

    static void log(Exception e) {
        if (_isDebug) {
            e.printStackTrace();
        }
    }

    static void log(String s) {
        if (_isDebug) {
            System.out.println(s);
        }
    }
}

