/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.work;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ThreadState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkRejectedException;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.Refresh;
import oracle.dms.instrument.StateIntf;
import oracle.j2ee.connector.work.BoundedTimeoutQueue;
import oracle.j2ee.connector.work.WorkManagerImpl;
import oracle.j2ee.connector.work.WorkThreadPoolFactory;
import oracle.j2ee.connector.work.WorkWrapper;
import oracle.oc4j.admin.management.shared.UserInfo;

public class WorkPooledExecutor
extends PooledExecutor
implements GroupRefresh {
    private int m_reservedThreadCount;
    private int m_workerThreadsWaitingForTask = 0;
    private Object m_workerThreadCountLock = new Object();
    private boolean m_queueUsed;
    private StateIntf m_queueSizeState;
    private StateIntf m_totalThreadCountState;
    private StateIntf m_idleThreadCountState;
    private EventIntf m_queueFullEvent;

    public WorkPooledExecutor(int minPoolSize, int maxPoolSize, long keepAlive) {
        super(maxPoolSize);
        this.setThreadFactory(new WorkThreadPoolFactory(Thread.currentThread().getThreadGroup()));
        this.setMinimumPoolSize(minPoolSize);
        this.setKeepAliveTime(keepAlive);
        this.abortWhenBlocked();
        this.createThreads(minPoolSize);
        this.setupDms(minPoolSize, maxPoolSize, 0, keepAlive);
        this.m_queueUsed = false;
    }

    public WorkPooledExecutor(int minPoolSize, int maxPoolSize, int queueSize, long keepAlive) {
        super(new BoundedTimeoutQueue(queueSize), maxPoolSize);
        this.setThreadFactory(new WorkThreadPoolFactory(Thread.currentThread().getThreadGroup()));
        this.setMinimumPoolSize(minPoolSize);
        this.setKeepAliveTime(keepAlive);
        this.abortWhenBlocked();
        this.createThreads(minPoolSize);
        this.setupDms(minPoolSize, maxPoolSize, queueSize, keepAlive);
        this.m_queueUsed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitWork(WorkWrapper workWrapper, long timeout) throws WorkException {
        int poolSize = 0;
        WorkPooledExecutor workPooledExecutor = this;
        synchronized (workPooledExecutor) {
            poolSize = this.poolSize_;
            if (this.shutdown_) {
                this.failShuttingDown(workWrapper);
            }
            try {
                workWrapper.fireWorkAccepted();
                if (poolSize < this.minimumPoolSize_) {
                    this.createNewThread(workWrapper);
                    return;
                }
                if (this.handOffToExistingThread(workWrapper, timeout)) {
                    return;
                }
                if (this.runWorkIfPoolNotFull(workWrapper)) {
                    return;
                }
            }
            catch (Exception e) {
                this.fail(new WorkRejectedException((Throwable)e), workWrapper);
            }
        }
        this.failQueueIsFull(poolSize, workWrapper);
    }

    boolean runWorkIfPoolNotFull(WorkWrapper workWrapper) {
        if (this.getAdjustedPoolSize() >= this.maximumPoolSize_) {
            return false;
        }
        this.createNewThread(workWrapper);
        return true;
    }

    private void createNewThread(WorkWrapper workWrapper) {
        this.addThread((Runnable)((Object)workWrapper));
        workWrapper.setThreadAllocated(true);
    }

    private boolean handOffToExistingThread(WorkWrapper workWrapper, long timeout) throws InterruptedException {
        if (timeout == 0L && this.getWorkerThreadsWaitingForTask() <= this.getQueueSize()) {
            return false;
        }
        return this.handOff_.offer(workWrapper, 0L);
    }

    private int getAdjustedPoolSize() {
        return this.poolSize_ + this.m_reservedThreadCount;
    }

    private void failShuttingDown(WorkWrapper wrapper) throws WorkRejectedException {
        this.fail(new WorkRejectedException("Request failed because shutdown has been initiated"), wrapper);
    }

    private void failQueueIsFull(int poolSize, WorkWrapper wrapper) throws WorkRejectedException {
        if (ApplicationServer.DMS_GATE) {
            this.m_queueFullEvent.occurred();
        }
        this.fail(new WorkRejectedException("Queue is full and all threads are busy; poolSize: " + poolSize), wrapper);
    }

    private void fail(WorkRejectedException exception, WorkWrapper wrapper) throws WorkRejectedException {
        exception.setErrorCode("-1");
        wrapper.fireWorkRejected((WorkException)exception);
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getWorkerThreadsWaitingForTask() {
        Object object = this.m_workerThreadCountLock;
        synchronized (object) {
            return this.m_workerThreadsWaitingForTask;
        }
    }

    synchronized void reserveThread() throws UnavailableException {
        if (this.getAdjustedPoolSize() < this.maximumPoolSize_) {
            ++this.m_reservedThreadCount;
        } else {
            throw new UnavailableException("Thread pool resources are all allocated, can not create Timer");
        }
    }

    synchronized void releaseThread() {
        --this.m_reservedThreadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable getTask() throws InterruptedException {
        this.incrementWorkerThreadsWaitingForTask();
        try {
            Runnable runnable = super.getTask();
            return runnable;
        }
        finally {
            this.decrementWorkerThreadsWaitingForTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementWorkerThreadsWaitingForTask() {
        Object object = this.m_workerThreadCountLock;
        synchronized (object) {
            ++this.m_workerThreadsWaitingForTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementWorkerThreadsWaitingForTask() {
        Object object = this.m_workerThreadCountLock;
        synchronized (object) {
            --this.m_workerThreadsWaitingForTask;
        }
    }

    public void shutdownNow() {
        if (this.m_queueUsed) {
            ((BoundedTimeoutQueue)this.handOff_).destroy();
        }
        super.shutdownNow();
    }

    public void setMinimumPoolSize(int min) {
        if (min < 1) {
            min = 1;
        }
        super.setMinimumPoolSize(min);
    }

    public int getQueueSize() {
        int size = 0;
        if (this.m_queueUsed) {
            size = ((BoundedTimeoutQueue)this.handOff_).size();
        }
        return size;
    }

    public int getQueueCapacity() {
        int capacity = 0;
        if (this.m_queueUsed) {
            capacity = ((BoundedTimeoutQueue)this.handOff_).capacity();
        }
        return capacity;
    }

    public void execute(Runnable command) throws InterruptedException {
        throw new UnsupportedOperationException("execute is not currently supported");
    }

    public synchronized int getReservedThreadCount() {
        return this.m_reservedThreadCount;
    }

    public void refresh() {
        if (this.handOff_ != null && this.m_queueUsed) {
            this.m_queueSizeState.update(((BoundedTimeoutQueue)this.handOff_).size());
        }
        this.m_totalThreadCountState.update(this.getPoolSize());
        this.m_idleThreadCountState.update(this.getWorkerThreadsWaitingForTask());
    }

    private void setupDms(int minPoolSize, int maxPoolSize, int queueSize, long keepAlive) {
        if (!ApplicationServer.DMS_GATE) {
            return;
        }
        NounIntf wmNoun = WorkManagerImpl.getNoun();
        if (wmNoun == null) {
            return;
        }
        ApplicationServer.stateFactory().create(wmNoun, "minPoolSize", "threads", "minimum number of threads in the pool", minPoolSize);
        ApplicationServer.stateFactory().create(wmNoun, "maxPoolSize", "threads", "maximum number of threads in the pool", maxPoolSize);
        ApplicationServer.stateFactory().create(wmNoun, "maxQueueSize", "work requests", "maximum queue size", queueSize);
        ApplicationServer.stateFactory().create(wmNoun, "keepAlive", "milliseconds", "Time before idle threads are removed from available pool", keepAlive);
        this.m_queueSizeState = ApplicationServer.stateFactory().create(wmNoun, "queueSize", "work requests", "current queue size", 0);
        this.m_totalThreadCountState = ApplicationServer.stateFactory().create(wmNoun, "totalThreadCount", "threads", "total number of threads in the pool", this.getPoolSize());
        this.m_idleThreadCountState = ApplicationServer.stateFactory().create(wmNoun, "idleThreadCount", "threads", "number of idle threads in the pool", this.getWorkerThreadsWaitingForTask());
        this.m_queueFullEvent = ApplicationServer.eventFactory().create(wmNoun, "queueFullEvent", "number of work submission failures due to full queue");
        this.m_queueSizeState.setRefresh((Refresh)this);
        this.m_totalThreadCountState.setRefresh((Refresh)this);
        this.m_idleThreadCountState.setRefresh((Refresh)this);
    }

    public synchronized String[] getExecutingThreadNames() {
        String[] th = new String[this.threads_.size()];
        int i = 0;
        Iterator it = this.threads_.entrySet().iterator();
        while (it.hasNext()) {
            th[i++] = it.next().toString();
        }
        return th;
    }

    public synchronized Set getConnectedUsers() {
        HashSet<UserInfo> users = new HashSet<UserInfo>();
        boolean i = false;
        Iterator it = this.threads_.entrySet().iterator();
        while (it.hasNext()) {
            ThreadState ts;
            Map.Entry t = it.next();
            Object thr = t.getValue();
            if (thr == null || !(thr instanceof ApplicationServerThread) || (ts = ((ApplicationServerThread)thr).state) == null || ts.getUser() == null) continue;
            String userName = ts.getUser().getName();
            String appName = null;
            try {
                if (ts.getContextContainer() != null && ts.getContextContainer().getApplication() != null) {
                    appName = ts.getContextContainer().getApplication().getName();
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
            users.add(new UserInfo(userName, appName));
        }
        return users;
    }

    public synchronized Map getApplicationsInUse() {
        HashMap<String, HashSet<UserInfo>> users = new HashMap<String, HashSet<UserInfo>>();
        boolean i = false;
        Iterator it = this.threads_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry t = it.next();
            Object thr = t.getValue();
            if (thr == null || !(thr instanceof ApplicationServerThread)) continue;
            ThreadState ts = ((ApplicationServerThread)thr).state;
            String userName = null;
            String appName = null;
            try {
                if (ts.getContextContainer() != null && ts.getContextContainer().getApplication() != null) {
                    appName = ts.getContextContainer().getApplication().getName();
                }
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (ts != null && ts.getUser() != null) {
                userName = ts.getUser().getName();
            }
            if (appName == null) continue;
            HashSet<UserInfo> s = (HashSet<UserInfo>)users.get(appName);
            if (s == null) {
                s = new HashSet<UserInfo>();
            }
            s.add(new UserInfo(userName, appName));
            users.put(appName, s);
        }
        return users;
    }
}

