/*
 * Decompiled with CFR 0.152.
 */
package oracle.hooks;

import java.lang.reflect.Array;
import java.util.ArrayList;
import oracle.hooks.Hook;
import oracle.hooks.TrampolineGenerator;

public abstract class Interrupt {
    protected Hook[] hooks;
    private ArrayList m_internalHooks = new ArrayList();
    private Class m_hookPrototype;
    private String m_interruptName;
    private static int genSymIndex = 0;
    static /* synthetic */ Class class$oracle$hooks$Hook$Read0;
    static /* synthetic */ Class class$oracle$hooks$Hook$Read1;
    static /* synthetic */ Class class$oracle$hooks$Hook$Read2;
    static /* synthetic */ Class class$oracle$hooks$Hook$Read3;
    static /* synthetic */ Class class$oracle$hooks$Hook$Edit1;
    static /* synthetic */ Class class$oracle$hooks$Hook$Edit2;
    static /* synthetic */ Class class$oracle$hooks$Hook$Edit3;

    public Interrupt(Class hookPrototype) {
        if (!Hook.class.isAssignableFrom(hookPrototype)) {
            throw new IllegalArgumentException(hookPrototype + " is not a subclass of " + Hook.class);
        }
        this.m_hookPrototype = hookPrototype;
        this.hooks = (Hook[])Array.newInstance(this.m_hookPrototype, 0);
    }

    public void setName(String name) {
        if (this.m_interruptName != null) {
            throw new RuntimeException("Can not reset an interrupt's name;this interrupt is already named: " + this.m_interruptName);
        }
        if (name == null || name == "") {
            throw new RuntimeException("An interrupt's name may not be null or the empty string; received: '" + name + "'");
        }
        this.m_interruptName = name;
    }

    public synchronized void addHook(String name, Hook h) {
        this.appendHook(name, h);
    }

    public synchronized void prependHook(String name, Hook h) {
        this.addHook(name, h, true);
    }

    public synchronized void appendHook(String name, Hook h) {
        this.addHook(name, h, false);
    }

    public synchronized void removeHook(Hook h) throws IllegalArgumentException {
        Hook delegate = this.findHookDelegate(h);
        if (null == delegate) {
            throw new IllegalArgumentException("Hook does not exist to be removed");
        }
        this.m_internalHooks.remove(delegate);
        this.updateHookArray();
    }

    public boolean isHookRegistered(Hook h) {
        return null != this.findHookDelegate(h);
    }

    private void addHook(String name, Hook h, boolean prepend) {
        if (this.m_interruptName == null) {
            throw new IllegalStateException("Interrupt name must be set using setName() before use.");
        }
        if (this.isHookRegistered(h)) {
            throw new IllegalStateException("Hook is already registered; hook: " + h);
        }
        this.validateHookType(h);
        this.validateHookName(name);
        Hook delegate = this.makeHookDelegate(name, h);
        if (prepend) {
            this.m_internalHooks.add(0, delegate);
        } else {
            this.m_internalHooks.add(delegate);
        }
        this.updateHookArray();
    }

    private Hook findHookDelegate(Hook h) {
        Hook cur = null;
        try {
            Hook[] hooksCopy = this.hooks;
            for (int i = 0; i < hooksCopy.length; ++i) {
                cur = hooksCopy[i];
                Hook wrappedHook = (Hook)cur.getClass().getField("target").get(cur);
                if (wrappedHook != h) continue;
                return cur;
            }
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException("Unexpected exception scanning hook delegate: " + cur).initCause(e);
        }
        return null;
    }

    private Hook makeHookDelegate(String name, Hook orig) {
        String delegateName = "oracle.hooks." + this.m_interruptName + "$" + name + "$" + genSymIndex++;
        int hookIfaceIndex = -1;
        Class<?>[] ifaces = orig.getClass().getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            if (!(class$oracle$hooks$Hook == null ? Interrupt.class$("oracle.hooks.Hook") : class$oracle$hooks$Hook).isAssignableFrom(ifaces[i])) continue;
            if (hookIfaceIndex == -1) {
                hookIfaceIndex = i;
                continue;
            }
            throw new IllegalArgumentException("Hook classes may not implement two Hook.* interfaces; the given hook implements: " + ifaces[hookIfaceIndex] + " and: " + ifaces[i]);
        }
        try {
            return TrampolineGenerator.create(delegateName, ifaces[hookIfaceIndex].getName(), orig);
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException("Unable to generate hook delegate class; delegateClass: " + delegateName).initCause(e);
        }
    }

    private void updateHookArray() {
        this.hooks = (Hook[])this.m_internalHooks.toArray((Object[])Array.newInstance(this.m_hookPrototype, this.m_internalHooks.size()));
    }

    private void validateHookType(Hook newRegistrant) {
        if (!this.m_hookPrototype.isAssignableFrom(newRegistrant.getClass())) {
            throw new IllegalArgumentException(newRegistrant.getClass() + " is not equal or a subclass of " + this.m_hookPrototype);
        }
    }

    private void validateHookName(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Invalid hook name: '" + name + "'; hooks must not be null or empty.");
        }
        char[] cs = name.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (Character.isJavaIdentifierPart(cs[i])) continue;
            throw new IllegalArgumentException("Invalid hook name: '" + name + "; contains illegal characters for a java identifier.");
        }
    }

    public static class Editable3
    extends Interrupt {
        public Editable3() {
            super(class$oracle$hooks$Hook$Edit3 == null ? (class$oracle$hooks$Hook$Edit3 = Interrupt.class$("oracle.hooks.Hook$Edit3")) : class$oracle$hooks$Hook$Edit3);
        }

        public Object fire(Object t1, Object t2, Object t3) {
            Hook[] hs = this.hooks;
            for (int i = 0; i < hs.length; ++i) {
                t1 = ((Hook.Edit3)hs[i]).execute(t1, t2, t3);
            }
            return t1;
        }
    }

    public static class Editable2
    extends Interrupt {
        public Editable2() {
            super(class$oracle$hooks$Hook$Edit2 == null ? (class$oracle$hooks$Hook$Edit2 = Interrupt.class$("oracle.hooks.Hook$Edit2")) : class$oracle$hooks$Hook$Edit2);
        }

        public Object fire(Object t1, Object t2) {
            Hook[] hs = this.hooks;
            for (int i = 0; i < hs.length; ++i) {
                t1 = ((Hook.Edit2)hs[i]).execute(t1, t2);
            }
            return t1;
        }
    }

    public static class Editable1
    extends Interrupt {
        public Editable1() {
            super(class$oracle$hooks$Hook$Edit1 == null ? (class$oracle$hooks$Hook$Edit1 = Interrupt.class$("oracle.hooks.Hook$Edit1")) : class$oracle$hooks$Hook$Edit1);
        }

        public Object fire(Object t1) {
            Hook[] hs = this.hooks;
            for (int i = 0; i < hs.length; ++i) {
                t1 = ((Hook.Edit1)hs[i]).execute(t1);
            }
            return t1;
        }
    }

    public static class Readable3
    extends Interrupt {
        public Readable3() {
            super(class$oracle$hooks$Hook$Read3 == null ? (class$oracle$hooks$Hook$Read3 = Interrupt.class$("oracle.hooks.Hook$Read3")) : class$oracle$hooks$Hook$Read3);
        }

        public void fire(Object t1, Object t2, Object t3) {
            Hook[] hs = this.hooks;
            for (int i = 0; i < hs.length; ++i) {
                ((Hook.Read3)hs[i]).execute(t1, t2, t3);
            }
        }
    }

    public static class Readable2
    extends Interrupt {
        public Readable2() {
            super(class$oracle$hooks$Hook$Read2 == null ? (class$oracle$hooks$Hook$Read2 = Interrupt.class$("oracle.hooks.Hook$Read2")) : class$oracle$hooks$Hook$Read2);
        }

        public void fire(Object t1, Object t2) {
            Hook[] hs = this.hooks;
            for (int i = 0; i < hs.length; ++i) {
                ((Hook.Read2)hs[i]).execute(t1, t2);
            }
        }
    }

    public static class Readable1
    extends Interrupt {
        public Readable1() {
            super(class$oracle$hooks$Hook$Read1 == null ? (class$oracle$hooks$Hook$Read1 = Interrupt.class$("oracle.hooks.Hook$Read1")) : class$oracle$hooks$Hook$Read1);
        }

        public void fire(Object t1) {
            Hook[] hs = this.hooks;
            for (int i = 0; i < hs.length; ++i) {
                ((Hook.Read1)hs[i]).execute(t1);
            }
        }
    }

    public static class Readable0
    extends Interrupt {
        public Readable0() {
            super(class$oracle$hooks$Hook$Read0 == null ? (class$oracle$hooks$Hook$Read0 = Interrupt.class$("oracle.hooks.Hook$Read0")) : class$oracle$hooks$Hook$Read0);
        }

        public void fire() {
            Hook[] hs = this.hooks;
            for (int i = 0; i < hs.length; ++i) {
                ((Hook.Read0)hs[i]).execute();
            }
        }
    }
}

