/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import com.evermind.server.RecoverableSinglePhaseResource;
import com.evermind.server.WrappedXAResource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.RMId;
import oracle.as.j2ee.transaction.tpc.SinglePhaseBranch;

public class RecoverableSinglePhaseBranch
extends SinglePhaseBranch {
    public static final int ACTION_RESOLVE_LOCAL_BRANCH = 6;
    private RecoverableSinglePhaseResource m_unwrappedResource;

    public RecoverableSinglePhaseBranch(GlobalTransaction transaction, XAResource xaResource, Xid xid, RMId rmid, int status) {
        super(transaction, xaResource, xid, status);
        this.setRMId(rmid);
    }

    public int act(int action) throws XAException {
        switch (action) {
            case 6: {
                return this.resolveLocalBranch();
            }
        }
        return super.act(action);
    }

    private int resolveLocalBranch() {
        this.unwrapResource();
        try {
            boolean committed = this.m_unwrappedResource.isCommitted(this.getXid());
            return committed ? 3 : 4;
        }
        catch (XAException e) {
            return 5;
        }
    }

    void commitSinglePhaseBranch() throws XAException {
        this.unwrapResource();
        this.logMsg("RLRC Commit1 in Prepare phase");
        try {
            this.m_unwrappedResource.enableWriteCommitRecord();
            this.commitSinglePhaseResource();
        }
        catch (Exception e) {
            this.handleCommitException(e);
        }
    }

    private void commitSinglePhaseResource() throws XAException {
        this.xaResource().commit(this.getXid(), true);
    }

    private void unwrapResource() {
        if (this.m_unwrappedResource != null) {
            return;
        }
        XAResource resource = this.xaResource();
        while (resource instanceof WrappedXAResource) {
            resource = ((WrappedXAResource)((Object)resource)).getWrappedResource();
        }
        this.m_unwrappedResource = (RecoverableSinglePhaseResource)((Object)resource);
    }

    void handleCommitException(Exception e) throws XAException {
        XAException xae = new XAException(-7);
        xae.initCause(e);
        throw xae;
    }

    boolean supportsRecovery() {
        return true;
    }

    public void setXaResource(XAResource resource) {
        this.m_unwrappedResource = null;
        super.setXaResource(resource);
    }
}

