/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import com.evermind.server.ApplicationServerTransactionManager;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.LogPresumption;
import oracle.as.j2ee.transaction.tpc.RecoverableSinglePhaseResourceReaperTask;
import oracle.as.j2ee.transaction.tpc.Store;

public class PresumedAbortStrategy
implements LogPresumption {
    private Store m_store;
    private boolean m_usingRLRC = false;

    public PresumedAbortStrategy(Store store) {
        this.m_store = store;
    }

    public void creationEvent(GlobalTransaction tx) throws Store.StoreException {
        this.m_store.noteResources(tx);
    }

    public void stateEvent(GlobalTransaction tx, int newState) throws Store.StoreException {
        if (this.m_usingRLRC) {
            return;
        }
        if (tx.is(6) && newState != 3) {
            this.m_store.noteTransaction(tx, newState);
        } else if (tx.is(9)) {
            this.m_store.noteState(tx, newState);
        } else if (!tx.is(3) && newState != 3) {
            this.m_store.noteState(tx, newState);
        }
    }

    public void forgetEvent(GlobalTransaction tx) throws Store.StoreException {
        if (this.m_usingRLRC) {
            RecoverableSinglePhaseResourceReaperTask recoverableSinglePhaseResourceReaperTask = ApplicationServerTransactionManager.getRecoverableSinglePhaseResourceReaperTask();
            if (recoverableSinglePhaseResourceReaperTask != null) {
                recoverableSinglePhaseResourceReaperTask.add(tx);
            }
        } else if (!tx.is(3)) {
            this.m_store.noteForget(tx);
        }
    }

    public Store getStore() {
        return this.m_store;
    }

    public void useRLRCOptimization() {
        this.m_usingRLRC = true;
    }
}

