/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.j2ee.transaction.tpc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.j2ee.transaction.TransactionMessages;

public class DatabaseStoreConnection {
    int m_numberOfTxs;
    private Connection m_connection;
    private boolean m_isWorkConducted;
    private long m_lastBatchExecuteTime = 0L;
    private String m_description = "";
    private PreparedStatement stmt1 = null;
    private PreparedStatement stmt2 = null;

    DatabaseStoreConnection(Connection connection, String description) {
        this.m_connection = connection;
        this.m_description = description;
        TransactionMessages.finer("Database store : " + description + " connection created");
    }

    PreparedStatement prepareStatement(String s) throws SQLException {
        if (this.stmt1 == null) {
            this.stmt1 = this.m_connection.prepareStatement(s);
            return this.stmt1;
        }
        this.stmt2 = this.m_connection.prepareStatement(s);
        return this.stmt2;
    }

    void executeBatches() throws SQLException {
        this.stmt1.executeBatch();
        if (this.stmt2 != null) {
            this.stmt2.executeBatch();
        }
        this.m_lastBatchExecuteTime = System.currentTimeMillis();
    }

    void close() throws SQLException {
        this.m_connection.close();
    }

    boolean isClosed() throws SQLException {
        return this.m_connection.isClosed();
    }

    void setWorkConducted(boolean workConducted) {
        this.m_isWorkConducted = workConducted;
        this.m_numberOfTxs = this.m_isWorkConducted ? ++this.m_numberOfTxs : 0;
    }

    boolean isWorkConducted() {
        return this.m_isWorkConducted;
    }

    long getLastBatchExecuteTime() {
        return this.m_lastBatchExecuteTime;
    }

    String getDescription() {
        return this.m_description;
    }
}

