/*
 * Decompiled with CFR 0.152.
 */
package opmn.jgroups.stack;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.ias.opmn.optic.OpmnConn;
import oracle.ias.opmn.optic.OpmnHostPort;
import oracle.ias.opmn.optic.OpmnProcess;
import oracle.ias.opmn.optic.OpmnQuery;
import oracle.ias.opmn.optic.OpticBadConnectException;
import oracle.ias.opmn.optic.OpticBadRequestException;
import oracle.ias.opmn.optic.OpticBadResponseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.stack.IpAddress;

public class OPMNGossipClient {
    private static final String JGPORTDESC = "jgroup";
    private static final String JGPROCTYPE = "OC4J";
    private static final String JGPROCSTATUS = "Alive";
    protected static Log log = LogFactory.getLog((Class)OPMNGossipClient.class);
    private static OpmnQuery opmnQueryObj;
    private static String opmnQueryStr;

    public static void getMembers(Map clusterGrpMbrsMap) {
        OPMNGossipClient._getMembers(clusterGrpMbrsMap);
    }

    static void _getMembers(Map clusterGrpMbrsMap) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"OPMNGossipClient: Looking for peers from OPMN. ");
        }
        List opmnProcList = null;
        try {
            if (opmnQueryObj == null) {
                log.error((Object)"OPMNGossipClient: Cannot query OPMN via OPTIC because oracle.home system property is not set");
                return;
            }
            log.debug((Object)("OPMNGOSSIPCLIENT: Before opmnQueryObj.getProc at: " + System.currentTimeMillis()));
            opmnProcList = opmnQueryObj.getProc(opmnQueryStr);
            log.debug((Object)("OPMNGOSSIPCLIENT: After opmnQueryObj.getProc at: " + System.currentTimeMillis()));
            for (int i = 0; i < opmnProcList.size(); ++i) {
                OpmnProcess p = (OpmnProcess)opmnProcList.get(i);
                if (!p.getType().equals(JGPROCTYPE) || !p.getStatus().equals(JGPROCSTATUS)) continue;
                List procConnList = p.getConnList();
                for (int j = 0; j < procConnList.size(); ++j) {
                    OpmnConn procConn = (OpmnConn)procConnList.get(j);
                    String connDesc = procConn.getDesc();
                    String connHost = procConn.getHost();
                    String connPort = procConn.getPort();
                    String connType = procConn.getType();
                    if (connDesc == null || !connDesc.equals(JGPORTDESC)) continue;
                    if (connType == null) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)"OPMNGossipClient: A JGroup port does not have a type in the DMS output! ");
                        continue;
                    }
                    if (connHost != null && connPort != null) {
                        InetAddress connHostAddr = InetAddress.getByName(connHost);
                        int connPortVal = Integer.decode(connPort);
                        IpAddress peerAddress = new IpAddress(connHostAddr, connPortVal);
                        Vector<IpAddress> groupList = (Vector<IpAddress>)clusterGrpMbrsMap.get(connType);
                        if (groupList == null) {
                            groupList = new Vector<IpAddress>();
                        }
                        groupList.addElement(peerAddress);
                        clusterGrpMbrsMap.put(connType, groupList);
                        continue;
                    }
                    log.error((Object)"OPMNGossipClient: The OpmnProcess object did not have host and port information");
                }
            }
        }
        catch (OpticBadResponseException e) {
            log.error((Object)("OPMNGossipClient: Got an OpticBadResponseException.\n" + e.getMessage() + "\n" + e.getStackTrace()));
        }
        catch (OpticBadConnectException e) {
            log.error((Object)("OPMNGossipClient: Got an OpticBadConnectException.\n" + e.getMessage() + "\n" + e.getStackTrace()));
        }
        catch (OpticBadRequestException e) {
            log.error((Object)("OPMNGossipClient: Got an OpticBadRequestException.\n" + e.getMessage() + "\n" + e.getStackTrace()));
        }
        catch (UnknownHostException uHE) {
            log.error((Object)("OPMNGossipClient: Got an UnknownHostException.\n " + uHE.getMessage() + "\n" + uHE.getStackTrace()));
        }
    }

    static {
        String oraHome = System.getProperty("oracle.home");
        if (oraHome == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"OPMNGossipClient: Cannot query OPMN because oracle.home system property is not set.");
            }
        } else {
            opmnQueryObj = new OpmnQuery(null, 0, OpmnHostPort.LOCAL, oraHome);
            opmnQueryStr = OpmnQuery.buildDmsQuery((String)"cluster", null, null);
        }
    }
}

