/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Tie;
import javax.rmi.PortableRemoteObject;

public final class Utility {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$Utility == null ? (class$com$sun$enterprise$util$Utility = Utility.class$("com.sun.enterprise.util.Utility")) : class$com$sun$enterprise$util$Utility);
    private static String CONFIG_DIR = "config";
    public static final String J2EE_DEFAULT_CONFIGURATION_FILE = "default.properties";
    static /* synthetic */ Class class$com$sun$enterprise$util$Utility;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;

    public static void checkJVMVersion() {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion == null || !javaVersion.equals("1.3")) {
            String msg = localStrings.getLocalString("utility.jdk.version", "Warning: This J2EE SDK release is designed to run on J2SE 1.3");
            System.err.println(msg);
        }
    }

    public static Properties getPropertiesFromFile(String file) throws IOException {
        File j2eedConfigFile = new File(FileUtil.getAbsolutePath(CONFIG_DIR + File.separator + file));
        FileInputStream fis = new FileInputStream(j2eedConfigFile);
        Properties config = new Properties();
        config.load(fis);
        fis.close();
        return config;
    }

    public static String getLocalHost() {
        String hostname = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            hostname = ia.getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
        return hostname;
    }

    public static String getLocalAddress() {
        String address = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            address = ia.getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
        return address;
    }

    public static void bindObject(String publishedName, Remote remote) throws RemoteException, NamingException {
        Tie servantsTie = ORBManager.exportObject((Remote)remote);
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        namingManager.publishObject(publishedName, (Object)servantsTie, true);
    }

    public static Remote lookupObject(String publishedName, Class anInterface) throws NamingException {
        InitialContext ic = new InitialContext();
        Object objRef = ic.lookup(publishedName);
        return (Remote)PortableRemoteObject.narrow((Object)objRef, (Class)anInterface);
    }

    public static int bytesToInt(byte[] array, int offset) {
        int b1 = array[offset++] << 24 & 0xFF000000;
        int b2 = array[offset++] << 16 & 0xFF0000;
        int b3 = array[offset++] << 8 & 0xFF00;
        int b4 = array[offset++] << 0 & 0xFF;
        return b1 | b2 | b3 | b4;
    }

    public static void intToBytes(int value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 24 & 0xFF);
        array[offset++] = (byte)(value >>> 16 & 0xFF);
        array[offset++] = (byte)(value >>> 8 & 0xFF);
        array[offset++] = (byte)(value >>> 0 & 0xFF);
    }

    public static long bytesToLong(byte[] array, int offset) {
        long l1 = (long)Utility.bytesToInt(array, offset) << 32;
        long l2 = (long)Utility.bytesToInt(array, offset + 4) & 0xFFFFFFFFL;
        return l1 | l2;
    }

    public static void longToBytes(long value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 56 & 0xFFL);
        array[offset++] = (byte)(value >>> 48 & 0xFFL);
        array[offset++] = (byte)(value >>> 40 & 0xFFL);
        array[offset++] = (byte)(value >>> 32 & 0xFFL);
        array[offset++] = (byte)(value >>> 24 & 0xFFL);
        array[offset++] = (byte)(value >>> 16 & 0xFFL);
        array[offset++] = (byte)(value >>> 8 & 0xFFL);
        array[offset++] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void invokeApplicationMain(Class mainClass, String[] args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        String err = localStrings.getLocalString("utility.no.main", "", new Object[]{mainClass});
        Method mainMethod = null;
        try {
            mainMethod = mainClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Utility.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (NoSuchMethodException msme) {
            System.err.println(err);
            throw new ClassNotFoundException(err);
        }
        int modifiers = mainMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            err = localStrings.getLocalString("utility.main.notpublicorstatic", "The main method is either not public or not static");
            System.err.println(err);
            throw new ClassNotFoundException(err);
        }
        if (!mainMethod.getReturnType().equals(Void.TYPE)) {
            err = localStrings.getLocalString("utility.main.notvoid", "The main method's return type is not void ");
            System.err.println(err);
            throw new ClassNotFoundException(err);
        }
        Object[] params = new Object[]{args};
        mainMethod.invoke(null, params);
    }

    public static void invokeSetMethod(Object obj, String prop, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> cl = obj.getClass();
        String setMeth = "set" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
        try {
            Class[] cldef = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Utility.class$("java.lang.String")) : class$java$lang$String};
            Method meth = cl.getMethod(setMeth, cldef);
            Object[] params = new Object[]{value};
            meth.invoke(obj, params);
            return;
        }
        catch (NoSuchMethodException ex) {
            try {
                Class[] cldef = new Class[]{Integer.TYPE};
                Method meth = cl.getMethod(setMeth, cldef);
                Object[] params = new Object[]{Integer.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
            catch (NoSuchMethodException nsmex) {
                Class[] cldef = new Class[]{Boolean.TYPE};
                Method meth = cl.getMethod(setMeth, cldef);
                Object[] params = new Object[]{Boolean.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
        }
    }

    public static short intToShort(int value) {
        if (value > Short.MAX_VALUE) {
            return (short)(value - 65536);
        }
        return (short)value;
    }

    public static int shortToInt(short value) {
        if (value < 0) {
            return value + 65536;
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

