/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EJBRelationship;
import com.evermind.server.ejb.deployment.EJBRelationshipRole;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalEntityDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.security.acl.Role;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import oracle.oc4j.corba.util.LocalStringManagerImpl;

public class EjbBundleDescriptor
extends BundleDescriptor {
    public static final String EJB_2_x_VERSION = "EJB 2.x";
    public static final String EJB_1_x_VERSION = "EJB 1.x";
    private int uniqueId;
    private Set ejbs = new HashSet();
    private Set relationships = new HashSet();
    private Set remoteEntities = new HashSet();
    private String relationshipsDescription;
    private String ejbClientJarUri;
    private String ejbVersion = "EJB 2.x";
    private String finderTableBaseName = null;
    private ResourceReferenceDescriptor cmpResourceReference;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbBundleDescriptor.class);
    private EJBPackage ejbPackage;
    private Hashtable ejbPackageRoles = null;

    public boolean isEJB20() {
        return this.ejbVersion.equals(EJB_2_x_VERSION);
    }

    public boolean isEJB11() {
        return this.ejbVersion.equals(EJB_1_x_VERSION);
    }

    public void setEJBVersion(String version) {
        if (!this.ejbVersion.equals(EJB_1_x_VERSION) && !this.ejbVersion.equals(EJB_2_x_VERSION)) {
            throw new IllegalArgumentException("Illegal ejb version : " + version);
        }
        this.ejbVersion = version;
    }

    public String getEjbClientJarUri() {
        if (this.ejbClientJarUri == null) {
            this.ejbClientJarUri = "";
        }
        return this.ejbClientJarUri;
    }

    public void setEjbClientJarUri(String ejbClientJarUri) {
        this.ejbClientJarUri = ejbClientJarUri;
        this.changed();
    }

    public void addEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        super.addBundleDescriptor(ejbBundleDescriptor);
        Iterator ejbs = ejbBundleDescriptor.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            ejbDescriptor.setEjbBundleDescriptor(this);
            this.getEjbs().add(ejbDescriptor);
        }
        this.changed();
    }

    public void classesChanged() {
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            ejbDescriptor.classesChanged();
        }
    }

    protected Archivist getDefaultArchivist() {
        return new EjbBundleArchivist("", this);
    }

    public Collection getNamedDescriptors() {
        Vector<EjbDescriptor> namedDescriptors = new Vector<EjbDescriptor>();
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            namedDescriptors.add(ejbDescriptor);
            namedDescriptors.addAll(super.getNamedDescriptorsFrom(ejbDescriptor));
        }
        return namedDescriptors;
    }

    public Vector getNamedReferencePairs() {
        Vector<NamedReferencePair> pairs = new Vector<NamedReferencePair>();
        Iterator ejbs = this.getEjbs().iterator();
        while (ejbs.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
            pairs.add(NamedReferencePair.createEjbPair(ejbDescriptor, ejbDescriptor));
            pairs.addAll(super.getNamedReferencePairsFrom(ejbDescriptor));
        }
        return pairs;
    }

    public Set getResourceReferenceDescriptors() {
        HashSet resourceReferences = new HashSet();
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            resourceReferences.addAll(ejbDescriptor.getResourceReferenceDescriptors());
        }
        return resourceReferences;
    }

    public boolean hasEjbReferences() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getEjbReferenceDescriptors().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set getEjbs() {
        if (this.ejbs == null) {
            this.ejbs = new HashSet();
        }
        return this.ejbs;
    }

    public boolean hasEjbByName(String name) {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public EjbDescriptor getEjbByName(String name) {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            Descriptor next = (Descriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return (EjbDescriptor)next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionbeanbundle", "Referencing error: this bundle has no bean of name: {0}", new Object[]{name}));
    }

    public void addEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(ejbDescriptor);
        super.changed();
    }

    public void removeEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(ejbDescriptor);
        super.changed();
    }

    void replaceEjb(EjbDescriptor oldEjbDescriptor, EjbDescriptor newEjbDescriptor) {
        oldEjbDescriptor.setEjbBundleDescriptor(null);
        this.getEjbs().remove(oldEjbDescriptor);
        newEjbDescriptor.setEjbBundleDescriptor(this);
        this.getEjbs().add(newEjbDescriptor);
    }

    public boolean areResourceReferencesValid() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            Iterator roleRefs = ejbDescriptor.getRoleReferences().iterator();
            while (roleRefs.hasNext()) {
                RoleReference roleReference = (RoleReference)roleRefs.next();
                Role referredRole = roleReference.getRole();
                if (referredRole.getName().equals("") || super.getRoles().contains(referredRole)) continue;
                System.out.println(localStrings.getLocalString("enterprise.deployment.badrolereference", "Warning: Bad role reference to {0}", new Object[]{referredRole}));
                System.out.println(this.getRoles());
                return false;
            }
        }
        return true;
    }

    public void removeRole(Role role) {
        if (super.getRoles().contains(role)) {
            Iterator itr = this.getEjbs().iterator();
            while (itr.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
                ejbDescriptor.removeRole(role);
            }
            super.removeRole(role);
        }
    }

    public boolean hasPermissionedRoles() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getPermissionedMethodsByPermission().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasContainerTransactions() {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            if (nextEjbDescriptor.getMethodContainerTransactions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAssemblyInformation() {
        return !this.getRoles().isEmpty() || this.hasPermissionedRoles() || this.hasContainerTransactions();
    }

    public void addRelationship(RelationshipDescriptor relDesc) {
        this.relationships.add(relDesc);
        super.changed();
    }

    public void removeRelationship(RelationshipDescriptor relDesc) {
        this.relationships.remove(relDesc);
        super.changed();
    }

    public String getRelationshipsDescription() {
        if (this.relationshipsDescription == null) {
            this.relationshipsDescription = "";
        }
        return this.relationshipsDescription;
    }

    public void setRelationshipsDescription(String relationshipsDescription) {
        this.relationshipsDescription = relationshipsDescription;
    }

    public Set getRelationships() {
        return this.relationships;
    }

    public boolean hasRelationships() {
        return this.relationships.size() > 0;
    }

    public boolean hasRelationship(RelationshipDescriptor rd) {
        return this.relationships.contains(rd);
    }

    public void addRemoteEntity(EjbExternalEntityDescriptor dd) {
        this.remoteEntities.add(dd);
        dd.setEjbBundleDescriptor(this);
    }

    public Set getRemoteEntities() {
        return this.remoteEntities;
    }

    public ResourceReferenceDescriptor getCMPResourceReference() {
        return this.cmpResourceReference;
    }

    public void setCMPResourceReference(ResourceReferenceDescriptor resourceReference) {
        this.cmpResourceReference = resourceReference;
        this.changed();
    }

    public Descriptor getDescriptorByName(String name) {
        try {
            EjbDescriptor d = this.getEjbByName(name);
            return d;
        }
        catch (IllegalArgumentException iae) {
            Iterator itr = this.remoteEntities.iterator();
            while (itr.hasNext()) {
                Descriptor next = (Descriptor)itr.next();
                if (!next.getName().equals(name)) continue;
                return next;
            }
            return null;
        }
    }

    public EjbExternalEntityDescriptor getRemoteEntityByName(String name) {
        Iterator itr = this.remoteEntities.iterator();
        while (itr.hasNext()) {
            EjbExternalEntityDescriptor next = (EjbExternalEntityDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public boolean hasRemoteEntityByName(String name) {
        return this.getRemoteEntityByName(name) != null;
    }

    public boolean hasFinderTableBaseName() {
        return this.finderTableBaseName != null;
    }

    public String getFinderTableBaseName() {
        if (!this.hasFinderTableBaseName()) {
            throw new IllegalStateException("ejb-jar doesn't have a finder table base name");
        }
        return this.finderTableBaseName;
    }

    public void setFinderTableBaseName(String baseName) {
        this.finderTableBaseName = baseName;
    }

    public String getName() {
        if ("".equals(super.getName())) {
            super.setName("Ejb1");
        }
        return super.getName();
    }

    private void doMethodDescriptorConversions() throws Exception {
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)itr.next();
            ejbDescriptor.doMethodDescriptorConversions();
        }
    }

    public void setUniqueId(int id) {
        int i;
        this.uniqueId = id;
        EjbDescriptor[] descs = this.ejbs.toArray(new EjbDescriptor[this.ejbs.size()]);
        for (i = descs.length - 1; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (descs[j].getName().compareTo(descs[j + 1].getName()) <= 0) continue;
                EjbDescriptor tmp = descs[j + 1];
                descs[j + 1] = descs[j];
                descs[j] = tmp;
            }
        }
        for (i = 0; i < descs.length; ++i) {
            long beanId = this.uniqueId;
            beanId <<= 32;
            descs[i].setUniqueId(beanId |= (long)i);
        }
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public static int getIdFromEjbId(long ejbId) {
        long id = ejbId >> 32;
        return (int)id;
    }

    public EJBPackage getEJBPackage() {
        return this.ejbPackage;
    }

    public String getApplicationName() {
        return this.ejbPackage.getApplication().getName();
    }

    public void setEJBPackage(EJBPackage ejbPackage) {
        this.ejbPackage = ejbPackage;
    }

    private EJBRelationshipRole getEJBRelationshipRole(String beanName, String cmrName) {
        if (this.ejbPackageRoles == null) {
            this.ejbPackageRoles = new Hashtable();
            Iterator i = this.ejbPackage.getEJBRelationships().iterator();
            while (i.hasNext()) {
                EJBRelationship relationship = (EJBRelationship)i.next();
                this.addRoleInfo(relationship.getFirstRole());
                this.addRoleInfo(relationship.getSecondRole());
            }
        }
        EJBRelationshipRole role = (EJBRelationshipRole)this.ejbPackageRoles.get(beanName + ":" + cmrName);
        return role;
    }

    private void addRoleInfo(EJBRelationshipRole role) {
        String owner = role.getRoleSource().getName();
        String cmr = role.getRelation().getName();
        this.ejbPackageRoles.put(owner + ":" + cmr, role);
    }

    public Boolean getAssociateUsingThirdTableFlag(String beanName, String cmrName) {
        EJBRelationshipRole role = this.getEJBRelationshipRole(beanName, cmrName);
        return role != null && role.getRelation() != null && role.getRelation().getResolved() != null && role.getRelation().getResolved().getORMapping() != null ? (role.getRelation().getResolved().getORMapping().associateUsingThirdTable ? Boolean.TRUE : Boolean.FALSE) : null;
    }

    public String toString() {
        String s = "EjbBundleDescriptor";
        s = s + "\n archivist " + super.getArchivist();
        s = s + "\n roles " + this.getRoles();
        s = s + "\nclient JAR " + this.getEjbClientJarUri();
        Iterator itr = this.getEjbs().iterator();
        while (itr.hasNext()) {
            s = s + "\n------------\n";
            Object ejb = itr.next();
            s = s + ejb;
            s = s + "\n------------";
        }
        return s;
    }
}

