/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.Operator;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.Visitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Vector;

public abstract class OperatorBase
implements Operator {
    private static Vector numericTypesV_;
    private static HashSet numericTypesH_;
    private static HashSet booleanTypes_;
    protected static final String CHAR_TYPE_NAME;
    protected static final String CHAR_PRIMITIVE_TYPE_NAME;
    protected static final String STRING_TYPE_NAME;
    protected static final String BOOLEAN_OBJECT_TYPE_NAME;
    protected static final String BOOLEAN_PRIMITIVE_TYPE_NAME;
    protected static final String INTEGER_OBJECT_TYPE_NAME;
    protected static final String INTEGER_PRIMITIVE_TYPE_NAME;
    protected static final String LONG_OBJECT_TYPE_NAME;
    protected static final String LONG_PRIMITIVE_TYPE_NAME;
    protected static final String FLOAT_OBJECT_TYPE_NAME;
    protected static final String FLOAT_PRIMITIVE_TYPE_NAME;
    protected static final String DOUBLE_OBJECT_TYPE_NAME;
    protected static final String DOUBLE_PRIMITIVE_TYPE_NAME;
    protected static final String BIGDECIMAL_OBJECT_TYPE_NAME;
    protected static final String BIGINTEGER_OBJECT_TYPE_NAME;
    private static HashSet dateTypes_;

    protected static boolean hasSmallerNumericType(Expression expr, String arithmeticType) {
        String exprType = expr.getJavaType();
        return numericTypesV_.indexOf(exprType) < numericTypesV_.indexOf(arithmeticType);
    }

    protected static boolean hasNumericType(Expression expr) {
        return numericTypesH_.contains(expr.getJavaType());
    }

    protected static boolean hasDateType(Expression expr) {
        return dateTypes_.contains(expr.getJavaType());
    }

    protected static boolean hasBooleanType(Expression expr) {
        return booleanTypes_.contains(expr.getJavaType());
    }

    protected static boolean hasCharType(Expression expr) {
        return expr.getJavaType().equals(CHAR_TYPE_NAME) || expr.getJavaType().equals(CHAR_PRIMITIVE_TYPE_NAME);
    }

    protected static boolean hasStringType(Expression expr) {
        return expr.getJavaType().equals(STRING_TYPE_NAME);
    }

    protected static boolean hasIntegerType(Expression expr) {
        return expr.getJavaType().equals(INTEGER_OBJECT_TYPE_NAME) || expr.getJavaType().equals(INTEGER_PRIMITIVE_TYPE_NAME);
    }

    protected static boolean hasLongType(Expression expr) {
        return expr.getJavaType().equals(LONG_OBJECT_TYPE_NAME) || expr.getJavaType().equals(LONG_PRIMITIVE_TYPE_NAME);
    }

    protected static boolean hasFloatType(Expression expr) {
        return expr.getJavaType().equals(FLOAT_OBJECT_TYPE_NAME) || expr.getJavaType().equals(FLOAT_PRIMITIVE_TYPE_NAME);
    }

    protected static boolean hasDoubleType(Expression expr) {
        return expr.getJavaType().equals(DOUBLE_OBJECT_TYPE_NAME) || expr.getJavaType().equals(DOUBLE_PRIMITIVE_TYPE_NAME);
    }

    public void accept(Visitor visitor) {
        visitor.visitOperator(this);
    }

    public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpr) {
        visitor.visitOperatorExpression(operatorExpr);
    }

    public ListIterator getChildren(int traversalType) {
        return new Vector().listIterator();
    }

    public boolean isUnary() {
        return false;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isNary() {
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof OperatorBase) {
            OperatorBase otherOperator = (OperatorBase)other;
            equal = this == otherOperator;
        }
        return equal;
    }

    static {
        CHAR_TYPE_NAME = Character.class.getName();
        CHAR_PRIMITIVE_TYPE_NAME = Character.TYPE.getName();
        STRING_TYPE_NAME = String.class.getName();
        BOOLEAN_OBJECT_TYPE_NAME = Boolean.class.getName();
        BOOLEAN_PRIMITIVE_TYPE_NAME = Boolean.TYPE.getName();
        INTEGER_OBJECT_TYPE_NAME = Integer.class.getName();
        INTEGER_PRIMITIVE_TYPE_NAME = Integer.TYPE.getName();
        LONG_OBJECT_TYPE_NAME = Long.class.getName();
        LONG_PRIMITIVE_TYPE_NAME = Long.TYPE.getName();
        FLOAT_OBJECT_TYPE_NAME = Float.class.getName();
        FLOAT_PRIMITIVE_TYPE_NAME = Float.TYPE.getName();
        DOUBLE_OBJECT_TYPE_NAME = Double.class.getName();
        DOUBLE_PRIMITIVE_TYPE_NAME = Double.TYPE.getName();
        BIGDECIMAL_OBJECT_TYPE_NAME = BigDecimal.class.getName();
        BIGINTEGER_OBJECT_TYPE_NAME = BigInteger.class.getName();
        numericTypesV_ = new Vector();
        numericTypesV_.add(Byte.class.getName());
        numericTypesV_.add(Byte.TYPE.getName());
        numericTypesV_.add(Short.class.getName());
        numericTypesV_.add(Short.TYPE.getName());
        numericTypesV_.add(INTEGER_OBJECT_TYPE_NAME);
        numericTypesV_.add(INTEGER_PRIMITIVE_TYPE_NAME);
        numericTypesV_.add(LONG_OBJECT_TYPE_NAME);
        numericTypesV_.add(LONG_PRIMITIVE_TYPE_NAME);
        numericTypesV_.add(FLOAT_OBJECT_TYPE_NAME);
        numericTypesV_.add(FLOAT_PRIMITIVE_TYPE_NAME);
        numericTypesV_.add(DOUBLE_OBJECT_TYPE_NAME);
        numericTypesV_.add(DOUBLE_PRIMITIVE_TYPE_NAME);
        numericTypesV_.add(BIGDECIMAL_OBJECT_TYPE_NAME);
        numericTypesV_.add(BIGINTEGER_OBJECT_TYPE_NAME);
        numericTypesH_ = new HashSet(numericTypesV_);
        booleanTypes_ = new HashSet();
        booleanTypes_.add(BOOLEAN_OBJECT_TYPE_NAME);
        booleanTypes_.add(BOOLEAN_PRIMITIVE_TYPE_NAME);
        dateTypes_ = new HashSet();
        HashSet h = dateTypes_;
        h.add(Date.class.getName());
        h.add(java.sql.Date.class.getName());
        h.add(Time.class.getName());
        h.add(Timestamp.class.getName());
    }
}

