/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.server.ejb.container;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.EntityEJBObject;
import com.evermind.server.ejb.OracleEntityContext;
import com.oracle.server.ejb.container.deployment.ContainerEntityDescriptor;
import com.oracle.server.ejb.persistence.container.ContainerCallback;
import com.oracle.server.ejb.persistence.pm.CmpEntityBean;
import javax.ejb.EJBContext;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public class ContainerCallbackImpl
implements ContainerCallback {
    EntityEJBHome remoteHome = null;
    EntityEJBHome localHome = null;

    public ContainerCallbackImpl(ContainerEntityDescriptor ced) {
        try {
            if (ced.getLocalHomeInterfaceClass() != null) {
                this.localHome = (EntityEJBHome)ced.createHomeInstance(true);
            }
            if (ced.getRemoteInterfaceClass() != null) {
                this.remoteHome = (EntityEJBHome)ced.createHomeInstance(false);
            }
        }
        catch (InstantiationException e) {
            ApplicationServer.getInstance().log("Error creating home", e);
        }
        if (this.localHome != null) {
            this.localHome.theOtherHome = this.remoteHome;
        }
        if (this.remoteHome != null) {
            this.remoteHome.theOtherHome = this.localHome;
        }
    }

    public EJBObject allocateRemoteWrapperInstance(Object pk) {
        if (this.remoteHome == null) {
            throw EJBUtils.createEJBException("No remote interface specified for this bean");
        }
        EntityEJBObject wrapper = this.remoteHome.createBeanWrapperInstance(null, false);
        wrapper.setPK_X(pk);
        return (EJBObject)wrapper;
    }

    public EJBLocalObject allocateLocalWrapperInstance(Object pk) {
        if (this.localHome == null) {
            throw EJBUtils.createEJBException("No local interface specified for this bean");
        }
        EntityEJBObject wrapper = this.localHome.createBeanWrapperInstance(null, false);
        wrapper.setPK_X(pk);
        return (EJBLocalObject)wrapper;
    }

    public CmpEntityBean allocateBeanInstance(Object _pk) {
        EntityEJBHome _home = this.remoteHome != null ? this.remoteHome : this.localHome;
        return (CmpEntityBean)((OracleEntityContext)_home.getContextWithID(_pk)).getObject();
    }

    public void releaseBeanInstance(CmpEntityBean bean, Object _pk, boolean canBeReused) {
        EntityEJBHome _home = this.remoteHome != null ? this.remoteHome : this.localHome;
        _home.releaseContextWithID((EJBContext)bean.__getEJBContext(), !canBeReused);
    }
}

