/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.naming;

import com.evermind.naming.DelayedBinding;
import com.evermind.naming.FlatNameParser;
import com.evermind.server.administration.ResourceFinder;
import com.evermind.server.deployment.DestinationReference;
import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.deployment.InjectableReference;
import com.evermind.server.deployment.MailSessionInfo;
import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.rmi.RMIInitialContext;
import com.oracle.naming.LookupFactory;
import com.oracle.server.ServiceReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.mail.Session;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import oracle.j2ee.jndi.JndiMessages;
import oracle.j2ee.ws.server.deployment.ServiceReferenceDescriptor;
import oracle.oc4j.configuration.J2EEContextDescriptor;
import oracle.oc4j.naming.BindingsEnumeration;

public class J2EEContext
implements Context {
    private String m_displayName;
    private Map m_bindings;
    private Context m_root;
    private static final String OC4J_URL_PKG_PREFIX = "oracle.oc4j.naming.url";
    private static final String OC4J_OPTIONAL_URL_PKG_PREFIX = "oracle.oc4j.environment.naming";
    public static final String OC4J_OPTIONAL_CLIENT_URL_PKG_PREFIX = "oracle.j2ee.jndi.client";

    public static J2EEContext create(J2EEContextDescriptor aDescriptor, ResourceFinder finder, Context rootContext, List mailSessions) throws InstantiationException {
        try {
            HashMap bindings = new HashMap();
            EnvironmentEntry.initializeEnvironmentEntries(bindings, aDescriptor.getEnvironmentEntries());
            if (mailSessions != null) {
                J2EEContext.addMailSessionEntries(bindings, mailSessions);
            }
            J2EEContext.addResourceEntries(rootContext, finder, bindings, aDescriptor.getResourceReferences());
            J2EEContext.addResourceEnvironmentEntries(rootContext, finder, bindings, aDescriptor.getResourceEnvironmentReferences());
            J2EEContext.addDestinationEntries(rootContext, finder, bindings, aDescriptor.getDestinationReferences());
            J2EEContext.addEJBReferenceEntries(finder, bindings, aDescriptor.getEJBReferences());
            J2EEContext.addServiceReferenceEntries(bindings, aDescriptor.getServiceReferences());
            J2EEContext.addJmxEjbReferences(bindings);
            return new J2EEContext(aDescriptor.getDisplayName(), bindings, rootContext);
        }
        catch (RemoteException e) {
            JndiMessages.logException(e);
            throw (InstantiationException)new InstantiationException("Error communicating with server: " + e.getMessage()).initCause(e);
        }
    }

    public static void setupURLPackagePrefixes(boolean isEnvironmentNamingURLFactoryEnabled) {
        J2EEContext.setupURLPackagePrefixesInternal(isEnvironmentNamingURLFactoryEnabled, OC4J_OPTIONAL_URL_PKG_PREFIX);
    }

    public static void setupClientURLPackagePrefixes(boolean isURLContextFactoryEnabled) {
        J2EEContext.setupURLPackagePrefixesInternal(isURLContextFactoryEnabled, OC4J_OPTIONAL_CLIENT_URL_PKG_PREFIX);
    }

    private static void setupURLPackagePrefixesInternal(boolean isEnvironmentNamingURLFactoryEnabled, String urlContextHandlerPackage) {
        String urlProp = System.getProperty("java.naming.factory.url.pkgs", OC4J_URL_PKG_PREFIX);
        if (!urlProp.equals(OC4J_URL_PKG_PREFIX)) {
            String prefixString = null;
            prefixString = isEnvironmentNamingURLFactoryEnabled ? urlContextHandlerPackage + ":" + OC4J_URL_PKG_PREFIX : OC4J_URL_PKG_PREFIX;
            urlProp = prefixString + ":" + urlProp;
        } else if (isEnvironmentNamingURLFactoryEnabled) {
            urlProp = urlContextHandlerPackage + ":" + urlProp;
        }
        System.setProperty("java.naming.factory.url.pkgs", urlProp);
    }

    J2EEContext(String displayName, Map map, Context root) {
        if (map == null) {
            throw new IllegalArgumentException("bindings were null");
        }
        this.m_displayName = displayName;
        this.m_bindings = map;
        this.m_root = root;
    }

    public void backDoorRebind(String name, Object object) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        this.m_bindings.put(name, object);
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return this;
        }
        if (name.equals("ejb/mgmt/MEJB")) {
            return this.getMEJB();
        }
        Object answer = this.m_bindings.get(name);
        if (answer == null) {
            return this.getSubContext(name);
        }
        if (answer instanceof DelayedBinding) {
            Object actualInstance = ((DelayedBinding)answer).getInstance();
            this.m_bindings.put(name, actualInstance);
            return actualInstance;
        }
        if (answer instanceof Reference) {
            try {
                Object instance = NamingManager.getObjectInstance(answer, null, this.m_root, this.m_root == null ? null : this.m_root.getEnvironment());
                if (this.shouldCacheDereference((Reference)answer)) {
                    this.m_bindings.put(name, instance);
                }
                return instance;
            }
            catch (NamingException e) {
                JndiMessages.logException(e);
                throw e;
            }
            catch (Exception e) {
                JndiMessages.logException(e);
                throw (NamingException)new NamingException(e.getMessage()).initCause(e);
            }
        }
        return answer;
    }

    private boolean shouldCacheDereference(Reference reference) throws NamingException {
        if (!RMIInitialContext.isJ2EEContextCachingEnabled(this.m_root.getEnvironment())) {
            return false;
        }
        RefAddr cacheAddr = reference.get("CachePolicy");
        if (cacheAddr == null) {
            return true;
        }
        return !"NEVER".equals(cacheAddr.getContent());
    }

    private Context getSubContext(String name) throws NameNotFoundException {
        HashMap subContextEntries = new HashMap();
        Iterator i = this.m_bindings.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = entry.getKey().toString();
            if (!key.startsWith(name + '/') || key.equals(name)) continue;
            subContextEntries.put(key.substring(name.length() + 1), entry.getValue());
        }
        if (subContextEntries.isEmpty()) {
            throw new NameNotFoundException("java:comp/env/" + name + " not found" + (this.m_displayName == null || this.m_displayName.length() == 0 ? "" : " in " + this.m_displayName));
        }
        J2EEContext context = new J2EEContext(this.m_displayName, subContextEntries, this.m_root);
        this.m_bindings.put(name, context);
        return context;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is immutable");
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void rebind(String name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is immutable");
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    public synchronized void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException("Context is immutable");
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public synchronized void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException("Context is immutable");
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        return BindingsEnumeration.list(name, this.m_bindings);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return BindingsEnumeration.listBindings(this, name, this.m_bindings);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("This context does not support subcontexts");
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("This Context does not support subcontexts");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return FlatNameParser.getInstance();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    private Object getMEJB() {
        try {
            Class<?> cl = Class.forName("oracle.oc4j.admin.management.mejb.MEjbHome");
            Class[] paramType = new Class[]{Context.class};
            Constructor<?> constructor = cl.getConstructor(paramType);
            Object[] param = new Object[]{this};
            return constructor.newInstance(param);
        }
        catch (InstantiationException e) {
            JndiMessages.logException(e);
        }
        catch (IllegalAccessException e) {
            JndiMessages.logException(e);
        }
        catch (IllegalArgumentException e) {
            JndiMessages.logException(e);
        }
        catch (InvocationTargetException e) {
            JndiMessages.logException(e);
        }
        catch (ClassNotFoundException e) {
            JndiMessages.logException(e);
        }
        catch (NoSuchMethodException e) {
            JndiMessages.logException(e);
        }
        catch (SecurityException e) {
            JndiMessages.logException(e);
        }
        return null;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return null;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    public Hashtable getEnvironment() throws NamingException {
        return new Hashtable();
    }

    public void close() throws NamingException {
    }

    public static boolean isURLContextFactoryEnabled(Hashtable environment) {
        String envURLPackagePrefix = (String)environment.get("java.naming.factory.url.pkgs");
        if (envURLPackagePrefix != null && envURLPackagePrefix.startsWith(OC4J_OPTIONAL_CLIENT_URL_PKG_PREFIX)) {
            return true;
        }
        String sysURLPackagePrefix = System.getProperty("java.naming.factory.url.pkgs");
        return sysURLPackagePrefix != null && sysURLPackagePrefix.startsWith(OC4J_OPTIONAL_CLIENT_URL_PKG_PREFIX);
    }

    public String toString() {
        return "[Context " + this.m_displayName + ": " + this.m_bindings + "]";
    }

    public String getNameInNamespace() {
        if (this.m_displayName == null) {
            return "";
        }
        return this.m_displayName;
    }

    private static void addServiceReferenceEntries(Map bindings, List serviceReferences) {
        if (serviceReferences.isEmpty()) {
            return;
        }
        Iterator iterator = serviceReferences.iterator();
        while (iterator.hasNext()) {
            ServiceReferenceDescriptor descriptor = (ServiceReferenceDescriptor)iterator.next();
            ServiceReference reference = new ServiceReference(descriptor.getServiceInterface(), descriptor);
            bindings.put(descriptor.getName(), reference);
        }
    }

    private static void addEJBReferenceEntries(ResourceFinder finder, Map bindings, List ejbReferences) throws RemoteException {
        if (ejbReferences.isEmpty()) {
            return;
        }
        Iterator iterator = ejbReferences.iterator();
        while (iterator.hasNext()) {
            EJBReference reference = (EJBReference)iterator.next();
            J2EEContext.validateDuplicateReference(reference, bindings);
            String location = reference.getLocation();
            if (location != null && location.startsWith("java:comp/env")) {
                JndiMessages.warningInvalidReferencePossibleCircularReference(reference.getName(), location);
                continue;
            }
            Object ejbBindingReference = null;
            try {
                ejbBindingReference = finder.getEjbBinding(reference);
                bindings.put(reference.getName(), ejbBindingReference);
            }
            catch (InstantiationException instantiationException) {
                JndiMessages.warningInvalidEJBReference(reference.getName(), instantiationException);
            }
            catch (RemoteException remoteException) {
                J2EEContext.attemptEjbLookupInPreviousVersion(remoteException, finder, reference, bindings);
            }
        }
    }

    private static void attemptEjbLookupInPreviousVersion(RemoteException remoteException, ResourceFinder finder, EJBReference reference, Map bindings) throws RemoteException {
        if (remoteException.getCause() instanceof NoSuchMethodException) {
            try {
                EJBHome ejbBindingReference = finder.getEJBHome(reference.getName(), reference.getHomeName(), reference.getRemoteName(), reference.getType(), reference.getLink(), reference.isLocal());
                bindings.put(reference.getName(), ejbBindingReference);
            }
            catch (Throwable t) {
                JndiMessages.warningInvalidEJBReference(reference.getName(), t);
            }
        } else {
            throw remoteException;
        }
    }

    private static void addResourceEnvironmentEntries(Context root, ResourceFinder finder, Map bindings, List resourceEnvironmentReferences) {
        Iterator iterator = resourceEnvironmentReferences.iterator();
        while (iterator.hasNext()) {
            ResourceEnvironmentReference reference = (ResourceEnvironmentReference)iterator.next();
            J2EEContext.validateDuplicateReference(reference, bindings);
            try {
                Object value = null;
                if (reference.getValue() != null) {
                    value = reference.getValue();
                } else {
                    String type = reference.getType();
                    String predefinedLocation = null;
                    if (type.equals("javax.mail.Session")) {
                        value = J2EEContext.getValueFromMailSessionRef(reference, bindings);
                    } else if (type.equals("java.net.URL")) {
                        value = J2EEContext.getValueFromUrlRef(reference);
                    } else {
                        predefinedLocation = J2EEContext.getPredefinedReferenceLocation(type);
                        if (predefinedLocation != null) {
                            value = LookupFactory.createBinding(type, predefinedLocation, false);
                        } else if (value == null) {
                            String location = reference.getLocation();
                            if (location != null && location.startsWith("java:comp/env")) {
                                JndiMessages.warningInvalidReferencePossibleCircularReference(reference.getName(), location);
                            } else {
                                value = J2EEContext.getValueFromRootContext(reference, finder, root);
                            }
                        }
                    }
                }
                bindings.put(reference.getName(), value);
            }
            catch (InstantiationException e) {
                J2EEContext.logInvalidResourceEnvironmentReference(reference, e);
            }
            catch (RemoteException e) {
                J2EEContext.logInvalidResourceEnvironmentReference(reference, e);
            }
            catch (NamingException e) {
                J2EEContext.logInvalidResourceEnvironmentReference(reference, e);
            }
        }
    }

    public static String getPredefinedReferenceLocation(String referenceType) {
        if (referenceType == null) {
            return null;
        }
        if (referenceType.equals("javax.transaction.UserTransaction")) {
            return "java:comp/UserTransaction";
        }
        if (referenceType.equals("javax.ejb.EJBContext") || referenceType.equals("javax.ejb.SessionContext") || referenceType.equals("javax.ejb.EntityContext") || referenceType.equals("javax.ejb.MessageDrivenContext")) {
            return "java:comp/EJBContext";
        }
        if (referenceType.equals("javax.ejb.TimerService")) {
            return "java:comp/TimerService";
        }
        return null;
    }

    private static void logInvalidResourceEnvironmentReference(ResourceEnvironmentReference reference, Exception e) {
        JndiMessages.warningInvalidResourceEnvironmentReference(reference.getName(), e);
    }

    private static void addDestinationEntries(Context root, ResourceFinder finder, Map bindings, List destinationReferences) throws InstantiationException, RemoteException {
        try {
            Iterator iterator = destinationReferences.iterator();
            while (iterator.hasNext()) {
                DestinationReference reference = (DestinationReference)iterator.next();
                J2EEContext.validateDuplicateReference(reference, bindings);
                Object value = null;
                if (reference.getValue() != null) {
                    value = reference.getValue();
                } else {
                    String type = reference.getType();
                    if (type.equals("javax.mail.Session")) {
                        value = J2EEContext.getValueFromMailSessionRef(reference, bindings);
                    } else if (type.equals("java.net.URL")) {
                        value = J2EEContext.getValueFromUrlRef(reference);
                    } else if (value == null) {
                        value = J2EEContext.getValueFromRootContext(reference, finder, root);
                    }
                }
                bindings.put(reference.getName(), value);
            }
        }
        catch (NamingException e) {
            throw (InstantiationException)new InstantiationException("Error creating context: " + e.getMessage()).initCause(e);
        }
    }

    private static Object getValueFromRootContext(ResourceEnvironmentReference reference, ResourceFinder finder, Context root) throws RemoteException, InstantiationException, NamingException {
        String location = reference.getLocation();
        if ((location == null || location.trim().equals("")) && (location = finder.getLocation(reference.getName(), reference.getType())) == null) {
            throw new InstantiationException("No location specified for resource-env-ref " + reference.getName());
        }
        Object value = root.lookup(location);
        if (value == null) {
            throw new InstantiationException("No javax.sql.DataSource found at " + location);
        }
        return value;
    }

    private static Object getValueFromUrlRef(ResourceEnvironmentReference reference) throws InstantiationException {
        URL value;
        String location = reference.getLocation();
        if (location != null) {
            try {
                value = new URL(location);
            }
            catch (MalformedURLException e) {
                throw new InstantiationException("Invalid URL specified for resource " + reference.getName() + ": " + e.getMessage());
            }
        } else {
            throw new InstantiationException("No location set for URL resource " + reference.getName());
        }
        return value;
    }

    private static Object getValueFromMailSessionRef(ResourceEnvironmentReference reference, Map bindings) throws InstantiationException {
        Object value = null;
        String location = reference.getLocation();
        if (location == null) {
            location = reference.getName();
        }
        if (location != null) {
            value = bindings.get(location);
        }
        if (value == null) {
            throw new InstantiationException("No Mail Session configured for the resource " + reference.getName());
        }
        return value;
    }

    private static void addResourceEntries(Context root, ResourceFinder finder, Map bindings, List resourceReferences) throws InstantiationException, RemoteException {
        Iterator iterator = resourceReferences.iterator();
        while (iterator.hasNext()) {
            ResourceReference reference = (ResourceReference)iterator.next();
            J2EEContext.validateDuplicateReference(reference, bindings);
            Object value = null;
            if (reference.getValue() != null) {
                value = reference.getValue();
            } else {
                String type = reference.getType();
                if (type.equals("javax.mail.Session")) {
                    value = J2EEContext.getValueFromMailSessionRef(reference, bindings);
                } else if (type.equals("java.net.URL")) {
                    value = J2EEContext.getValueFromUrlRef(reference);
                } else {
                    String location;
                    block20: {
                        location = null;
                        try {
                            location = reference.getLocation();
                            if (location != null && location.startsWith("java:comp/env")) {
                                JndiMessages.warningInvalidReferencePossibleCircularReference(reference.getName(), location);
                                continue;
                            }
                            if (location != null && !location.trim().equals("")) {
                                value = root.lookup(location);
                                break block20;
                            }
                            try {
                                value = root.lookup(reference.getName());
                            }
                            catch (NamingException e) {
                                location = finder.getLocation(reference.getName(), type);
                                if (location != null) {
                                    value = root.lookup(location);
                                    break block20;
                                }
                                JndiMessages.warningInvalidResourceReferenceLocation(reference.getName());
                            }
                        }
                        catch (NamingException e) {
                            J2EEContext.logInvalidResourceReference(reference, e);
                        }
                        catch (InstantiationException e) {
                            J2EEContext.logInvalidResourceReference(reference, e);
                        }
                    }
                    try {
                        Object connectionResource = finder.getJCAConnectionResource(root, location, reference);
                        if (connectionResource != null) {
                            value = connectionResource;
                        } else if (value == null) {
                            JndiMessages.warningNoTypeFoundAtLocation(type, location);
                        }
                    }
                    catch (InstantiationException e) {
                        J2EEContext.logInvalidResourceReference(reference, e);
                    }
                }
            }
            bindings.put(reference.getName(), value);
        }
    }

    private static void logInvalidResourceReference(ResourceReference reference, Exception e) {
        JndiMessages.warningInvalidResourceReference(reference.getName(), e);
    }

    private static void addMailSessionEntries(Map bindings, List mailSessions) throws InstantiationException {
        Iterator msIter = mailSessions.iterator();
        while (msIter.hasNext()) {
            MailSessionInfo mailSession = (MailSessionInfo)msIter.next();
            String location = mailSession.getLocation();
            if (location == null) {
                throw new InstantiationException("No location set for javax.mail.Session resource");
            }
            Session ms = mailSession.getSession();
            bindings.put(location, ms);
        }
    }

    private static void addJmxEjbReferences(Map bindings) {
        if (bindings.get("ejb/MBeanServerEjb") != null) {
            JndiMessages.warningMultipleReferencesOnRefName("ejb/MBeanServerEjb");
        }
        if (bindings.get("ejb/MBeanServerUserEjb") != null) {
            JndiMessages.warningMultipleReferencesOnRefName("ejb/MBeanServerUserEjb");
        }
        bindings.put("ejb/MBeanServerEjb", LookupFactory.createBinding(EJBHome.class, "MBeanServerEjb"));
        bindings.put("ejb/MBeanServerUserEjb", LookupFactory.createBinding(EJBHome.class, "MBeanServerUserEjb"));
    }

    private static void validateDuplicateReference(InjectableReference reference, Map bindings) {
        Object ref = bindings.get(reference.getName());
        if (ref != null) {
            JndiMessages.warningMultipleReferencesOnRefName(reference.getName());
        }
    }

    static {
        J2EEContext.setupURLPackagePrefixes(false);
    }

    class FlatBindings
    implements NamingEnumeration {
        Enumeration names;

        FlatBindings(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            return new Binding(name, J2EEContext.this.m_bindings.get(name));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }
    }

    class FlatNames
    implements NamingEnumeration {
        Enumeration names;

        FlatNames(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            String className = J2EEContext.this.m_bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }
    }
}

