/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.j2ee.JGroupConfig;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class ReplicationPolicy {
    protected static final String ON_CALL_STRING = "onCall";
    protected static final String ON_CHANGE_STRING = "onChange";
    protected static final String ON_SHUTDOWN_STRING = "onShutdown";
    protected static final String REPLICATION_NONE_STRING = "none";
    protected static final String REPLICATION_FILE_STRING = "file";
    protected static final String REPLICATION_CLUSTER_STRING = "VMTermination";
    protected static final String REPLICATION_CLUSTEREndOfMethodCall_STRING = "EndOfCall";
    protected static final String ON_SET_ATTRIBUTE_STRING = "onSetAttribute";
    protected static final String ON_REQUEST_END_STRING = "onRequestEnd";
    protected static final String MODIFIED_ATTRIBUTES_STRING = "modifiedAttributes";
    protected static final String ALL_ATTRIBUTES_STRING = "allAttributes";
    public static final int REPLICATION_NONE = 0;
    public static final int REPLICATION_FILE = 1;
    public static final int REPLICATION_CLUSTER = 2;
    public static final int REPLICATION_CLUSTEREndOfMethodCall = 3;
    public static final int ON_CALL = 4;
    public static final int ON_REQUEST_END = 4;
    public static final int ON_CHANGE = 5;
    public static final int ON_SET_ATTRIBUTE = 5;
    public static final int ON_SHUTDOWN = 6;
    public static final int MODIFIED_ATTRIBUTES = 7;
    public static final int ALL_ATTRIBUTES = 8;
    private int trigger = 0;
    private int scope = 7;

    public static ReplicationPolicy read(Node node) {
        ReplicationPolicy replicationPolicy = new ReplicationPolicy();
        String attr = JGroupConfig.getAttribute("replication-policy", node, null);
        if (attr != null) {
            replicationPolicy.setReplicationTrigger(ReplicationPolicy.convertReplicationTrigger(attr));
        } else {
            replicationPolicy.setReplicationTrigger(ReplicationPolicy.convertReplicationTrigger(JGroupConfig.getAttribute("trigger", node, ON_REQUEST_END_STRING)));
        }
        replicationPolicy.setReplicationScope(ReplicationPolicy.convertReplicationScope(JGroupConfig.getAttribute("scope", node, MODIFIED_ATTRIBUTES_STRING)));
        return replicationPolicy;
    }

    public boolean isOnCall() {
        return this.trigger == 4;
    }

    public boolean isOnChange() {
        return this.trigger == 5;
    }

    public boolean isOnShutdown() {
        return this.trigger == 6;
    }

    public boolean isNone() {
        return this.trigger == 0;
    }

    public boolean isOnRequestEnd() {
        return this.trigger == 4;
    }

    public boolean isOnSetAttribute() {
        return this.trigger == 5;
    }

    public static int convertReplicationTrigger(String trigger) {
        if (trigger != null) {
            if (trigger.equalsIgnoreCase(ON_CALL_STRING) || trigger.equalsIgnoreCase(ON_REQUEST_END_STRING)) {
                return 4;
            }
            if (trigger.equalsIgnoreCase(ON_CHANGE_STRING) || trigger.equalsIgnoreCase(ON_SET_ATTRIBUTE_STRING)) {
                return 5;
            }
            if (trigger.equalsIgnoreCase(ON_SHUTDOWN_STRING)) {
                return 6;
            }
            if (trigger.equalsIgnoreCase(REPLICATION_CLUSTER_STRING)) {
                return 6;
            }
            if (trigger.equalsIgnoreCase(REPLICATION_CLUSTEREndOfMethodCall_STRING)) {
                return 4;
            }
        }
        return 0;
    }

    public String getReplicationTriggerName() {
        return ReplicationPolicy.getReplicationTriggerName(this.trigger);
    }

    public static String getReplicationTriggerName(int type) {
        switch (type) {
            case 1: {
                return REPLICATION_FILE_STRING;
            }
            case 2: 
            case 6: {
                return ON_SHUTDOWN_STRING;
            }
            case 3: 
            case 4: {
                return ON_REQUEST_END_STRING;
            }
            case 5: {
                return ON_SET_ATTRIBUTE_STRING;
            }
        }
        return REPLICATION_NONE_STRING;
    }

    public void setReplicationTrigger(int trigger) {
        this.trigger = trigger;
    }

    public void write(PrintWriter out, String indent) {
        out.print(indent);
        out.print("<replication-policy trigger=");
        out.print("\"" + this.getReplicationTriggerName() + "\" scope=\"" + this.getReplicationScopeName() + "\"");
        out.println("/>");
    }

    public void setReplicationScope(int scope) {
        this.scope = scope;
    }

    public int getReplicationScope() {
        return this.scope;
    }

    public static int convertReplicationScope(String scope) {
        if (scope != null && scope.equalsIgnoreCase(ALL_ATTRIBUTES_STRING)) {
            return 8;
        }
        return 7;
    }

    public String getReplicationScopeName() {
        return this.scope == 7 ? MODIFIED_ATTRIBUTES_STRING : ALL_ATTRIBUTES_STRING;
    }
}

