/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.Local;
import com.oracle.bricks.LocalObject;
import com.oracle.bricks.Replica;
import com.oracle.bricks.j2ee.Session;
import com.oracle.bricks.j2ee.SessionEventListener;
import com.oracle.bricks.j2ee.SessionFacade;
import com.oracle.bricks.j2ee.SessionReplica;
import com.oracle.jgroups.ChannelAdapter;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.Address;
import org.jgroups.ChannelException;

public class LiveSession
extends LocalObject
implements Session {
    private long lastAccessed;
    protected final HashMap map = new HashMap();
    private String user;
    private final HashSet puts = new HashSet(5);
    private final HashSet removes = new HashSet(5);
    private final Object lastAccessedLock = new Object();
    private long creationTime;
    private int maxInactiveTime = 1200;
    private SessionEventListener listener = SessionEventListener.NullListener.getSingleton();
    private final SessionFacade facade = new SessionFacade(this);
    private int ip = -1;
    private static final Logger m_logger = ClusteringTraceLogger.getHttpTraceLogger(LiveSession.class);

    private LiveSession(Serializable id) {
        super(id);
        this.setLastAccessed(System.currentTimeMillis());
        this.listener = SessionEventListener.NullListener.getSingleton();
    }

    public LiveSession(Serializable id, SessionEventListener listener, int addr, long creationTime) {
        this(id);
        this.creationTime = creationTime;
        this.setLastAccessed(creationTime);
        this.setIp(addr);
        if (listener != null) {
            this.listener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LiveSession(SessionReplica replica) {
        super(replica);
        this.setLastAccessed(replica.getLastAccessed());
        this.maxInactiveTime = replica.getLifetime();
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            this.map.putAll(replica.getMap());
        }
        this.user = replica.getUser();
        this.ip = replica.getIp();
        this.creationTime = replica.getCreationTime();
    }

    private static boolean isMarshalled(Object o) {
        return o instanceof byte[];
    }

    public Local getFacade() {
        return this.facade;
    }

    private void kill() {
        this.facade.setSession(Session.DeadSession.getSingleton());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Replica getReplica(Address address) throws Exception {
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            return new SessionReplica(this, (HashMap)this.map.clone(), this.adapter.getMarshaller());
        }
    }

    public void dropped() {
        this.listener.sessionDropped(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLastAccessed() {
        try {
            this.stateChangeSync.acquire();
            try {
                Object object = this.lastAccessedLock;
                synchronized (object) {
                    long l = this.lastAccessed;
                    return l;
                }
            }
            finally {
                this.stateChangeSync.release();
            }
        }
        catch (InterruptedException e) {
            if (!m_logger.isLoggable(Level.FINEST)) throw (IllegalStateException)new IllegalStateException("Cannot access state: ").initCause(e);
            m_logger.log(Level.FINEST, "Sync error", e);
            throw (IllegalStateException)new IllegalStateException("Cannot access state: ").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccessed(long lastAccessed) {
        try {
            this.stateChangeSync.acquire();
            try {
                Object object = this.lastAccessedLock;
                synchronized (object) {
                    this.lastAccessed = lastAccessed;
                }
            }
            finally {
                this.stateChangeSync.release();
            }
        }
        catch (InterruptedException e) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Sync error", e);
            }
            throw (IllegalStateException)new IllegalStateException("Cannot access state: ").initCause(e);
        }
    }

    public int getMaxInactiveTime() {
        return this.maxInactiveTime;
    }

    public void setMaxInactiveTime(int maxInactiveTime) {
        this.maxInactiveTime = maxInactiveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int size() {
        try {
            this.stateChangeSync.acquire();
            try {
                HashMap hashMap = this.map;
                synchronized (hashMap) {
                    int n = this.map.size();
                    return n;
                }
            }
            finally {
                this.stateChangeSync.release();
            }
        }
        catch (InterruptedException e) {
            if (!m_logger.isLoggable(Level.FINEST)) throw (IllegalStateException)new IllegalStateException("Cannot access state: ").initCause(e);
            m_logger.log(Level.FINEST, "Sync error", e);
            throw (IllegalStateException)new IllegalStateException("Cannot access state: ").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List keyList() throws InterruptedException {
        this.stateChangeSync.acquire();
        try {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                ArrayList arrayList = new ArrayList(this.map.keySet());
                return arrayList;
            }
        }
        finally {
            this.stateChangeSync.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List entryList() throws InterruptedException {
        this.stateChangeSync.acquire();
        try {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.deSerializeMap(this.map);
                ArrayList arrayList = new ArrayList(this.map.entrySet());
                return arrayList;
            }
        }
        finally {
            this.stateChangeSync.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable get(Serializable key) throws InterruptedException {
        this.stateChangeSync.acquire();
        try {
            this.setLastAccessed(System.currentTimeMillis());
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                Object value = this.map.get(key);
                if (value != null && ObjectMarshaller.isMarshalled(value)) {
                    Serializable v;
                    block10: {
                        v = null;
                        try {
                            v = this.deSerializeAttribute(value);
                        }
                        catch (Throwable t) {
                            if (!m_logger.isLoggable(Level.FINEST)) break block10;
                            m_logger.log(Level.FINEST, "Cannot deserialize attribute: " + key, t);
                        }
                    }
                    this.map.put(key, v);
                }
                Serializable serializable = (Serializable)this.map.get(key);
                return serializable;
            }
        }
        finally {
            this.stateChangeSync.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable put(Serializable key, Serializable value) throws InterruptedException {
        Serializable result;
        this.stateChangeSync.acquire();
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            try {
                this.puts.add(key);
                this.removes.remove(key);
                result = this.map.put(key, value);
            }
            finally {
                this.stateChangeSync.release();
            }
        }
        if (result == null) {
            this.listener.attributeAdded(key, value);
        } else {
            this.listener.attributeModified(key, value, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable remove(Serializable key) throws InterruptedException {
        Serializable result;
        this.stateChangeSync.acquire();
        try {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.removes.add(key);
                this.puts.remove(key);
                result = (Serializable)this.map.remove(key);
            }
        }
        finally {
            this.stateChangeSync.release();
        }
        this.listener.attributeRemoved(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove() throws InterruptedException {
        super.remove();
        this.stateChangeSync.acquire();
        try {
            this.listener.sessionReaped(this);
            this.kill();
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                this.map.clear();
            }
        }
        finally {
            this.stateChangeSync.release();
        }
    }

    protected boolean shouldReap(long currentTime) {
        return this.getLastAccessed() + (long)(this.maxInactiveTime * 1000) < currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() throws InterruptedException {
        if (this.getReplicas().isEmpty()) {
            return;
        }
        Replica.Message message = null;
        Object object = this.stateChangeSync.freeze();
        synchronized (object) {
            try {
                Serializable[] thePuts = new Serializable[this.puts.size() * 2];
                Object[] putArray = thePuts;
                Iterator putIt = this.puts.iterator();
                int index = 0;
                while (index < thePuts.length) {
                    Object key = putIt.next();
                    putArray[index++] = key;
                    putArray[index++] = this.map.get(key);
                }
                Serializable[] theRemoves = new Serializable[this.removes.size()];
                Object[] removeArray = theRemoves;
                Iterator removeIt = this.removes.iterator();
                int index2 = 0;
                while (index2 < theRemoves.length) {
                    removeArray[index2++] = removeIt.next();
                }
                message = this.createApplyDeltaMessage(thePuts, theRemoves);
            }
            finally {
                this.clearModAccounting();
                this.stateChangeSync.thaw();
            }
        }
        this.send(message);
    }

    protected Replica.Message createApplyDeltaMessage(Serializable[] thePuts, Serializable[] theRemoves) {
        return new SessionReplica.ApplyDelta(this.getId(), this.lastAccessed, this.user, thePuts.length == 0 ? null : thePuts, theRemoves.length == 0 ? null : theRemoves);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushMap() throws InterruptedException {
        if (this.getReplicas().isEmpty()) {
            return;
        }
        Replica.Message message = null;
        Object object = this.stateChangeSync.freeze();
        synchronized (object) {
            try {
                Serializable[] thePuts = new Serializable[this.map.size() * 2];
                Object[] putArray = thePuts;
                Iterator putIt = this.map.entrySet().iterator();
                int index = 0;
                while (index < thePuts.length) {
                    Map.Entry entry = putIt.next();
                    putArray[index++] = entry.getKey();
                    putArray[index++] = entry.getValue();
                }
                Serializable[] theRemoves = new Serializable[this.removes.size()];
                Object[] removeArray = theRemoves;
                Iterator removeIt = this.removes.iterator();
                int index2 = 0;
                while (index2 < theRemoves.length) {
                    removeArray[index2++] = removeIt.next();
                }
                message = this.createApplyDeltaMessage(thePuts, theRemoves);
            }
            finally {
                this.clearModAccounting();
                this.stateChangeSync.thaw();
            }
        }
        this.send(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reaped() {
        this.disconnect();
        try {
            this.stateChangeSync.acquire();
            try {
                this.listener.sessionReaped(this);
                this.kill();
                HashMap hashMap = this.map;
                synchronized (hashMap) {
                    this.map.clear();
                }
            }
            finally {
                this.stateChangeSync.release();
            }
        }
        catch (InterruptedException e) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Sync error", e);
            }
            throw (IllegalStateException)new IllegalStateException("Cannot access state: ").initCause(e);
        }
    }

    protected void ownedBy(Address newOwner, ChannelAdapter adapter) throws ChannelException {
        super.ownedBy(newOwner, adapter);
        this.listener.sessionMigrated(this);
    }

    private void clearModAccounting() {
        this.puts.clear();
        this.removes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUser() {
        this.stateChangeSync.acquire();
        try {
            String string = this.user;
            this.stateChangeSync.release();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.stateChangeSync.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "Sync error", e);
                }
                throw (IllegalStateException)new IllegalStateException("Cannot access state: ").initCause(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(String name) {
        try {
            this.stateChangeSync.acquire();
            try {
                this.user = name;
            }
            finally {
                this.stateChangeSync.release();
            }
        }
        catch (InterruptedException e) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Sync error", e);
            }
            throw (IllegalStateException)new IllegalStateException("Cannot access state: ").initCause(e);
        }
    }

    public int getIp() {
        return this.ip;
    }

    public void setIp(int ip) {
        this.ip = ip;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
    }

    public void setSessionEventListener(SessionEventListener listener) {
        if (this.listener != null && m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "setting new event listener: " + listener.getClass().getName());
        }
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(HttpSession session, boolean executeListeners) throws InterruptedException {
        Object object = this.stateChangeSync.freeze();
        synchronized (object) {
            try {
                if (executeListeners) {
                    Iterator i = this.map.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (!(value instanceof HttpSessionBindingListener)) continue;
                        ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent(session, key));
                    }
                }
            }
            finally {
                this.stateChangeSync.thaw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPassivate(HttpSessionEvent event) throws InterruptedException {
        Object object = this.stateChangeSync.freeze();
        synchronized (object) {
            try {
                Iterator i = this.map.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object value = entry.getValue();
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    ((HttpSessionActivationListener)value).sessionWillPassivate(event);
                }
            }
            finally {
                this.stateChangeSync.thaw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doActivate(HttpSessionEvent event) throws InterruptedException {
        Object object = this.stateChangeSync.freeze();
        synchronized (object) {
            try {
                this.deSerializeMap(this.map);
                Iterator i = this.map.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    Object value = entry.getValue();
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    ((HttpSessionActivationListener)value).sessionDidActivate(event);
                }
            }
            finally {
                this.stateChangeSync.thaw();
            }
        }
    }
}

