/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks.j2ee;

import com.oracle.bricks.j2ee.JGroupConfig;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class FlowControlPolicy {
    public static double DEFAULT_THRESHOLD_FACTOR = 0.25;
    public static long DEFAULT_MAX_CREDITS = 5000000L;
    public static long DEFAULT_MIN_CREDITS = 0L;
    static String DEFAULT_MAX_CREDITS_STR = Long.toString(DEFAULT_MAX_CREDITS);
    static String DEFAULT_MIN_CREDITS_STR = Long.toString(DEFAULT_MIN_CREDITS);
    static String FALSE_STR = "false";
    private long m_minCredits = DEFAULT_MIN_CREDITS;
    private long m_maxCredits = DEFAULT_MAX_CREDITS;
    private boolean m_enabled = true;
    private double m_threshold = DEFAULT_THRESHOLD_FACTOR;
    private boolean m_minCreditsDefined = false;

    public static FlowControlPolicy read(Node node) {
        FlowControlPolicy flowControlPolicy = new FlowControlPolicy();
        flowControlPolicy.initProperties(node);
        return flowControlPolicy;
    }

    protected void initProperties(Node node) {
        String minBytes;
        this.m_enabled = Boolean.valueOf(JGroupConfig.getAttribute("enabled", node, "true"));
        this.m_maxCredits = Long.parseLong(JGroupConfig.getAttribute("max-bytes", node, DEFAULT_MAX_CREDITS_STR));
        String threshold = JGroupConfig.getAttribute("threshold", node);
        if (threshold != null) {
            this.setThreshold(Double.parseDouble(threshold));
        }
        if ((minBytes = JGroupConfig.getAttribute("min-bytes", node)) != null) {
            this.setMinCredits(Long.parseLong(minBytes));
        }
    }

    public void setMaxCredits(long maxCredits) {
        this.m_maxCredits = maxCredits;
    }

    public void setMinCredits(long minCredits) {
        this.m_minCredits = minCredits;
        this.m_minCreditsDefined = true;
    }

    public long getMaxCredits() {
        return this.m_maxCredits;
    }

    public long getMinCredits() {
        return this.m_minCredits;
    }

    public void write(PrintWriter out, String indent) {
        out.print(indent);
        out.print("<flow-control-policy ");
        JGroupConfig.writeAttribute(out, "max-bytes", new Long(this.m_maxCredits).toString(), DEFAULT_MAX_CREDITS_STR);
        if (this.isMinCreditsDefined()) {
            JGroupConfig.writeAttribute(out, "min-bytes", new Long(this.m_minCredits).toString(), DEFAULT_MIN_CREDITS_STR);
        } else {
            JGroupConfig.writeAttribute(out, "threshold", new Double(this.m_threshold).toString(), new Double(DEFAULT_THRESHOLD_FACTOR).toString());
        }
        String enabled = this.isEnabled() ? "true" : FALSE_STR;
        JGroupConfig.writeAttribute(out, "enabled", enabled, "true");
        out.println(" />");
    }

    public void enable(boolean enabled) {
        this.m_enabled = enabled;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public double getThreshold() {
        return this.m_threshold;
    }

    public void setThreshold(double threshold) {
        this.m_threshold = threshold;
        this.m_minCreditsDefined = false;
    }

    public boolean isMinCreditsDefined() {
        return this.m_minCreditsDefined;
    }
}

