/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks;

import com.oracle.bricks.LocalObject;
import com.oracle.bricks.Manager;
import com.oracle.jgroups.AbstractGroup;
import com.oracle.jgroups.ControlMessage;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.Address;

public abstract class Replica
implements ObjectMarshaller.Marshalled {
    private List replicas;
    private Address owner;
    private Serializable id;
    private static final Logger m_logger = ClusteringTraceLogger.getTraceLogger(Replica.class);

    protected Replica() {
    }

    protected Replica(LocalObject lo) {
        this.id = lo.getId();
        this.owner = lo.getOwner();
        this.replicas = lo.getReplicas();
    }

    public Serializable getId() {
        return this.id;
    }

    public Address getOwner() {
        return this.owner;
    }

    protected void setOwner(Address newOwner) {
        this.owner = newOwner;
    }

    protected void updateWriteSet(List replicas, Address newOwner) {
        this.replicas = replicas;
        this.setOwner(newOwner);
    }

    protected List getReplicas() {
        return this.replicas;
    }

    protected void removeFailedMembers(Set failedMembers) {
        this.replicas.removeAll(failedMembers);
    }

    protected abstract LocalObject reify(ObjectMarshaller var1);

    public abstract boolean shouldReap(long var1);

    public abstract void reap();

    public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
        this.id = (Serializable)in.readObject();
        this.owner = (Address)marshaller.readExternal(in);
        int size = in.readInt();
        this.replicas = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.replicas.add(marshaller.readExternal(in));
        }
    }

    public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
        out.writeObject(this.id);
        marshaller.writeExternal(out, (Externalizable)this.owner);
        out.writeInt(this.replicas.size());
        Iterator i = this.replicas.iterator();
        while (i.hasNext()) {
            marshaller.writeExternal(out, (Externalizable)i.next());
        }
    }

    public String toString() {
        return "Replica id: " + this.id + ", owner: " + this.owner + ", replicas: " + this.replicas;
    }

    public static class UpdateWriteSet
    extends Message {
        private List writeSet;
        private Address newOwner;

        public UpdateWriteSet() {
        }

        public UpdateWriteSet(Serializable id, List writeSet, Address newOwner) {
            super(id);
            this.writeSet = writeSet;
            this.newOwner = newOwner;
        }

        public String toString() {
            return "Update write set: " + this.id + " : " + this.writeSet + " : " + this.newOwner;
        }

        public void applyTo(Replica replica, AbstractGroup manager, Serializable id) {
            if (replica != null) {
                replica.updateWriteSet(this.writeSet, this.newOwner);
            } else {
                LocalObject lObj = ((Manager)manager).getLocalObject(id);
                if (lObj != null) {
                    block7: {
                        this.writeSet.add(this.newOwner);
                        ArrayList extraMembers = new ArrayList(lObj.getReplicas());
                        extraMembers.removeAll(this.writeSet);
                        try {
                            if (!extraMembers.isEmpty()) {
                                lObj.broadcastRemoveReplicaMessage(extraMembers);
                            }
                            if (m_logger.isLoggable(Level.FINEST)) {
                                m_logger.log(Level.FINEST, "Broadcasting RemoveReplica message for id: " + lObj.getId() + " to members: " + extraMembers);
                            }
                        }
                        catch (InterruptedException e) {
                            if (!m_logger.isLoggable(Level.FINEST)) break block7;
                            m_logger.log(Level.FINEST, "Exception when broadcasting RemoveReplica message for id: " + lObj.getId() + " to members: " + extraMembers, e);
                        }
                    }
                    ((Manager)manager).drop(id, this.newOwner);
                }
            }
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            super.writeExternal(out, marshaller);
            out.writeInt(this.writeSet.size());
            for (int i = 0; i < this.writeSet.size(); ++i) {
                marshaller.writeExternal(out, (Externalizable)((Address)this.writeSet.get(i)));
            }
            marshaller.writeExternal(out, (Externalizable)this.newOwner);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            super.readExternal(in, marshaller);
            int count = in.readInt();
            this.writeSet = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                this.writeSet.add(marshaller.readExternal(in));
            }
            this.newOwner = (Address)marshaller.readExternal(in);
        }
    }

    public static abstract class Message
    implements ControlMessage {
        protected Serializable id;

        protected Message() {
        }

        protected Message(Serializable id) {
            this.id = id;
        }

        public void dispatch(AbstractGroup manager) {
            Replica replica = ((Manager)manager).getReplica(this.id);
            this.applyTo(replica, manager, this.id);
        }

        protected abstract void applyTo(Replica var1, AbstractGroup var2, Serializable var3);

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            out.writeObject(this.id);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            this.id = (Serializable)in.readObject();
        }
    }
}

