/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bricks;

import com.evermind.server.cluster.ServerIdentification;
import com.evermind.util.ServerProperties;
import com.oracle.bricks.Local;
import com.oracle.bricks.LocalObject;
import com.oracle.bricks.Replica;
import com.oracle.jgroups.AbstractGroup;
import com.oracle.jgroups.ControlMessage;
import com.oracle.jgroups.ObjectMarshaller;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.clustering.ClusteringMessages;
import oracle.j2ee.clustering.ClusteringTraceLogger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Promise;

public class Manager
extends AbstractGroup {
    private long slack = 20000L;
    protected final Map locals = new HashMap();
    protected final Map replicas = new HashMap();
    protected int writeQuota;
    protected boolean colocated = true;
    protected final Map promisedMigrations = new HashMap();
    protected static final SecureRandom random = new SecureRandom();
    private static final Logger m_logger = ClusteringTraceLogger.getTraceLogger(Manager.class);
    private Hashtable localRmiInfo = null;
    protected Hashtable rmiPeers = new Hashtable();
    public static final String NON_SECURE_LOCATION = "NON_SECURE_LOCATION";
    public static final String SECURE_LOCATION = "SECURE_LOCATION";
    protected static int AVG_UPDATES_PER_SEC = 500;

    public Manager(String group, ChannelFactory channelFactory, Object properties, int writeQuota) throws ChannelException {
        super(group, channelFactory, properties);
        this.writeQuota = writeQuota;
    }

    protected ObjectMarshaller getMarshaller() {
        ObjectMarshaller marshaller = super.getMarshaller();
        marshaller.map(AddReplica.class);
        marshaller.map(DropLocal.class);
        marshaller.map(RemoveReplica.class);
        marshaller.map(RetrieveReplica.class);
        marshaller.map(MigrateState.class);
        marshaller.map(Replica.Message.class);
        marshaller.map(Replica.UpdateWriteSet.class);
        return marshaller;
    }

    public boolean allowColocation() {
        return this.colocated;
    }

    public void setColocated(boolean colocated) {
        this.colocated = colocated;
    }

    public void setMaxBuffers(int maxBuffers) {
        this.adapter.setMaxBuffers(maxBuffers);
    }

    public int getMaxBuffers() {
        return this.adapter.getMaxBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Local get(Serializable oid, int timeout) throws InterruptedException, ChannelException, Exception {
        LocalObject obj;
        this.viewChangeSync.acquire();
        try {
            Replica replica;
            obj = this.getLocalObject(oid);
            if (obj != null) {
                LocalObject localObject = obj;
                return localObject;
            }
            Map map = this.replicas;
            synchronized (map) {
                replica = (Replica)this.replicas.remove(oid);
            }
            this.failoverDelay();
            if (replica == null) {
                MigrateState state = this.sendRetrieveReplica(oid, null, timeout);
                if (state == null) {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "FAILED: Cannot find session: " + oid);
                    }
                    Local local = null;
                    return local;
                }
                replica = state.getReplica();
                List replicas = replica.getReplicas();
                if (replicas != null && replicas.size() > 0) {
                    int member = 0;
                    Address target = (Address)replicas.get(member);
                    Address sender = state.getSender();
                    while (target != null && !sender.equals(target) && member < replicas.size()) {
                        state = this.sendRetrieveReplica(oid, target, timeout);
                        if (state == null) {
                            target = (Address)replica.getReplicas().get(member++);
                            continue;
                        }
                        replica = state.getReplica();
                        sender = state.getSender();
                        break;
                    }
                }
                if (replica == null) {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "FAILED: Cannot find session: " + oid);
                    }
                    Local local = null;
                    return local;
                }
            }
            obj = replica.reify(this.adapter.getMarshaller());
            map = this.locals;
            synchronized (map) {
                this.locals.put(replica.getId(), obj);
            }
        }
        finally {
            this.viewChangeSync.release();
        }
        obj.ownedBy(this.address, this.adapter);
        this.rebalance(obj, new HashSet());
        return obj;
    }

    private MigrateState sendRetrieveReplica(Serializable oid, Address target, int timeout) throws ChannelNotConnectedException, ChannelClosedException {
        MigrateState state = null;
        try {
            ArrayList candidates = new ArrayList(this.adapter.getMembers());
            candidates.remove(this.address);
            if (candidates.size() > 0) {
                Promise promise = new Promise();
                this.promisedMigrations.put(oid, promise);
                this.adapter.send(target, new RetrieveReplica(oid, this.address));
                state = (MigrateState)promise.getResult((long)timeout);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        return state;
    }

    protected long failoverDelay() {
        long delay = 0L;
        if (ServerProperties.getClusterFailoverDelay() > 0) {
            delay = ServerProperties.getClusterFailoverDelay();
        } else {
            int numQueuedMsgs = this.adapter.getNumMessages();
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Number of queued msgs before retrieving replica: " + numQueuedMsgs);
            }
            delay = this.calculateDelayToRetrieveReplica(numQueuedMsgs);
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "failover delay: " + delay + " msecs");
        }
        if (delay > 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return delay;
    }

    protected long calculateDelayToRetrieveReplica(int numQueuedMsgs) {
        long sleepTime = 0L;
        if (numQueuedMsgs > AVG_UPDATES_PER_SEC) {
            sleepTime = Math.round(numQueuedMsgs / AVG_UPDATES_PER_SEC) * 1000;
        }
        return sleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrateState(MigrateState state) {
        Promise promise;
        Map map = this.promisedMigrations;
        synchronized (map) {
            promise = (Promise)this.promisedMigrations.remove(state.getReplica().getId());
        }
        if (promise != null) {
            promise.setResult((Object)state);
        } else if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "discarding migrated state as promise no longer exists for <" + state.getReplica().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LocalObject object) throws Exception {
        this.viewChangeSync.acquire();
        try {
            Map map = this.locals;
            synchronized (map) {
                if (this.locals.get(object.getId()) != null) {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, "Manager already contains object of id: " + object.getId());
                    }
                    throw new IllegalStateException("Already contains object of id: " + object.getId());
                }
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "Adding object with id: " + object.getId());
                }
                object.initialize(this.address, this.chooseWriteSet(), this.adapter);
                this.locals.put(object.getId(), object);
            }
        }
        finally {
            this.viewChangeSync.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Serializable oid) throws InterruptedException {
        this.viewChangeSync.acquire();
        try {
            LocalObject lobj = this.removeLocalObject(oid);
            if (lobj == null) {
                m_logger.log(Level.FINEST, "Manager does not contain object of id: " + oid);
                return;
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Removing object with id: " + oid);
            }
            lobj.remove();
        }
        finally {
            this.viewChangeSync.release();
        }
    }

    protected List chooseWriteSet() {
        ArrayList candidates;
        ArrayList replicas;
        block7: {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Choosing initial write set <" + this.writeQuota + ">");
            }
            if (this.adapter.getMembers().size() == 1) {
                m_logger.log(Level.FINEST, "No members");
                return new ArrayList(0);
            }
            replicas = new ArrayList();
            candidates = new ArrayList(this.adapter.getMembers());
            candidates.remove(this.address);
            if (!this.allowColocation()) {
                try {
                    this.removeColocatedCandidates(candidates, ((IpAddress)this.address).getIpAddress());
                }
                catch (ClassCastException e) {
                    if (!m_logger.isLoggable(Level.FINEST)) break block7;
                    m_logger.log(Level.FINEST, "Manager.chooseWriteSet: allow-colocation attribute only supported with Network-dependent address (Internet)", e);
                }
            }
        }
        while (replicas.size() < this.writeQuota && candidates.size() != 0) {
            int randomIndex = Math.round(random.nextFloat() * (float)(candidates.size() - 1));
            replicas.add(candidates.remove(randomIndex));
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "initial replica set: " + replicas);
        }
        return replicas;
    }

    protected void drop(Serializable id, Address newOwner) {
        LocalObject obj;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, this.address + " Dropping local object " + id + ", new owner " + newOwner);
        }
        if ((obj = this.removeLocalObject(id)) != null) {
            obj.dropped();
        }
        try {
            this.adapter.send(newOwner, new DropLocalResponse(id, this.address));
        }
        catch (Exception e) {
            e.printStackTrace();
            m_logger.log(Level.FINEST, "Failed to send DropLocalResponse Message for " + id + " to " + newOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocalObject removeLocalObject(Serializable id) {
        LocalObject obj = null;
        Map map = this.locals;
        synchronized (map) {
            obj = (LocalObject)this.locals.remove(id);
        }
        return obj;
    }

    protected void handleDropResponse(Serializable id, Address oldOwner) {
        LocalObject obj;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "DropLocalResponse for: " + id + ", from previous owner " + oldOwner);
        }
        if ((obj = this.getLocalObject(id)) != null) {
            obj.handleDropResponse(oldOwner);
        } else if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Unable to find LocalObject: " + id + " to handle DropLocalResponse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newView(Set newMembers, Set failedMembers) {
        Iterator i;
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "rebalancing - new members: " + newMembers + ", failedMembers: " + failedMembers);
        }
        Map map = this.locals;
        synchronized (map) {
            i = this.locals.values().iterator();
            while (i.hasNext()) {
                LocalObject lo = (LocalObject)i.next();
                try {
                    this.rebalance(lo, failedMembers);
                }
                catch (Exception e) {
                    if (m_logger.isLoggable(Level.FINEST)) {
                        m_logger.log(Level.FINEST, e + " when rebalancing " + lo.getId());
                    }
                    e.printStackTrace();
                }
            }
        }
        if (failedMembers != null && !failedMembers.isEmpty()) {
            map = this.replicas;
            synchronized (map) {
                i = this.replicas.values().iterator();
                while (i.hasNext()) {
                    Replica replica = (Replica)i.next();
                    replica.removeFailedMembers(failedMembers);
                    if (!failedMembers.contains(replica.getOwner()) || !this.address.equals(replica.getReplicas().get(0))) continue;
                    try {
                        this.get(replica.getId(), 1000);
                    }
                    catch (Exception e) {
                        if (m_logger.isLoggable(Level.FINEST)) {
                            m_logger.log(Level.FINEST, e + " when assuming ownership of " + replica.getId() + " in " + this.address);
                        }
                        e.printStackTrace();
                    }
                }
            }
            Iterator it = failedMembers.iterator();
            while (it.hasNext()) {
                this.rmiPeers.remove(it.next());
            }
        }
        if (newMembers != null && newMembers.size() > 0) {
            ArrayList targets = new ArrayList(newMembers);
            this.broadcastRMIInfo(targets, this.localRmiInfo);
        }
    }

    protected void broadcastRMIInfo(List targets, Hashtable rmiInfo) {
        if (rmiInfo == null || rmiInfo.size() == 0) {
            return;
        }
        if (targets == null) {
            targets = this.adapter.getMembers();
        }
        try {
            this.adapter.broadcast(targets, new RMIInfoMessage(this.address, rmiInfo), false);
        }
        catch (InterruptedException e) {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, e + " when sending RMIInfoMessage to peers");
            }
            e.printStackTrace();
        }
    }

    protected void rebalance(LocalObject object, Set droppedMembers) {
        ArrayList candidates;
        ArrayList previousMembers;
        ArrayList newReplicants;
        List replicas;
        block9: {
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "rebalancing " + object.getId());
            }
            replicas = object.getReplicas();
            replicas.removeAll(droppedMembers);
            if (replicas.size() == this.writeQuota) {
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "new replicas for {0} are {1}", new Object[]{object.getId(), replicas});
                }
                return;
            }
            newReplicants = new ArrayList();
            previousMembers = new ArrayList(replicas);
            candidates = new ArrayList(this.adapter.getMembers());
            candidates.remove(this.address);
            candidates.removeAll(replicas);
            if (!this.allowColocation()) {
                try {
                    this.removeColocatedCandidates(candidates, ((IpAddress)this.address).getIpAddress());
                }
                catch (ClassCastException e) {
                    if (!m_logger.isLoggable(Level.FINEST)) break block9;
                    m_logger.log(Level.FINEST, "Manager.rebalance: allow-colocation attribute only supported with Network-dependent address (Internet)", e);
                }
            }
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "rebalancing amongst: " + candidates);
        }
        while (replicas.size() < this.writeQuota && candidates.size() != 0) {
            int randomIndex = Math.round(random.nextFloat() * (float)(candidates.size() - 1));
            Object enlisted = candidates.remove(randomIndex);
            replicas.add(enlisted);
            newReplicants.add(enlisted);
        }
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "new replica set for {0} is {1}", new Object[]{object.getId(), replicas});
        }
        object.rebalance(newReplicants, previousMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addReplica(Replica replica) {
        Map map = this.replicas;
        synchronized (map) {
            if (this.replicas.get(replica.getId()) != null) {
                m_logger.log(Level.FINEST, "Replica < {0} > already exists!", replica.getId());
                return;
            }
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "Adding replica of " + replica.getId());
            }
            this.replicas.put(replica.getId(), replica);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Replica getReplica(Serializable id) {
        Map map = this.replicas;
        synchronized (map) {
            return (Replica)this.replicas.get(id);
        }
    }

    protected void retrieveReplica(Address newOwner, Serializable id) {
        LocalObject lObj;
        Replica replica = this.getReplica(id);
        if (replica == null && (lObj = this.getLocalObject(id)) != null) {
            try {
                replica = lObj.getReplica(this.address);
                this.drop(lObj.getId(), newOwner);
            }
            catch (Exception e) {
                m_logger.log(Level.FINEST, "Error converting to Replica from LocalObject for state <{0}> and new owner: {1}", new Object[]{id, newOwner});
            }
        }
        if (replica != null) {
            try {
                this.adapter.send(newOwner, new MigrateState(replica, this.address));
            }
            catch (ChannelException e) {
                m_logger.log(Level.FINEST, "Error sending migrated state <{0}> to {1}", new Object[]{id, newOwner});
            }
            replica.setOwner(newOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeReplica(Serializable id) {
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Removing replica of " + id);
        }
        Map map = this.replicas;
        synchronized (map) {
            this.replicas.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reapReplicas() throws InterruptedException {
        this.viewChangeSync.acquire();
        try {
            Map map = this.replicas;
            synchronized (map) {
                ArrayList reapedReplicas = new ArrayList(this.replicas.size() / 2);
                Iterator i = this.replicas.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    if (!((Replica)entry.getValue()).shouldReap(System.currentTimeMillis() - this.slack)) continue;
                    reapedReplicas.add(entry.getKey());
                }
                i = reapedReplicas.iterator();
                while (i.hasNext()) {
                    Map.Entry sid = i.next();
                    Object o = this.replicas.remove(sid);
                    ((Replica)o).reap();
                }
                if (m_logger.isLoggable(Level.FINEST)) {
                    m_logger.log(Level.FINEST, "reaped {0} replicated sessions", new Integer(reapedReplicas.size()));
                }
            }
        }
        finally {
            this.viewChangeSync.release();
        }
    }

    protected void setOptions(Channel channel) {
        super.setOptions(channel);
        channel.setOpt(3, (Object)new Boolean(false));
    }

    public long getSlack() {
        return this.slack;
    }

    public void setSlack(long slack) {
        this.slack = slack;
    }

    protected void handleRMIInfoMessage(Address owner, Hashtable rmiInfo) {
        this.rmiPeers.put(owner, rmiInfo);
    }

    public ServerIdentification[] getNonSecurePeers() {
        String pretty;
        ArrayList<ServerIdentification> arrayList = new ArrayList<ServerIdentification>();
        Iterator itr = this.rmiPeers.values().iterator();
        while (itr.hasNext()) {
            Hashtable tbl = (Hashtable)itr.next();
            ServerIdentification nonSecureLocation = (ServerIdentification)tbl.get(NON_SECURE_LOCATION);
            if (nonSecureLocation == null) continue;
            arrayList.add(nonSecureLocation);
        }
        ServerIdentification[] ret = new ServerIdentification[arrayList.size()];
        ret = arrayList.toArray(ret);
        if (m_logger.isLoggable(Level.FINEST)) {
            if (ret.length > 0) {
                pretty = Manager.prettyPrintORMIInfo(ret);
                m_logger.log(Level.FINEST, "List of Peer ORMI members: " + pretty);
            } else {
                m_logger.log(Level.FINEST, " No known peers");
            }
        }
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            if (ret.length > 0) {
                pretty = Manager.prettyPrintORMIInfo(ret);
                ClusteringMessages.fineORMIPeerInfo(pretty);
            } else {
                ClusteringMessages.fineORMIPeerInfo("NONE");
            }
        }
        return ret;
    }

    private static String prettyPrintORMIInfo(ServerIdentification[] ret) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < ret.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(ret[i].toString());
        }
        return buf.toString();
    }

    public ServerIdentification[] getSecurePeers() {
        String pretty;
        ArrayList<ServerIdentification> arrayList = new ArrayList<ServerIdentification>();
        Iterator itr = this.rmiPeers.values().iterator();
        while (itr.hasNext()) {
            Hashtable tbl = (Hashtable)itr.next();
            ServerIdentification secureLocation = (ServerIdentification)tbl.get(SECURE_LOCATION);
            if (secureLocation == null) continue;
            arrayList.add(secureLocation);
        }
        ServerIdentification[] ret = new ServerIdentification[arrayList.size()];
        ret = arrayList.toArray(ret);
        if (m_logger.isLoggable(Level.FINEST)) {
            if (ret.length > 0) {
                pretty = Manager.prettyPrintORMIInfo(ret);
                m_logger.log(Level.FINEST, "List of secure ORMI peers: " + pretty);
            } else {
                m_logger.log(Level.FINEST, " No known secure peers");
            }
        }
        if (ClusteringMessages.isLoggable(Level.FINE)) {
            if (ret.length > 0) {
                pretty = Manager.prettyPrintORMIInfo(ret);
                ClusteringMessages.fineSecureORMIPeerInfo(pretty);
            } else {
                ClusteringMessages.fineSecureORMIPeerInfo("NONE");
            }
        }
        return ret;
    }

    public void setLocalRMIInfo(Hashtable info) {
        this.localRmiInfo = info;
    }

    public void sendAckApplyDeltaMessage(Serializable id, int ackSeqNo, Address owner) {
        try {
            this.adapter.send(owner, new AckApplyDelta(id, ackSeqNo, this.address));
        }
        catch (ChannelException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocalObject getLocalObject(Serializable oid) {
        Map map = this.locals;
        synchronized (map) {
            LocalObject obj = (LocalObject)this.locals.get(oid);
            if (obj != null) {
                return obj;
            }
        }
        return null;
    }

    protected void removeColocatedCandidates(List candidates, InetAddress localAddress) {
        block3: {
            try {
                ListIterator itr = candidates.listIterator();
                while (itr.hasNext()) {
                    InetAddress peerAddr = ((IpAddress)itr.next()).getIpAddress();
                    if (!peerAddr.equals(localAddress)) continue;
                    itr.remove();
                }
            }
            catch (ClassCastException e) {
                if (!m_logger.isLoggable(Level.FINEST)) break block3;
                m_logger.log(Level.FINEST, "Manager.removeColocatedCandidates: replication to colocated members on the same host machine is only supported with Network-dependent address (Internet)", e);
            }
        }
    }

    public static class AckApplyDelta
    implements ControlMessage {
        private Serializable id;
        private int ackSeqNo;
        private Address sender;

        public AckApplyDelta() {
        }

        public AckApplyDelta(Serializable id, int ackSeqNo, Address sender) {
            this.id = id;
            this.ackSeqNo = ackSeqNo;
            this.sender = sender;
        }

        public String toString() {
            return "AckApplyDelta: id: " + this.id + ", ackSeqNo: " + this.ackSeqNo;
        }

        public void dispatch(AbstractGroup group) {
            block4: {
                try {
                    LocalObject localObj = ((Manager)group).getLocalObject(this.id);
                    if (localObj == null) {
                        if (m_logger.isLoggable(Level.FINEST)) {
                            m_logger.log(Level.FINEST, "Unable to acknowledge synchronous update with sequence number: " + this.ackSeqNo + " from " + this.sender + " because LocalObject: " + this.id + " does not exist.");
                        }
                        return;
                    }
                    localObj.acknowledgeUpdate(this.ackSeqNo, this.sender);
                }
                catch (Exception e) {
                    if (!m_logger.isLoggable(Level.FINEST)) break block4;
                    m_logger.log(Level.FINEST, e + " when dispatching synchronous update for " + this.ackSeqNo + " from " + this.sender + " for " + this.id);
                }
            }
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            out.writeObject(this.id);
            out.writeInt(this.ackSeqNo);
            marshaller.writeExternal(out, (Externalizable)this.sender);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws ClassNotFoundException, IOException {
            this.id = (Serializable)in.readObject();
            this.ackSeqNo = in.readInt();
            this.sender = (Address)marshaller.readExternal(in);
        }

        public int getAckSeqNo() {
            return this.ackSeqNo;
        }

        public Address getSender() {
            return this.sender;
        }
    }

    public static class RMIInfoMessage
    implements ControlMessage {
        private Hashtable rmiInfo;
        private Address owner;

        public RMIInfoMessage() {
        }

        public RMIInfoMessage(Address owner, Hashtable rmiInfo) {
            this.owner = owner;
            this.rmiInfo = rmiInfo;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("RMIInfoMessage owner: ");
            String tmp = this.owner == null ? "null, " : this.owner + ", ";
            buffer.append(tmp);
            tmp = this.rmiInfo == null ? "null" : this.rmiInfo.toString();
            buffer.append(tmp);
            return buffer.toString();
        }

        public void dispatch(AbstractGroup group) {
            ((Manager)group).handleRMIInfoMessage(this.owner, this.rmiInfo);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            out.writeObject(this.rmiInfo);
            marshaller.writeExternal(out, (Externalizable)this.owner);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws ClassNotFoundException, IOException {
            this.rmiInfo = (Hashtable)in.readObject();
            this.owner = (Address)marshaller.readExternal(in);
        }
    }

    public static class MigrateState
    implements ControlMessage {
        protected Replica replica;
        protected Address sender;

        public MigrateState() {
        }

        public MigrateState(Replica replica, Address sender) {
            this.replica = replica;
            this.sender = sender;
        }

        public String toString() {
            if (this.replica == null) {
                return "MigrateState replica: null";
            }
            return "MigrateState replica: " + this.replica.getId() + " from sender: " + this.sender;
        }

        public void dispatch(AbstractGroup group) {
            ((Manager)group).migrateState(this);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            marshaller.writeMarshalled(out, this.replica);
            marshaller.writeExternal(out, (Externalizable)this.sender);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws ClassNotFoundException, IOException {
            this.replica = (Replica)marshaller.readMarshalled(in);
            this.sender = (Address)marshaller.readExternal(in);
        }

        public Address getSender() {
            return this.sender;
        }

        public Replica getReplica() {
            return this.replica;
        }
    }

    public static class RetrieveReplica
    implements ControlMessage {
        private Serializable id;
        private Address newOwner;

        public RetrieveReplica() {
        }

        public RetrieveReplica(Serializable id, Address newOwner) {
            this.id = id;
            this.newOwner = newOwner;
        }

        public String toString() {
            return "RetrieveReplica replica: " + this.id;
        }

        public void dispatch(AbstractGroup manager) {
            ((Manager)manager).retrieveReplica(this.newOwner, this.id);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            this.id = (Serializable)in.readObject();
            this.newOwner = (Address)marshaller.readExternal(in);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            out.writeObject(this.id);
            marshaller.writeExternal(out, (Externalizable)this.newOwner);
        }
    }

    public static class RemoveReplica
    implements ControlMessage {
        protected Serializable id;

        public RemoveReplica() {
        }

        public RemoveReplica(Serializable id) {
            this.id = id;
        }

        public String toString() {
            return "RemoveReplica replica: " + this.id;
        }

        public void dispatch(AbstractGroup manager) {
            ((Manager)manager).removeReplica(this.id);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            this.id = (Serializable)in.readObject();
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            out.writeObject(this.id);
        }
    }

    public static class AddReplica
    implements ControlMessage {
        private Replica replica;

        public AddReplica() {
        }

        public AddReplica(Replica replica) {
            this.replica = replica;
        }

        public String toString() {
            return "AddReplica replica: " + this.replica.getId();
        }

        public void dispatch(AbstractGroup manager) {
            ((Manager)manager).addReplica(this.replica);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            this.replica = (Replica)marshaller.readMarshalled(in);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            marshaller.writeMarshalled(out, this.replica);
        }
    }

    public static class DropLocalResponse
    implements ControlMessage {
        private Serializable id;
        private Address oldOwner;

        public DropLocalResponse() {
        }

        public DropLocalResponse(Serializable id, Address oldOwner) {
            this.id = id;
            this.oldOwner = oldOwner;
        }

        public String toString() {
            return "DropLocalResponse: " + this.id + " from old owner: " + this.oldOwner;
        }

        public void dispatch(AbstractGroup manager) {
            ((Manager)manager).handleDropResponse(this.id, this.oldOwner);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            this.id = (Serializable)in.readObject();
            this.oldOwner = (Address)marshaller.readExternal(in);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            out.writeObject(this.id);
            marshaller.writeExternal(out, (Externalizable)this.oldOwner);
        }
    }

    public static class DropLocal
    implements ControlMessage {
        private Serializable id;
        private Address newOwner;

        public DropLocal() {
        }

        public DropLocal(Serializable id, Address newOwner) {
            this.id = id;
            this.newOwner = newOwner;
        }

        public String toString() {
            return "DropLocal: " + this.id;
        }

        public void dispatch(AbstractGroup manager) {
            ((Manager)manager).drop(this.id, this.newOwner);
        }

        public void readExternal(ObjectInput in, ObjectMarshaller marshaller) throws IOException, ClassNotFoundException {
            this.id = (Serializable)in.readObject();
            this.newOwner = (Address)marshaller.readExternal(in);
        }

        public void writeExternal(ObjectOutput out, ObjectMarshaller marshaller) throws IOException {
            out.writeObject(this.id);
            marshaller.writeExternal(out, (Externalizable)this.newOwner);
        }
    }
}

