/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.xml;

import com.evermind.util.StringUtils;
import com.evermind.xml.JavaxXMLUtils;
import com.evermind.xml.XMLizable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static final int BOOLEAN_UNDEFINED = 0;
    public static final int BOOLEAN_TRUE = 1;
    public static final int BOOLEAN_FALSE = 2;

    public static String getSubnodeValue(Node parent, String subnode) {
        Node node = XMLUtils.getSubnode(parent, subnode);
        return node == null ? null : XMLUtils.getStringValue(node);
    }

    public static Node getSubnode(Node parent, String subnode) {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals(subnode)) continue;
                return node;
            }
        }
        return null;
    }

    public static String getStringValue(Node node) {
        Node child = node.getFirstChild();
        if (child == null) {
            return "";
        }
        String value = child.getNodeValue();
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public static String getNodeAttribute(Node node, String name) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return null;
        }
        Node namedNode = map.getNamedItem(name);
        if (namedNode == null) {
            return null;
        }
        String value = namedNode.getNodeValue();
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public static int getBooleanNodeAttribute(Node node, String name) {
        String value = XMLUtils.getNodeAttribute(node, name);
        if (value == null) {
            return 0;
        }
        return value.equals("true") ? 1 : 2;
    }

    public static boolean getBooleanNodeAttribute(Node node, String name, boolean defaultValue) {
        switch (XMLUtils.getBooleanNodeAttribute(node, name)) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return defaultValue;
    }

    public static String encode(String string) {
        if (string == null) {
            return "";
        }
        if (string.indexOf(38) >= 0) {
            string = StringUtils.replace(string, '&', "&amp;");
        }
        if (string.indexOf(60) >= 0) {
            string = StringUtils.replace(string, '<', "&lt;");
        }
        if (string.indexOf(62) >= 0) {
            string = StringUtils.replace(string, '>', "&gt;");
        }
        if (string.indexOf(34) >= 0) {
            string = StringUtils.replace(string, '\"', "&quot;");
        }
        return string;
    }

    public static void writeAll(Collection entries, PrintWriter out, String indention) throws IOException {
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            ((XMLizable)iterator.next()).writeXML(out, indention);
        }
    }

    public static void writeStrings(Collection entries, String tagName, PrintWriter out, String indention) throws IOException {
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            out.println(indention + "<" + tagName + ">" + XMLUtils.encode(iterator.next().toString()) + "</" + tagName + ">");
        }
    }

    public static void writeAttributeTags(Collection entries, String tagName, String attributeName, PrintWriter out, String indention) throws IOException {
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            out.println(indention + "<" + tagName + " " + attributeName + "=\"" + XMLUtils.encode(iterator.next().toString()) + "\" />");
        }
    }

    public static void writeCompressedMap(Map map, String tagName, PrintWriter out, String keyName, String valueName, String indention) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            out.println(indention + "<" + tagName + " " + keyName + "=\"" + XMLUtils.encode(entry.getKey().toString()) + "\" " + valueName + "=\"" + XMLUtils.encode(entry.getValue().toString()) + "\" />");
        }
    }

    public static void writeExtendedMap(Map map, String tagName, PrintWriter out, String keyName, String valueName, String indention) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            out.println(indention + "<" + tagName + ">");
            out.println(indention + "\t<" + keyName + ">" + XMLUtils.encode(entry.getKey().toString()) + "</" + keyName + ">");
            out.println(indention + "\t<" + valueName + ">" + XMLUtils.encode(entry.getValue().toString()) + "</" + valueName + ">");
            out.println(indention + "</" + tagName + ">");
        }
    }

    public static Document getDocument(InputSource source, ErrorHandler handler, EntityResolver resolver, boolean validate) throws SAXException, IOException, InstantiationException {
        return JavaxXMLUtils.getJavaxDocument(source, handler, resolver, validate);
    }

    public static Node getRootNode(byte[] data, EntityResolver resolver, String name) throws InstantiationException, IOException {
        try {
            InputSource source = new InputSource(new ByteArrayInputStream(data));
            Document document = XMLUtils.getDocument(source, null, resolver, false);
            if (document == null) {
                throw new InstantiationException("Error parsing " + name + ", empty document");
            }
            Element element = document.getDocumentElement();
            if (element == null) {
                throw new InstantiationException("Error parsing " + name + ", empty document");
            }
            return element;
        }
        catch (SAXException e) {
            throw new InstantiationException("Error parsing " + name + ": " + e.getMessage());
        }
    }

    public static boolean parseBoolean(String name, String value) throws InstantiationException {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new InstantiationException(name + " must be either 'true' or 'false', not '" + value + "'");
    }

    public static int parseInt(String name, String value) throws InstantiationException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InstantiationException("Illegal " + name + " value: '" + value + "', must be numeric");
        }
    }

    public static long parseLong(String name, String value) throws InstantiationException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new InstantiationException("Illegal " + name + " value: '" + value + "', must be numeric");
        }
    }

    public static boolean isCommentOrID(String name) {
        return name.startsWith("#");
    }

    public static String getUrlPatternValue(Node node) throws InstantiationException {
        String urlPattern = XMLUtils.getStringValue(node);
        if (urlPattern.indexOf(13) != -1 || urlPattern.indexOf(10) != -1) {
            throw new InstantiationException("Illegal url-pattern value: " + urlPattern + ", value must not contain CR or LF");
        }
        return urlPattern;
    }
}

