/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.xml;

import com.evermind.io.IOUtils;
import com.evermind.naming.ContextUtils;
import com.evermind.util.AbstractDescribable;
import com.evermind.util.AttributeContainer;
import com.evermind.util.CollectionLogger;
import com.evermind.util.ServerProperties;
import com.evermind.xml.ConfiguredEntityResolver;
import com.evermind.xml.EntityResolverUtil;
import com.evermind.xml.XMLUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.oc4j.admin.config.XMLConfigIF;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLConfig
extends AbstractDescribable
implements XMLConfigIF,
EntityResolver,
ErrorHandler,
AttributeContainer {
    public static final String IGNORE_XML_TAG = "#";
    private URL url;
    protected long lastModified;
    protected File file;
    protected CollectionLogger logger;
    private Context context;
    protected boolean validate = ServerProperties.getXmlValidate();
    protected boolean inDeploymentMode;
    private String documentEncoding = "utf-8";
    private DocumentType documentType = null;
    private Map attributes;
    private boolean fatal_parsing_error = false;
    private int WAIT_TIMEOUT = 60;
    private static boolean ON_WINDOWS = false;

    public XMLConfig() {
    }

    public XMLConfig(URL url) throws IOException, SAXException, InstantiationException {
        this.init(url);
    }

    public void setURL(URL url) throws InstantiationException {
        this.url = url;
        this.initLastModifieds();
    }

    public void initLastModifieds() throws InstantiationException {
        if (this.url != null && this.url.getProtocol().equals("file")) {
            this.file = new File(this.url.getFile());
            this.lastModified = this.file.lastModified();
        } else {
            this.file = null;
            this.lastModified = 0L;
        }
    }

    protected void assemblyPostInit() throws InstantiationException {
    }

    protected void postInit() throws InstantiationException {
    }

    public synchronized void init(URL url) throws IOException, InstantiationException {
        try {
            this.setURL(url);
            byte[] data = this.getContent(url);
            this.reset();
            this.init(data, 0, data.length, true);
        }
        catch (SAXException e) {
            throw new InstantiationException(url.getPath() + ", " + e.getMessage());
        }
        finally {
            this.initLastModifieds();
        }
    }

    public byte[] getContent(URL url) throws IOException, InstantiationException {
        byte[] data = IOUtils.getContent(url);
        if (data == null) {
            throw new InstantiationException("Unable to read file at " + url.toExternalForm());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(byte[] data, int start, int length, boolean deployment) throws InstantiationException, IOException, SAXException {
        if (!deployment) {
            this.reset();
        }
        if (this.attributes != null) {
            this.attributes.remove("problemBuffer");
            this.attributes.remove("problemWriter");
        }
        this.inDeploymentMode = deployment;
        try {
            InputSource source = new InputSource(new ByteArrayInputStream(data, start, length));
            try {
                source.setSystemId(".");
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                block17: {
                    Document document = XMLUtils.getDocument(source, this, this, this.validate);
                    if (document != null) {
                        try {
                            Element element = document.getDocumentElement();
                            if (element == null) {
                                throw new InstantiationException("Error parsing " + this.getName() + ", empty document");
                            }
                            this.verifyDocumentType(element.getNodeName());
                            this.validateDocument(document);
                            this.documentType = document.getDoctype();
                            this.parseRootNode(element, deployment);
                        }
                        catch (InstantiationException e) {
                            if (this.getProblemBuffer() != null) break block17;
                            throw e;
                        }
                    }
                }
                if (this.getProblemBuffer() != null) {
                    this.handleParserError(this.getProblems(), deployment);
                }
            }
            catch (SAXException e) {
                String problems = this.getProblems();
                if ((problems == null || problems.trim().length() == 0) && e.getMessage() != null) {
                    problems = e.getMessage();
                }
                this.handleParserError(problems, deployment);
            }
        }
        finally {
            this.inDeploymentMode = false;
        }
        if (deployment) {
            this.postInit();
        } else {
            this.assemblyPostInit();
        }
    }

    protected void validateDocument(Document document) throws InstantiationException {
    }

    private void handleParserError(String problems, boolean deployment) throws SAXException, IOException, InstantiationException {
        if (this.validate && ServerProperties.getXmlRewrite()) {
            this.validate = false;
            try {
                this.init(this.getURL());
                System.err.println("The following errors occured processing " + this + ":");
                System.err.println(problems);
                System.err.println("Rewrite it to look like this?");
                PrintWriter writer = new PrintWriter(System.err, true);
                this.writeConfig(writer);
                writer.println();
                writer.flush();
                System.err.println("Yes/No?");
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                boolean rewrite = false;
                try {
                    rewrite = in.readLine().toLowerCase().startsWith("y");
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (rewrite) {
                    this.store();
                    System.out.println("Config updated...");
                    this.initLastModifieds();
                    return;
                }
                throw new SAXException(problems);
            }
            finally {
                this.validate = true;
            }
        }
        throw new SAXException(problems);
    }

    protected void reset() {
        this.attributes = null;
    }

    protected void parseRootNode(Node node, boolean deployment) throws InstantiationException {
        int i;
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (i = 0; i < length; ++i) {
                Node item = map.item(i);
                String name = item.getNodeName();
                String value = item.getNodeValue();
                value = value == null ? "" : value.trim();
                if (!deployment) {
                    this.parseRootNodeValue(name, value);
                    continue;
                }
                this.parseDeploymentRootNodeValue(name, value);
            }
        }
        NodeList nodes = node.getChildNodes();
        for (i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeName().startsWith(IGNORE_XML_TAG)) continue;
            if (!deployment) {
                this.parseMainNode(nodes.item(i));
                continue;
            }
            this.parseDeploymentMainNode(nodes.item(i));
        }
    }

    protected void parseRootNodeValue(String name, String value) throws InstantiationException {
    }

    protected void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
    }

    protected void parseMainNode(Node node) throws InstantiationException {
        if (node.getNodeName().equals("name")) {
            this.setName(XMLUtils.getStringValue(node));
        }
    }

    protected void parseDeploymentMainNode(Node node) throws InstantiationException {
        throw new InstantiationException("Unknown deployment tag in " + this + ": <" + node.getNodeName() + ">");
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource retVal = null;
        retVal = this.validate ? this.resolveEntityWithValidation(publicId, systemId) : new InputSource(new ByteArrayInputStream(new byte[0]));
        return retVal;
    }

    public String toString() {
        if (this.getDisplayName() == null) {
            if (this.url != null) {
                return this.url.toString();
            }
            if (this.context != null) {
                return this.getContext().toString();
            }
            return super.toString();
        }
        return this.getDisplayName();
    }

    protected String getDirectoryURLString() {
        String path = this.url.toExternalForm();
        return path.substring(0, path.lastIndexOf(47) + 1);
    }

    public synchronized boolean isUpdated() {
        if (!ServerProperties.getPollFiles()) {
            return false;
        }
        if (this.file == null) {
            return false;
        }
        return this.file.lastModified() != this.lastModified;
    }

    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        if (this.url != null) {
            return this.url.toString();
        }
        try {
            if (this.context != null) {
                return this.context.getNameInNamespace();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return "Unknown config";
    }

    public boolean equals(Object other) {
        try {
            XMLConfig config = (XMLConfig)other;
            return this.url.equals(config.url) && this.lastModified == config.lastModified;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void update() throws InstantiationException {
        try {
            this.init(this.url);
        }
        catch (IOException e) {
            throw new InstantiationException("Unable to read config-file at " + this.url + ": " + e.getMessage());
        }
    }

    public void invalidate() {
        this.lastModified = -1L;
    }

    public void store() throws IOException {
        if (this.file == null && this.url == null) {
            throw new IOException("No URL specified to store this configuration to");
        }
        if (ON_WINDOWS) {
            this.storeWindows();
        } else {
            this.storeReliable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeWindows() throws IOException {
        File lockTemporaryFile = null;
        try {
            OutputStream out;
            if (this.file != null) {
                lockTemporaryFile = new File(this.file.getCanonicalPath() + ".lock");
                long startTime = System.currentTimeMillis();
                try {
                    while (!lockTemporaryFile.createNewFile()) {
                        long currentTime;
                        try {
                            this.getProblemWriter().write("waiting for releasing file lock: " + this.file.getName());
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if ((currentTime = System.currentTimeMillis()) - startTime < (long)(this.WAIT_TIMEOUT * 1000)) continue;
                        lockTemporaryFile.delete();
                        this.getProblemWriter().write("reaching an timeout and lock file is forcefully removed : " + this.file.getName());
                    }
                    lockTemporaryFile.deleteOnExit();
                }
                catch (Exception e) {
                    IOException newioe = new IOException("failed to create an lock file : " + lockTemporaryFile.getName());
                    newioe.initCause(e);
                    throw newioe;
                }
                out = new FileOutputStream(this.file);
            } else {
                out = this.url.openConnection().getOutputStream();
            }
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, this.getDocumentEncoding()));
            this.writeConfig(writer);
            if (writer.checkError()) {
                throw new IOException("Error Occured while writing to Config file");
            }
            writer.close();
            out.close();
        }
        finally {
            if (lockTemporaryFile != null) {
                lockTemporaryFile.delete();
            }
        }
        try {
            this.initLastModifieds();
        }
        catch (InstantiationException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeReliable() throws IOException {
        block30: {
            File oldTemporaryFile;
            File newTemporaryFile;
            block29: {
                newTemporaryFile = null;
                oldTemporaryFile = null;
                File lockTemporaryFile = null;
                try {
                    OutputStream out;
                    if (this.file != null) {
                        lockTemporaryFile = new File(this.file.getCanonicalPath() + ".lock");
                        long startTime = System.currentTimeMillis();
                        try {
                            while (!lockTemporaryFile.createNewFile()) {
                                long currentTime;
                                try {
                                    this.getProblemWriter().write("waiting for releasing file lock: " + this.file.getName());
                                    Thread.sleep(1000L);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                if ((currentTime = System.currentTimeMillis()) - startTime < (long)(this.WAIT_TIMEOUT * 1000)) continue;
                                lockTemporaryFile.delete();
                                this.getProblemWriter().write("reaching an timeout and lock file is forcefully removed : " + this.file.getName());
                            }
                            lockTemporaryFile.deleteOnExit();
                        }
                        catch (Exception e) {
                            IOException newioe = new IOException("failed to create an lock file : " + lockTemporaryFile.getName());
                            newioe.initCause(e);
                            throw newioe;
                        }
                        newTemporaryFile = File.createTempFile("new_" + this.file.getName(), ".xml", this.file.getParentFile());
                        String randomSuffix = Integer.toString((int)(Math.random() * 32768.0));
                        oldTemporaryFile = new File(this.file.getParentFile() + File.separator + "old_" + this.file.getName() + randomSuffix + ".xml");
                        out = new FileOutputStream(newTemporaryFile);
                    } else {
                        out = this.url.openConnection().getOutputStream();
                    }
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, this.getDocumentEncoding()));
                    this.writeConfig(writer);
                    if (writer.checkError()) {
                        throw new IOException("Error Occured while writing to Config file");
                    }
                    writer.close();
                    out.close();
                    if (this.file != null) {
                        if (this.file.exists() && !this.file.renameTo(oldTemporaryFile)) {
                            throw new IOException("Error Occurred while renaming current config file to old. current:" + this.file + " (exists:" + this.file.exists() + "),old:" + oldTemporaryFile + " (exists:" + oldTemporaryFile.exists() + ")");
                        }
                        if (!newTemporaryFile.renameTo(this.file)) {
                            throw new IOException("Error Occurred while renaming new config file to current. new:" + newTemporaryFile + " (exists:" + newTemporaryFile.exists() + " ,current:" + this.file + " (exists:" + this.file.exists() + ")");
                        }
                    }
                    Object var10_13 = null;
                    if (lockTemporaryFile == null) break block29;
                    lockTemporaryFile.delete();
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    if (lockTemporaryFile != null) {
                        lockTemporaryFile.delete();
                    }
                    if (this.file != null) {
                        if (!this.file.exists()) {
                            if (oldTemporaryFile.exists()) {
                                oldTemporaryFile.renameTo(this.file);
                            } else if (newTemporaryFile.exists()) {
                                newTemporaryFile.renameTo(this.file);
                            }
                        }
                        if (newTemporaryFile != null) {
                            newTemporaryFile.delete();
                        }
                        if (oldTemporaryFile != null) {
                            oldTemporaryFile.delete();
                        }
                    }
                    throw throwable;
                }
            }
            if (this.file == null) break block30;
            if (!this.file.exists()) {
                if (oldTemporaryFile.exists()) {
                    oldTemporaryFile.renameTo(this.file);
                } else if (newTemporaryFile.exists()) {
                    newTemporaryFile.renameTo(this.file);
                }
            }
            if (newTemporaryFile != null) {
                newTemporaryFile.delete();
            }
            if (oldTemporaryFile != null) {
                oldTemporaryFile.delete();
            }
        }
        try {
            this.initLastModifieds();
        }
        catch (InstantiationException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected abstract void writeConfig(PrintWriter var1) throws IOException;

    protected abstract void verifyDocumentType(String var1) throws InstantiationException;

    public URL getURL() {
        if (this.url != null) {
            return this.url;
        }
        if (this.context != null) {
            try {
                File file = ContextUtils.getFile(this.context, false);
                if (file != null) {
                    return file.toURL();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        if (context != null && this.url != null && this.url.getFile().endsWith(".xml")) {
            throw new InternalError("Illegal context setting");
        }
        this.context = context;
    }

    private String getProblems() {
        if (this.getProblemWriter() == null) {
            return "";
        }
        this.getProblemWriter().flush();
        return new String(this.getProblemBuffer().toCharArray());
    }

    private void initProblemWriter() {
        if (this.getProblemWriter() == null) {
            CharArrayWriter problemBuffer = new CharArrayWriter();
            this.getAttributes().put("problemBuffer", problemBuffer);
            this.getAttributes().put("problemWriter", new PrintWriter(problemBuffer));
        }
    }

    public void warning(SAXParseException e) {
        if (!this.validate) {
            return;
        }
        this.warningWithValidation(e);
    }

    public void error(SAXParseException e) throws SAXException {
        if (!this.validate) {
            return;
        }
        this.errorWithValidation(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.fatal_parsing_error = true;
        this.initProblemWriter();
        String location = "";
        if (e.getLineNumber() >= 0) {
            location = " at line " + e.getLineNumber();
            if (e.getColumnNumber() >= 0) {
                location = location + " offset " + e.getColumnNumber();
            }
        }
        if (this.getURL() != null) {
            location = location + " in " + this.getURL();
        }
        this.getProblemWriter().write("Fatal error" + location + ": ");
        this.getProblemWriter().write(e.getMessage() + "\n");
        throw new SAXException(this.getProblems());
    }

    public boolean isValidating() {
        return this.validate;
    }

    protected String getDocumentEncoding() {
        return this.documentEncoding;
    }

    public DocumentType getDoctype() {
        return this.documentType;
    }

    private CharArrayWriter getProblemBuffer() {
        return this.attributes == null ? null : (CharArrayWriter)this.attributes.get("problemBuffer");
    }

    private PrintWriter getProblemWriter() {
        return this.attributes == null ? null : (PrintWriter)this.attributes.get("problemWriter");
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }

    public InputSource resolveEntityWithValidation(String publicId, String systemId) {
        InputSource retVal = null;
        ConfiguredEntityResolver entityResolver = EntityResolverUtil.getConfiguredEntityResolver();
        if (entityResolver == null) {
            EntityResolverUtil.initDefault();
            entityResolver = EntityResolverUtil.getConfiguredEntityResolver();
        }
        if (entityResolver != null) {
            try {
                retVal = entityResolver.resolveEntity(publicId, systemId);
            }
            catch (SAXException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (retVal == null) {
            retVal = new InputSource(new ByteArrayInputStream(new byte[0]));
        }
        return retVal;
    }

    public void warningWithValidation(SAXParseException e) {
        this.initProblemWriter();
        String location = "";
        if (e.getLineNumber() >= 0) {
            location = " at line " + e.getLineNumber();
            if (e.getColumnNumber() >= 0) {
                location = location + " offset " + e.getColumnNumber();
            }
        }
        this.getProblemWriter().write("Warning" + location + ": ");
        this.getProblemWriter().write(e.getMessage() + "\n");
    }

    public void errorWithValidation(SAXParseException e) {
        this.initProblemWriter();
        String location = "";
        if (e.getLineNumber() >= 0) {
            location = " at line " + e.getLineNumber();
            if (e.getColumnNumber() >= 0) {
                location = location + " offset " + e.getColumnNumber();
            }
        }
        this.getProblemWriter().write("Error" + location + ": ");
        this.getProblemWriter().write(e.getMessage() + "\n");
    }

    static {
        String osname = System.getProperty("os.name");
        if (osname != null && osname.startsWith("Windows")) {
            ON_WINDOWS = true;
        }
    }
}

