/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.xml;

import com.evermind.xml.BasicEntityResolver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import oracle.j2ee.xml.XMLMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfiguredEntityResolver
extends BasicEntityResolver
implements ErrorHandler,
EntityResolver {
    public static final String CONFIG_NODE_NAME_ROOT_NODE = "entity-resolver-config";
    public static final String CONFIG_NODE_NAME_ENTITY = "entity";
    public static final String CONFIG_NODE_NAME_DESCRIPTION = "description";
    public static final String CONFIG_NODE_NAME_PUBLIC_ID = "public-id";
    public static final String CONFIG_NODE_NAME_SYSTEM_ID = "system-id";
    public static final String CONFIG_NODE_NAME_LOCATION = "location";
    String m_configFileName = null;

    public ConfiguredEntityResolver() {
    }

    public ConfiguredEntityResolver(String configFileName) {
        try {
            if (configFileName != null) {
                Document configDoc = ConfiguredEntityResolver.parse(new FileInputStream(configFileName), configFileName);
                this.procConfig(configDoc);
            }
        }
        catch (FileNotFoundException fnfe) {
            XMLMessages.warningEntityResolverConfigNotFound(configFileName, fnfe);
        }
        catch (SAXException ex) {
            XMLMessages.finerException(ex);
        }
        catch (IOException ex) {
            XMLMessages.warningEntityResolverConfigNotReadable(configFileName, ex);
        }
    }

    public ConfiguredEntityResolver(Document configDoc) {
        this.procConfig(configDoc);
    }

    public void procConfig(Document configDoc) {
        if (configDoc != null) {
            Element root = configDoc.getDocumentElement();
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!node.getNodeName().equals(CONFIG_NODE_NAME_ENTITY)) continue;
                this.procEntityNode(node);
            }
        }
    }

    protected void procEntityNode(Node entityNode) {
        String publicId = null;
        String systemId = null;
        String location = null;
        Node childNode = null;
        String nodeName = null;
        NodeList nodes = entityNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            childNode = nodes.item(i);
            nodeName = childNode.getNodeName();
            if (nodeName.equals(CONFIG_NODE_NAME_PUBLIC_ID)) {
                publicId = ConfiguredEntityResolver.getStringValue(childNode);
                continue;
            }
            if (nodeName.equals(CONFIG_NODE_NAME_SYSTEM_ID)) {
                systemId = ConfiguredEntityResolver.getStringValue(childNode);
                continue;
            }
            if (!nodeName.equals(CONFIG_NODE_NAME_LOCATION)) continue;
            location = ConfiguredEntityResolver.getStringValue(childNode);
        }
        if (location != null && (publicId != null || systemId != null)) {
            this.registerEntity(publicId, systemId, location);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        XMLMessages.finerException(exception);
    }

    public void error(SAXParseException exception) throws SAXException {
        XMLMessages.finerException(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        XMLMessages.warningException(exception);
    }

    private static String getStringValue(Node node) {
        Node child = node.getFirstChild();
        if (child == null) {
            return "";
        }
        String value = child.getNodeValue();
        if (value == null) {
            return "";
        }
        return value.trim();
    }
}

