/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util.classanalyzer;

import com.evermind.util.classanalyzer.Attribute;
import com.evermind.util.classanalyzer.ClassConstantPoolInfo;
import com.evermind.util.classanalyzer.ConstantPoolInfo;
import com.evermind.util.classanalyzer.DoubleConstantPoolInfo;
import com.evermind.util.classanalyzer.FieldInfo;
import com.evermind.util.classanalyzer.FieldRefConstantPoolInfo;
import com.evermind.util.classanalyzer.FloatConstantPoolInfo;
import com.evermind.util.classanalyzer.IntConstantPoolInfo;
import com.evermind.util.classanalyzer.InterfaceMethodRefConstantPoolInfo;
import com.evermind.util.classanalyzer.LongConstantPoolInfo;
import com.evermind.util.classanalyzer.MethodInfo;
import com.evermind.util.classanalyzer.MethodRefConstantPoolInfo;
import com.evermind.util.classanalyzer.NameAndTypeConstantPoolInfo;
import com.evermind.util.classanalyzer.StringConstantPoolInfo;
import com.evermind.util.classanalyzer.UTF8ConstantPoolInfo;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ClassAnalyzer {
    public boolean valid = false;
    public short majorVersion;
    public short minorVersion;
    public short constantPoolCount;
    public ConstantPoolInfo[] constantPoolInfo;
    public short accessFlags;
    public short thisClass;
    public short superClass;
    public short interfacesCount;
    public short[] interfaceInfo;
    public short fieldsCount;
    public FieldInfo[] fieldInfo;
    public short methodsCount;
    public MethodInfo[] methodInfo;
    public short attributesCount;
    public Attribute[] attribute;
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SUPER = 32;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;

    public ClassAnalyzer(String filename) {
        try {
            int i;
            FileInputStream fileIn = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fileIn);
            if (in.readInt() != -889275714) {
                System.out.println("Invalid 'magic' number - not a class file");
                in.close();
                return;
            }
            this.majorVersion = in.readShort();
            this.minorVersion = in.readShort();
            System.out.println("Version: " + this.majorVersion + "." + this.minorVersion);
            this.constantPoolCount = in.readShort();
            if (this.constantPoolCount < 1) {
                System.out.println("Invalid constant pool count");
                in.close();
                return;
            }
            System.out.println("Nr of pools: " + this.constantPoolCount);
            this.constantPoolInfo = new ConstantPoolInfo[this.constantPoolCount];
            for (i = 1; i < this.constantPoolCount; ++i) {
                this.constantPoolInfo[i] = this.readConstantPool(in);
            }
            this.accessFlags = in.readShort();
            this.thisClass = in.readShort();
            this.superClass = in.readShort();
            this.interfacesCount = in.readShort();
            for (i = 0; i < this.interfacesCount; ++i) {
                this.interfaceInfo[i] = in.readShort();
            }
            this.readFieldsInfo(in);
            this.readMethodsInfo(in);
            this.attribute = Attribute.readAttributeArray(in);
            this.valid = true;
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found");
        }
        catch (IOException e) {
            System.out.println("IOException occured");
        }
        System.out.println("Yep, a valid class");
    }

    private ConstantPoolInfo readConstantPool(DataInputStream in) throws IOException {
        ConstantPoolInfo PI = null;
        byte tag = in.readByte();
        switch (tag) {
            case 7: {
                short valueIndex = in.readShort();
                PI = new ClassConstantPoolInfo(valueIndex);
                break;
            }
            case 6: {
                double value = in.readDouble();
                PI = new DoubleConstantPoolInfo(value);
                break;
            }
            case 9: {
                short classIndex = in.readShort();
                short nameTypeIndex = in.readShort();
                PI = new FieldRefConstantPoolInfo(classIndex, nameTypeIndex);
                break;
            }
            case 4: {
                float fvalue = in.readFloat();
                PI = new FloatConstantPoolInfo(fvalue);
                break;
            }
            case 3: {
                int ivalue = in.readInt();
                PI = new IntConstantPoolInfo(ivalue);
                break;
            }
            case 11: {
                short iClassIndex = in.readShort();
                short iNameTypeIndex = in.readShort();
                PI = new InterfaceMethodRefConstantPoolInfo(iClassIndex, iNameTypeIndex);
                break;
            }
            case 5: {
                long lvalue = in.readLong();
                PI = new LongConstantPoolInfo(lvalue);
                break;
            }
            case 10: {
                short mclassIndex = in.readShort();
                short mnameTypeIndex = in.readShort();
                PI = new MethodRefConstantPoolInfo(mclassIndex, mnameTypeIndex);
                break;
            }
            case 12: {
                short nameIndex = in.readShort();
                short descriptionIndex = in.readShort();
                PI = new NameAndTypeConstantPoolInfo(nameIndex, descriptionIndex);
                break;
            }
            case 8: {
                short stringIndex = in.readShort();
                PI = new StringConstantPoolInfo(stringIndex);
                break;
            }
            case 1: {
                PI = new UTF8ConstantPoolInfo(in.readUTF());
            }
        }
        return PI;
    }

    private void readFieldsInfo(DataInputStream in) throws IOException {
        this.fieldsCount = in.readShort();
        this.fieldInfo = new FieldInfo[this.fieldsCount];
        for (int i = 0; i < this.fieldsCount; ++i) {
            short accessFlags = in.readShort();
            short nameIndex = in.readShort();
            short descriptorIndex = in.readShort();
            Attribute[] attribute = Attribute.readAttributeArray(in);
            this.fieldInfo[i] = new FieldInfo(accessFlags, nameIndex, descriptorIndex, attribute);
        }
    }

    private void readMethodsInfo(DataInputStream in) throws IOException {
        this.methodsCount = in.readShort();
        this.methodInfo = new MethodInfo[this.methodsCount];
        for (int i = 0; i < this.fieldsCount; ++i) {
            short accessFlags = in.readShort();
            short nameIndex = in.readShort();
            short descriptorIndex = in.readShort();
            Attribute[] attribute = Attribute.readAttributeArray(in);
            this.methodInfo[i] = new MethodInfo(accessFlags, nameIndex, descriptorIndex, attribute);
        }
    }
}

