/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.server.ApplicationServer;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import oracle.dms.instrument.StateIntf;
import oracle.oc4j.admin.jmx.exceptions.InvalidArgumentValueException;

public abstract class Pool {
    protected int min;
    protected int max;
    protected int waitingForInstance = 0;
    protected long maxWaitMilliSecond = 0L;
    protected long poolTimeout;
    private StateIntf pooledCount;
    private StateIntf readyCount;
    private int pooledCount_int = 0;
    private int readyCount_int = 0;
    private int highwaterCount_int = 0;
    protected LinkedList pool = new LinkedList();
    boolean autoExpired = false;

    public Pool(int _min, int _max, long _maxWaitMilliSecond, long _poolTimeout) {
        this.min = _min;
        this.max = _max;
        this.maxWaitMilliSecond = _maxWaitMilliSecond;
        this.poolTimeout = _poolTimeout * 1000L;
        if (this.max > 0 && this.max < this.min) {
            this.min = this.max;
        }
        if (this.min < 0) {
            this.min = 0;
        }
    }

    public void setDMSSensors(StateIntf _pooledCount, StateIntf _readyCount) {
        this.pooledCount = _pooledCount;
        this.readyCount = _readyCount;
    }

    public Object getContext() {
        Object _context;
        if (this.skipPooling()) {
            _context = this.getContextFromBackend();
        } else {
            _context = this.getContextFromPool();
            if (_context == null) {
                _context = this.getContextFromBackend();
            }
        }
        this.beforePassToClient(_context);
        this.readyCount_incr(1);
        return _context;
    }

    public void releaseContext(Object context, boolean toBeDiscarded) {
        this.readyCount_incr(-1);
        this.afterRecvContextFromClient(context, toBeDiscarded);
        if (this.skipPooling() || toBeDiscarded || this.boundPooling() && this.pooledCount_int + this.readyCount_int >= this.max) {
            this.releaseContextToBackend(context, toBeDiscarded);
            return;
        }
        this.addToPool(context);
    }

    private boolean skipPooling() {
        return this.max < 0;
    }

    private boolean boundPooling() {
        return this.max != 0;
    }

    public void onMinInstanceUpdate() {
        int total;
        if (this.skipPooling()) {
            this.reduceBeanInstances(this.pooledCount_int);
            return;
        }
        for (int i = total = this.readyCount_int + this.pooledCount_int; i < this.min; ++i) {
            Object _context = this.getContextFromBackend();
            this.addToPool(_context);
        }
    }

    public synchronized void onMaxInstanceUpdate() {
        if (!this.boundPooling()) {
            return;
        }
        if (this.skipPooling()) {
            this.reduceBeanInstances(this.pooledCount_int);
        } else {
            int total = this.readyCount_int + this.pooledCount_int;
            if (total > this.max) {
                int delta = total - this.max;
                this.reduceBeanInstances(delta > this.pooledCount_int ? this.pooledCount_int : delta);
            }
        }
    }

    private void reduceBeanInstances(int reduced) {
        for (int i = 0; i < reduced; ++i) {
            Object _context = this.removeFromPool();
            this.releaseContextToBackend(_context, false);
        }
    }

    protected RuntimeException getTimeoutException() {
        return new IllegalStateException("timeout expired waiting for an instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getContextFromPool() {
        Object _context = null;
        long newCallTimeout = this.maxWaitMilliSecond;
        while (true) {
            block12: {
                if (this.pooledCount_int > 0) {
                    return this.removeFromPool();
                }
                if (this.max <= 0) return _context;
                if (this.readyCount_int < this.max) {
                    return _context;
                }
                Pool pool = this;
                synchronized (pool) {
                    Object var9_6;
                    long startTime = System.currentTimeMillis();
                    try {
                        block11: {
                            try {
                                ++this.waitingForInstance;
                                if (newCallTimeout < 0L) break block11;
                                this.wait(newCallTimeout);
                            }
                            catch (InterruptedException e) {
                                var9_6 = null;
                                --this.waitingForInstance;
                                if (this.maxWaitMilliSecond > 0L && (newCallTimeout = this.maxWaitMilliSecond - (System.currentTimeMillis() - startTime)) <= 0L) {
                                    throw this.getTimeoutException();
                                }
                                break block12;
                            }
                        }
                        var9_6 = null;
                        --this.waitingForInstance;
                        if (this.maxWaitMilliSecond <= 0L) break block12;
                    }
                    catch (Throwable throwable) {
                        var9_6 = null;
                        --this.waitingForInstance;
                        if (this.maxWaitMilliSecond <= 0L) throw throwable;
                        newCallTimeout = this.maxWaitMilliSecond - (System.currentTimeMillis() - startTime);
                        if (newCallTimeout > 0L) throw throwable;
                        throw this.getTimeoutException();
                    }
                    newCallTimeout = this.maxWaitMilliSecond - (System.currentTimeMillis() - startTime);
                    if (newCallTimeout <= 0L) {
                        throw this.getTimeoutException();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPool(Object _context) {
        PooledContext entry = new PooledContext();
        entry.context = _context;
        if (this.isAutoExpired()) {
            entry.poolTime = System.currentTimeMillis();
        }
        this.pooledCount_incr(1);
        Pool pool = this;
        synchronized (pool) {
            this.pool.add(entry);
            if (this.waitingForInstance > 0) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeFromPool() {
        PooledContext entry = null;
        try {
            Pool pool = this;
            synchronized (pool) {
                entry = (PooledContext)this.pool.removeFirst();
            }
        }
        catch (NoSuchElementException e) {
            return null;
        }
        this.pooledCount_incr(-1);
        return entry.context;
    }

    private boolean isAutoExpired() {
        return this.autoExpired;
    }

    public void setAutoExpired(boolean b) {
        this.autoExpired = b;
    }

    public synchronized void expirePool() {
        if (!this.isAutoExpired()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        while (this.pooledCount_int > this.min) {
            PooledContext entry = (PooledContext)this.pool.getFirst();
            if (currentTime - entry.poolTime <= this.poolTimeout) break;
            this.removeFromPool();
        }
    }

    protected abstract Object getContextFromBackend();

    protected abstract void releaseContextToBackend(Object var1, boolean var2);

    protected void beforePassToClient(Object context) {
    }

    protected void afterRecvContextFromClient(Object context, boolean toBeDiscarded) {
    }

    public void setMaxInstance(int _newMax) throws InvalidArgumentValueException {
        if (_newMax > 0 && _newMax < this.min) {
            throw new InvalidArgumentValueException("new max less than min", "MinInstance");
        }
        if (this.max != _newMax) {
            this.max = _newMax;
            this.onMaxInstanceUpdate();
        }
    }

    public int getMaxInstance() {
        return this.max;
    }

    public void setMinInstance(int _newMin) throws InvalidArgumentValueException {
        if (!this.skipPooling() && this.boundPooling() && _newMin > this.max) {
            throw new InvalidArgumentValueException("new min greater than max", "MaxInstance");
        }
        if (this.min != _newMin) {
            this.min = _newMin;
            this.onMinInstanceUpdate();
        }
    }

    public int getMinInstance() {
        return this.min;
    }

    public int getNumberOfInstanceUsed() {
        return this.readyCount_int;
    }

    public int getNumberOfInstancePooled() {
        return this.pooledCount_int;
    }

    public int getReadyCountHighWaterMark() {
        return this.highwaterCount_int;
    }

    private void readyCount_incr(int _incr) {
        this.readyCount_int += _incr;
        if (this.readyCount_int > this.highwaterCount_int) {
            this.highwaterCount_int = this.readyCount_int;
        }
        if (ApplicationServer.DMS_GATE && this.readyCount != null) {
            this.readyCount.increment(_incr);
        }
    }

    private void pooledCount_incr(int _incr) {
        this.pooledCount_int += _incr;
        if (ApplicationServer.DMS_GATE && this.pooledCount != null) {
            this.pooledCount.increment(_incr);
        }
    }

    protected static class PooledContext {
        Object context;
        long poolTime;

        protected PooledContext() {
        }
    }
}

