/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.util;

import com.evermind.util.ByteString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ClassUtils {
    public static final Class[] CLASS_NOARGS = new Class[0];
    private static Map primitiveMap;

    public static Map createPrimitiveMap() {
        HashMap<Class<Serializable>, Class> primitiveMap = new HashMap<Class<Serializable>, Class>();
        primitiveMap.put(Integer.TYPE, Integer.class);
        primitiveMap.put(Float.TYPE, Float.class);
        primitiveMap.put(Long.TYPE, Long.class);
        primitiveMap.put(Double.TYPE, Double.class);
        primitiveMap.put(Boolean.TYPE, Boolean.class);
        primitiveMap.put(Byte.TYPE, Byte.class);
        primitiveMap.put(Character.TYPE, Character.class);
        primitiveMap.put(Short.TYPE, Short.class);
        return primitiveMap;
    }

    public static String getPrimitiveTypeName(Class type) {
        if (type == Integer.TYPE) {
            return "java.lang.Integer.TYPE";
        }
        if (type == Float.TYPE) {
            return "java.lang.Float.TYPE";
        }
        if (type == Long.TYPE) {
            return "java.lang.Long.TYPE";
        }
        if (type == Double.TYPE) {
            return "java.lang.Double.TYPE";
        }
        if (type == Boolean.TYPE) {
            return "java.lang.Boolean.TYPE";
        }
        if (type == Byte.TYPE) {
            return "java.lang.Byte.TYPE";
        }
        if (type == Character.TYPE) {
            return "java.lang.Character.TYPE";
        }
        if (type == Short.TYPE) {
            return "java.lang.Short.TYPE";
        }
        return "THIS_IS_NOT_POSSIBLE";
    }

    public static Class getPrimitiveType(Class type) {
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        return type;
    }

    public static Class getNonPrimitiveType(Class type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        return type;
    }

    public static boolean equalsIgnorePrimitive(Class a, Class b) {
        if (a.equals(b)) {
            return true;
        }
        if (primitiveMap == null) {
            primitiveMap = ClassUtils.createPrimitiveMap();
        }
        return primitiveMap.get(a) == b || primitiveMap.get(b) == a;
    }

    public static String getConvertSource(String variable, Class from, Class to) {
        if (from == to || to.isAssignableFrom(from)) {
            return variable;
        }
        if (to == Integer.TYPE) {
            if (Number.class.isAssignableFrom(from)) {
                return variable + ".intValue()";
            }
            return "(" + variable + " instanceof Integer ? ((Integer)" + variable + ").intValue() : Integer.parseInt(" + variable + ".toString()))";
        }
        if (to == Float.TYPE) {
            if (Number.class.isAssignableFrom(from)) {
                return variable + ".floatValue()";
            }
            return "(" + variable + " instanceof Float ? ((Float)" + variable + ").floatValue() : Float.parseFloat(" + variable + ".toString()))";
        }
        if (to == Long.TYPE) {
            if (Number.class.isAssignableFrom(from)) {
                return variable + ".longValue()";
            }
            return "(" + variable + " instanceof Long ? ((Long)" + variable + ").longValue() : Long.parseLong(" + variable + ".toString()))";
        }
        if (to == Double.TYPE) {
            if (Number.class.isAssignableFrom(from)) {
                return variable + ".doubleValue()";
            }
            return "(" + variable + " instanceof Double ? ((Double)" + variable + ").doubleValue() : Double.parseDouble(" + variable + ".toString()))";
        }
        if (to == Byte.TYPE) {
            if (Number.class.isAssignableFrom(from)) {
                return variable + ".byteValue()";
            }
            return "(" + variable + " instanceof Byte ? ((Byte)" + variable + ").byteValue() : Byte.parseByte(" + variable + ".toString()))";
        }
        if (to == Character.TYPE) {
            if (Character.class.isAssignableFrom(from)) {
                return variable + ".charValue()";
            }
            return "(" + variable + " instanceof Character ? ((Character)" + variable + ").charValue() : (char)Integer.parseInt(" + variable + ".toString()))";
        }
        if (to == Short.TYPE) {
            if (Number.class.isAssignableFrom(from)) {
                return variable + ".shortValue()";
            }
            return "(" + variable + " instanceof Short ? ((Short)" + variable + ").shortValue() : Short.parseShort(" + variable + ".toString()))";
        }
        if (to == Boolean.TYPE) {
            if (Boolean.class.isAssignableFrom(from)) {
                return variable + ".booleanValue()";
            }
            return "(" + variable + " instanceof Boolean ? ((Boolean)" + variable + ").booleanValue() : Boolean.valueOf(" + variable + ".toString()).booleanValue())";
        }
        if (to == Integer.class) {
            if (from.isPrimitive() && from != Boolean.TYPE) {
                return "new Integer((int)" + variable + ")";
            }
            if (from == Boolean.TYPE) {
                return "new Integer(" + variable + " ? 1 : 0)";
            }
            return "(" + variable + " instanceof Integer ? (Integer)" + variable + " : new Integer(" + variable + ".toString()))";
        }
        if (to == Float.class) {
            if (from.isPrimitive() && from != Boolean.TYPE) {
                return "new Float((float)" + variable + ")";
            }
            if (from == Boolean.TYPE) {
                return "new Float(" + variable + " ? 1f : 0f)";
            }
            return "(" + variable + " instanceof Float ? (Float)" + variable + " : new Float(" + variable + ".toString()))";
        }
        if (to == Long.class) {
            if (from.isPrimitive() && from != Boolean.TYPE) {
                return "new Long((long)" + variable + ")";
            }
            if (from == Boolean.TYPE) {
                return "new Long(" + variable + " ? 1l : 0l)";
            }
            return "(" + variable + " instanceof Long ? (Long)" + variable + " : new Long(" + variable + ".toString()))";
        }
        if (to == Double.class) {
            if (from.isPrimitive() && from != Boolean.TYPE) {
                return "new Double((double)" + variable + ")";
            }
            if (from == Boolean.TYPE) {
                return "new Double(" + variable + " ? 1d : 0d)";
            }
            return "(" + variable + " instanceof Double ? (Double)" + variable + " : new Double(" + variable + ".toString()))";
        }
        if (to == Byte.class) {
            if (from.isPrimitive() && from != Boolean.TYPE) {
                return "new Byte((byte)" + variable + ")";
            }
            if (from == Boolean.TYPE) {
                return "new Byte(" + variable + " ? (byte)1 : (byte)0)";
            }
            return "(" + variable + " instanceof Byte ? (Byte)" + variable + " : new Byte(" + variable + ".toString()))";
        }
        if (to == Character.class) {
            if (from.isPrimitive() && from != Boolean.TYPE) {
                return "new Character((char)" + variable + ")";
            }
            if (from == Boolean.TYPE) {
                return "new Character(" + variable + " ? (char)1 : (char)0)";
            }
            return "(" + variable + " instanceof Character ? (Character)" + variable + " : new Character((char)" + variable + ".toString()))";
        }
        if (to == Short.class) {
            if (from.isPrimitive() && from != Boolean.TYPE) {
                return "new Short((short)" + variable + ")";
            }
            if (from == Boolean.TYPE) {
                return "new Short(" + variable + " ? (short)1 : (short)0)";
            }
            return "(" + variable + " instanceof Short ? (Short)" + variable + " : new Short(" + variable + ".toString()))";
        }
        if (to == Boolean.class) {
            if (from.isPrimitive() && from != Boolean.TYPE) {
                return "(" + variable + " == 0 ? Boolean.FALSE : Boolean.TRUE)";
            }
            if (from == Boolean.TYPE) {
                return "(" + variable + " ? Boolean.TRUE : Boolean.FALSE)";
            }
            return "(" + variable + " instanceof Boolean ? (Boolean)" + variable + " : Boolean.valueOf(" + variable + ".toString()))";
        }
        throw new IllegalArgumentException("Cannot convert from " + from + " to " + to);
    }

    public static Class findClass(String name, ClassLoader loader) throws ClassNotFoundException {
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        return Class.forName(name, true, loader);
    }

    public static String getDefaultValue(Class theClass) {
        if (theClass.isPrimitive() && !theClass.isArray()) {
            if (theClass == Boolean.TYPE) {
                return "false";
            }
            if (theClass == Float.TYPE) {
                return "0.0f";
            }
            if (theClass == Double.TYPE) {
                return "0.0d";
            }
            return "0";
        }
        return "null";
    }

    public static String getReadStream(String variable, Class cls, String stream) {
        String ret = new String();
        ret = cls == Integer.class ? variable + " new Integer(" + stream + "." + "readInt())" : (cls == Float.class ? variable + " new Float(" + stream + "." + "readFloat())" : (cls == Long.class ? variable + " new Long(" + stream + "." + "readLong())" : (cls == Double.class ? variable + " new Double(" + stream + "." + "readDouble())" : (cls == Byte.class ? variable + " new Byte(" + stream + "." + "readByte())" : (cls == Character.class ? variable + " new Character(" + stream + "." + "readChar())" : (cls == Short.class ? variable + " new Short(" + stream + "." + "readShort())" : (cls == Boolean.class ? variable + " new Boolean(" + stream + "." + "readBoolean())" : (cls == String.class ? variable + " new String(" + stream + "." + "readUTF())" : variable + " new Float(" + stream + "." + "readInt())"))))))));
        return ret;
    }

    public static String getWriteStream(String variable, Class cls, String stream) {
        String ret = new String();
        ret = cls == Integer.class ? stream + "." + "writeInt(" + variable + ".intValue())" : (cls == Float.class ? stream + "." + "writeFloat(" + variable + ".floatValue())" : (cls == Long.class ? stream + "." + "writeLong(" + variable + ".longValue())" : (cls == Double.class ? stream + "." + "writeDouble(" + variable + ".doubleValue())" : (cls == Byte.class ? stream + "." + "writeByte(" + variable + ".byteValue())" : (cls == Character.class ? stream + "." + "writeChar(" + variable + ".charValue())" : (cls == Short.class ? stream + "." + "writeShort(" + variable + ".shortValue())" : (cls == Boolean.class ? stream + "." + "writeBoolean(" + variable + ".booleanValue())" : (cls == String.class ? stream + "." + "writeUTF(" + variable + ")" : stream + "." + "writeObject(" + variable + ")"))))))));
        return ret;
    }

    public static String getCodedNotation(String className) {
        StringBuffer result = new StringBuffer();
        ClassUtils.appendCodedNotation(result, className);
        return result.toString();
    }

    public static ByteString getCodedNotation(ByteString className) {
        return ClassUtils.getCodedNotation(className, true);
    }

    public static ByteString getCodedNotation(ByteString className, boolean appendPadding) {
        if (className.length > 0 && className.data[className.offset] == 91) {
            return className.replace('.', '/');
        }
        int pos = className.offset + className.length;
        int dimensions = 0;
        while (pos >= className.offset + 2 && className.data[pos - 1] == 93 && className.data[pos - 2] == 91) {
            pos -= 2;
            ++dimensions;
        }
        if (dimensions > 0) {
            ByteString prefix = new ByteString(new byte[dimensions]);
            for (int i = 0; i < dimensions; ++i) {
                prefix.data[i] = 91;
            }
            return prefix.concat(ClassUtils.getCodedNotation(className.substring(0, className.length - dimensions * 2)));
        }
        if (className.equals("int")) {
            return new ByteString(73);
        }
        if (className.equals("float")) {
            return new ByteString(70);
        }
        if (className.equals("double")) {
            return new ByteString(68);
        }
        if (className.equals("long")) {
            return new ByteString(74);
        }
        if (className.equals("boolean")) {
            return new ByteString(90);
        }
        if (className.equals("byte")) {
            return new ByteString(66);
        }
        if (className.equals("void")) {
            return new ByteString(86);
        }
        if (className.equals("char")) {
            return new ByteString(67);
        }
        if (className.equals("short")) {
            return new ByteString(83);
        }
        if (!appendPadding) {
            return ((ByteString)className.clone()).replace('.', '/');
        }
        ByteString string = new ByteString(new byte[className.length + 2]);
        string.data[string.offset] = 76;
        string.data[string.offset + string.length - 1] = 59;
        for (int i = 0; i < className.length; ++i) {
            string.data[1 + i] = className.data[className.offset + i];
            if (string.data[1 + i] != 46) continue;
            string.data[1 + i] = 47;
        }
        return string;
    }

    public static void appendCodedNotation(StringBuffer result, String className) {
        if (className.startsWith("[")) {
            result.append(className.replace('.', '/'));
        } else {
            while (className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
                result.append("[");
            }
            if (className.equals("int")) {
                result.append("I");
            } else if (className.equals("float")) {
                result.append("F");
            } else if (className.equals("double")) {
                result.append("D");
            } else if (className.equals("long")) {
                result.append("J");
            } else if (className.equals("boolean")) {
                result.append("Z");
            } else if (className.equals("byte")) {
                result.append("B");
            } else if (className.equals("void")) {
                result.append("V");
            } else if (className.equals("char")) {
                result.append("C");
            } else if (className.equals("short")) {
                result.append("S");
            } else {
                result.append("L");
                result.append(className.replace('.', '/'));
                result.append(";");
            }
        }
    }

    public static String getCodedArguments(Method method) {
        return ClassUtils.getCodedArguments(method.getParameterTypes(), method.getReturnType());
    }

    public static String getCodedArguments(Class[] args, Class returnType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        for (int i = 0; i < args.length; ++i) {
            ClassUtils.appendCodedNotation(buffer, args[i].getName());
        }
        buffer.append(")");
        if (returnType == Void.TYPE) {
            buffer.append("V");
        } else {
            ClassUtils.appendCodedNotation(buffer, returnType.getName());
        }
        return buffer.toString();
    }

    public static String getClassNameFromSourceNotation(Class theClass, int arrayOffset) {
        return ClassUtils.getSourceNotation(theClass.getName(), arrayOffset, true);
    }

    public static String getClassNameFromSourceNotation(String className, int arrayOffset) {
        return ClassUtils.getSourceNotation(className, arrayOffset, true);
    }

    public static String getSourceNotation(Class theClass, int arrayOffset) {
        return ClassUtils.getSourceNotation(theClass.getName(), arrayOffset, false);
    }

    public static String getSourceNotation(String className, int arrayOffset) {
        return ClassUtils.getSourceNotation(className, arrayOffset, false);
    }

    public static String getSourceNotation(String className, int arrayOffset, boolean changeAnyDollarToDot) {
        int parseIndex = 0;
        while (className.indexOf(91, parseIndex) >= 0) {
            ++parseIndex;
            ++arrayOffset;
        }
        StringBuffer sourceNotation = new StringBuffer();
        if ((className = className.substring(parseIndex)).equals("I")) {
            sourceNotation.append("int");
        } else if (className.equals("J")) {
            sourceNotation.append("long");
        } else if (className.equals("Z")) {
            sourceNotation.append("boolean");
        } else if (className.equals("S")) {
            sourceNotation.append("short");
        } else if (className.equals("F")) {
            sourceNotation.append("float");
        } else if (className.equals("D")) {
            sourceNotation.append("double");
        } else if (className.equals("C")) {
            sourceNotation.append("char");
        } else if (className.equals("B")) {
            sourceNotation.append("byte");
        } else if (className.equals("V")) {
            sourceNotation.append("void");
        } else {
            if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                className = className.substring(1, className.length() - 1).replace('/', '.');
            }
            if (changeAnyDollarToDot) {
                className = className.replace('$', '.');
            }
            sourceNotation.append(className);
        }
        while (arrayOffset-- > 0) {
            sourceNotation.append("[]");
        }
        return sourceNotation.toString();
    }

    public static Class getArrayInstance(Class theClass, int arrayOffset) {
        String className = theClass.getName();
        if (arrayOffset < 0) {
            if (className.charAt((arrayOffset = -arrayOffset) - 1) != '[') {
                throw new IllegalArgumentException("invalid array instance");
            }
            try {
                className = className.substring(arrayOffset);
                if (className.equals("I")) {
                    return Integer.TYPE;
                }
                if (className.equals("J")) {
                    return Long.TYPE;
                }
                if (className.equals("Z")) {
                    return Boolean.TYPE;
                }
                if (className.equals("S")) {
                    return Short.TYPE;
                }
                if (className.equals("F")) {
                    return Float.TYPE;
                }
                if (className.equals("D")) {
                    return Double.TYPE;
                }
                if (className.equals("C")) {
                    return Character.TYPE;
                }
                if (className.equals("B")) {
                    return Byte.TYPE;
                }
                if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
                    className = className.substring(1, className.length() - 1);
                }
                return Class.forName(className, true, theClass.getClassLoader());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Class not found: " + className);
            }
        }
        StringBuffer buffer = new StringBuffer();
        while (arrayOffset-- > 0) {
            buffer.append('[');
        }
        buffer.append(className);
        try {
            return Class.forName(className.substring(arrayOffset), true, theClass.getClassLoader());
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public static Object getInstance(String name, ClassLoader loader) {
        try {
            Class<?> theClass = Class.forName(name, true, loader);
            return theClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getParams(String codedNotation) {
        int end = codedNotation.lastIndexOf(41);
        if (end < 0) {
            throw new IllegalArgumentException("Invalid coded notation: " + codedNotation);
        }
        return ClassUtils.getStandaloneParams(codedNotation.substring(1, end));
    }

    public static String getStandaloneParams(String codedNotation) {
        int lastPos = 0;
        int pos = 0;
        int end = codedNotation.length();
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        if (end < 0) {
            throw new IllegalArgumentException("Invalid coded notation: " + codedNotation);
        }
        while (pos < end) {
            if (codedNotation.charAt(pos) == '[') {
                ++pos;
                continue;
            }
            if (codedNotation.charAt(pos) == 'L') {
                while (pos < end && codedNotation.charAt(pos) != ';') {
                    ++pos;
                }
            }
            String arg = codedNotation.substring(lastPos, pos + 1);
            if (!first) {
                buffer.append(", ");
            }
            first = false;
            buffer.append(ClassUtils.getSourceNotation(arg, 0));
            lastPos = ++pos;
        }
        return buffer.toString();
    }

    public static String getNonPrimitiveName(String name) {
        if (name.equals("int")) {
            return "java.lang.Integer";
        }
        if (name.equals("byte")) {
            return "java.lang.Byte";
        }
        if (name.equals("char")) {
            return "java.lang.Character";
        }
        if (name.equals("short")) {
            return "java.lang.Short";
        }
        if (name.equals("float")) {
            return "java.lang.Float";
        }
        if (name.equals("long")) {
            return "java.lang.Long";
        }
        if (name.equals("double")) {
            return "java.lang.Double";
        }
        if (name.equals("boolean")) {
            return "java.lang.Boolean";
        }
        return name;
    }

    public static String getComparationExpression(String nameA, String nameB, String[] fieldNames, Class[] types) {
        if (fieldNames.length == 0) {
            return "true";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Class type = types[i];
            if (i != 0) {
                buffer.append(" && ");
            }
            if (type != null && type.isPrimitive() && !type.isArray()) {
                buffer.append(nameA + fieldName + " == " + nameB + fieldName);
                continue;
            }
            buffer.append("((" + nameA + fieldName + " == null && " + nameB + fieldName + " == null) || (" + nameA + fieldName + " != null && " + nameB + fieldName + " != null && " + nameA + fieldName + ".equals(" + nameB + fieldName + ")))");
        }
        return buffer.toString();
    }

    public static String getHashCodeExpression(String name, String[] fieldNames, Class[] types) {
        if (fieldNames.length == 0) {
            return "0";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < fieldNames.length; ++i) {
            if (i != 0) {
                buffer.append(" + ");
            }
            String fieldName = fieldNames[i];
            Class type = types[i];
            if (type != null && type.isPrimitive() && !type.isArray()) {
                if (type == Boolean.TYPE) {
                    buffer.append("(" + name + fieldName + " ? 1 : 0)");
                    continue;
                }
                buffer.append("(int)" + name + fieldName);
                continue;
            }
            buffer.append("(" + name + fieldName + " == null ? 0 : " + name + fieldName + ".hashCode())");
        }
        return buffer.toString();
    }

    public static void appendArgumentList(StringBuffer reply, Class[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                reply.append(", ");
            }
            reply.append(ClassUtils.getSourceNotation(arguments[i], 0));
        }
    }

    public static String javaJoin(String a, String b) {
        if (a.length() == 0) {
            return b;
        }
        if (b.length() == 0) {
            return a;
        }
        return a + Character.toUpperCase(b.charAt(0)) + b.substring(1, b.length());
    }

    public static ByteString indent(ByteString source) {
        try {
            String line;
            char[] indentionRuler = new char[40];
            Arrays.fill(indentionRuler, '\t');
            int currentIndentionLevel = 0;
            boolean pos = false;
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(byteOut));
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(source.data, source.offset, source.length)));
            while ((line = reader.readLine()) != null) {
                if (line.endsWith("}") && currentIndentionLevel > 0) {
                    --currentIndentionLevel;
                }
                while (currentIndentionLevel >= indentionRuler.length) {
                    indentionRuler = new char[indentionRuler.length * 2];
                    Arrays.fill(indentionRuler, '\t');
                }
                writer.write(indentionRuler, 0, currentIndentionLevel);
                writer.println(line);
                if (!line.endsWith("{")) continue;
                ++currentIndentionLevel;
            }
            writer.flush();
            return new ByteString(byteOut.toByteArray());
        }
        catch (IOException e) {
            return source;
        }
    }

    public static Class getEncodedType(String name, ClassLoader loader) throws ClassNotFoundException {
        char c = name.charAt(0);
        switch (c) {
            case '[': {
                return Class.forName(name, true, loader);
            }
            case 'L': {
                return Class.forName(name.substring(1).replace('/', '.'), true, loader);
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        throw new IllegalArgumentException("Malformed classname");
    }

    public static boolean containsType(Class[] types, Class type) {
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean signatureEquals(Method a, Method b) {
        Class<?>[] bParameters;
        Class<?>[] aParameters;
        if (a.getName().equals(b.getName()) && a.getReturnType() == b.getReturnType() && (aParameters = a.getParameterTypes()).length == (bParameters = b.getParameterTypes()).length) {
            for (int i = 0; i < aParameters.length; ++i) {
                if (aParameters[i] == bParameters[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String convertFromPrimitive(String _classNm, String _variable) {
        if (_classNm.equals("boolean")) {
            return "new Boolean(" + _variable + ")";
        }
        if (_classNm.equals("char")) {
            return "new Character(" + _variable + ")";
        }
        if (_classNm.equals("byte")) {
            return "new Byte(" + _variable + ")";
        }
        if (_classNm.equals("short")) {
            return "new Short(" + _variable + ")";
        }
        if (_classNm.equals("int")) {
            return "new Integer(" + _variable + ")";
        }
        if (_classNm.equals("long")) {
            return "new Long(" + _variable + ")";
        }
        if (_classNm.equals("float")) {
            return "new Float(" + _variable + ")";
        }
        if (_classNm.equals("double")) {
            return "new Double(" + _variable + ")";
        }
        throw new IllegalArgumentException(_classNm + " is not a primitive type");
    }
}

