/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.sql;

import com.evermind.sql.SerializableRowSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.sql.RowSet;
import javax.sql.RowSetListener;

public class SerializableRowSet
implements RowSet,
Serializable {
    private SerializableRowSetMetaData metaData;
    private int currentRow = -1;
    private int length;
    private Object[] columns;
    private String command;
    private String dataSourceName;
    private Map typeMap;
    private int maxRows = -1;
    private int maxFieldSize = -1;
    private int queryTimeout = -1;
    private int transactionIsolation = -1;
    private String password;
    private String username;
    private boolean escapeProcessing;
    private int type = -1;
    private String url;
    public static final long serialVersionUID = 2676799332747648089L;

    public SerializableRowSet(ResultSet set, String command, String dataSourceName, Map typeMap) throws SQLException {
        this.command = command;
        this.dataSourceName = dataSourceName;
        this.typeMap = typeMap;
        this.init(set);
    }

    public void init(ResultSet set) throws SQLException {
        int i;
        this.metaData = new SerializableRowSetMetaData(this, set.getMetaData());
        List[] columnContents = new List[this.metaData.columnData.length];
        for (i = 0; i < columnContents.length; ++i) {
            columnContents[i] = new ArrayList();
        }
        while (set.next()) {
            for (i = 0; i < columnContents.length; ++i) {
                columnContents[i].add(set.getObject(i + 1));
            }
            ++this.length;
        }
        this.columns = new Object[columnContents.length];
        for (i = 0; i < this.columns.length; ++i) {
            this.columns[i] = columnContents[i].toArray();
        }
    }

    public void clearParameters() {
    }

    public int findColumn(String name) throws SQLException {
        for (int i = 0; i < this.metaData.columnData.length; ++i) {
            if (!this.metaData.columnData[i].name.equals(name)) continue;
            return i + 1;
        }
        throw new SQLException("No such column: " + name);
    }

    public void setTypeMap(Map map) {
        this.typeMap = map;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public int getTransactionIsolation() {
        return -1;
    }

    public Map getTypeMap() {
        return this.typeMap;
    }

    public boolean getEscapeProcessing() {
        return this.escapeProcessing;
    }

    public void setEscapeProcessing(boolean process) {
        this.escapeProcessing = process;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int maxFieldSize) {
        this.maxFieldSize = maxFieldSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int rows) {
        this.maxRows = rows;
    }

    public void addRowSetListener(RowSetListener listener) {
    }

    public void execute() {
    }

    public String getCommand() {
        return this.command;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    public void moveToInsertRow() throws SQLException {
        this.currentRow = this.length;
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public int getType() throws SQLException {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setTransactionIsolation(int isolation) {
        this.transactionIsolation = isolation;
    }

    public void insertRow() throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("Not supported");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Not supported");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("Not supported");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("Not supported");
    }

    public boolean absolute(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateNull(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateInt(int pos, int value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateInt(String field, int value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateShort(int pos, short value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateShort(String field, short value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateBytes(int pos, byte[] data) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateTime(int pos, Time time) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateString(int pos, String string) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateAsciiStream(int pos, InputStream stream, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateBinaryStream(int pos, InputStream stream, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateCharacterStream(int pos, Reader in, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateObject(int pos, Object object, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateObject(int pos, Object object) throws SQLException {
        throw new SQLException("Not supported");
    }

    public java.sql.Array getArray(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateBigDecimal(int pos, BigDecimal decimal) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateTimestamp(int pos, Timestamp timestamp) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateDate(int pos, Date date) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateByte(int pos, byte value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateFloat(int pos, float value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateDouble(int pos, double value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateLong(int pos, long value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateBoolean(int pos, boolean value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public int getRow() throws SQLException {
        return this.currentRow;
    }

    public boolean first() throws SQLException {
        this.currentRow = 0;
        return true;
    }

    public boolean previous() throws SQLException {
        if (this.currentRow > 0) {
            --this.currentRow;
        }
        return true;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.currentRow < 0;
    }

    public boolean isFirst() throws SQLException {
        return this.currentRow == 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.currentRow >= this.length;
    }

    public void beforeFirst() throws SQLException {
        this.currentRow = -1;
    }

    public void afterLast() throws SQLException {
        this.currentRow = this.length;
    }

    public boolean last() throws SQLException {
        this.currentRow = this.length - 1;
        return true;
    }

    public boolean next() throws SQLException {
        ++this.currentRow;
        return this.currentRow < this.length;
    }

    public boolean isLast() throws SQLException {
        return this.currentRow == this.length - 1;
    }

    public boolean relative(int type) throws SQLException {
        return false;
    }

    public void setFetchSize(int size) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return 1;
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("Not supported");
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getConcurrency() throws SQLException {
        return -1;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public Date getDate(int pos) throws SQLException {
        return (Date)this.getObject(pos);
    }

    public Time getTime(int pos) throws SQLException {
        return (Time)this.getObject(pos);
    }

    public Date getDate(String field) throws SQLException {
        return this.getDate(this.findColumn(field));
    }

    public Time getTime(String field) throws SQLException {
        return this.getTime(this.findColumn(field));
    }

    public byte[] getBytes(int pos) throws SQLException {
        return (byte[])this.getObject(pos);
    }

    public byte[] getBytes(String field) throws SQLException {
        return this.getBytes(this.findColumn(field));
    }

    public Object getObject(int pos) throws SQLException {
        this.verify(pos);
        Object column = this.columns[pos - 1];
        return Array.get(column, this.currentRow);
    }

    public Object getObject(int pos, Map map) throws SQLException {
        return this.getObject(pos);
    }

    public Object getObject(String field, Map map) throws SQLException {
        return this.getObject(field);
    }

    public Object getObject(String field) throws SQLException {
        return this.getObject(field);
    }

    public String getString(int pos) throws SQLException {
        Object object = this.getObject(pos);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public URL getURL(String name) throws SQLException {
        return this.getURL(this.findColumn(name));
    }

    public URL getURL(int pos) throws SQLException {
        Object object = this.getObject(pos);
        if (object instanceof URL) {
            return (URL)object;
        }
        if (object != null) {
            try {
                return new URL(object.toString());
            }
            catch (MalformedURLException e) {
                throw new SQLException("Malformed URL stored in the column: " + e.getMessage());
            }
        }
        return null;
    }

    public Timestamp getTimestamp(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public InputStream getAsciiStream(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public InputStream getUnicodeStream(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public InputStream getBinaryStream(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public byte getByte(int pos) throws SQLException {
        this.verify(pos);
        Object column = this.columns[pos - 1];
        if (column instanceof byte[]) {
            return ((byte[])column)[this.currentRow];
        }
        return Byte.parseByte(((Object[])column)[this.currentRow].toString());
    }

    public long getLong(int pos) throws SQLException {
        this.verify(pos);
        Object column = this.columns[pos - 1];
        if (column instanceof long[]) {
            return ((long[])column)[this.currentRow];
        }
        return Long.parseLong(((Object[])column)[this.currentRow].toString());
    }

    public short getShort(int pos) throws SQLException {
        this.verify(pos);
        Object column = this.columns[pos - 1];
        if (column instanceof short[]) {
            return ((short[])column)[this.currentRow];
        }
        return Short.parseShort(((Object[])column)[this.currentRow].toString());
    }

    public BigDecimal getBigDecimal(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public BigDecimal getBigDecimal(int pos, int pos2) throws SQLException {
        throw new SQLException("Not supported");
    }

    public float getFloat(int pos) throws SQLException {
        this.verify(pos);
        Object column = this.columns[pos - 1];
        if (column instanceof float[]) {
            return ((float[])column)[this.currentRow];
        }
        return Float.parseFloat(((Object[])column)[this.currentRow].toString());
    }

    public double getDouble(int pos) throws SQLException {
        this.verify(pos);
        Object column = this.columns[pos - 1];
        if (column instanceof double[]) {
            return ((double[])column)[this.currentRow];
        }
        return Double.parseDouble(((Object[])column)[this.currentRow].toString());
    }

    protected void verify(int pos) throws SQLException {
        if (--pos < 0 || pos >= this.columns.length) {
            throw new SQLException("Invalid column");
        }
        if (this.currentRow < 0 || this.currentRow >= this.length) {
            throw new SQLException("Invalid row");
        }
    }

    public boolean getBoolean(int pos) throws SQLException {
        this.verify(pos);
        Object column = this.columns[pos - 1];
        if (column instanceof boolean[]) {
            return ((boolean[])column)[this.currentRow];
        }
        return Boolean.valueOf(((Object[])column)[this.currentRow].toString());
    }

    public void updateNull(String field) throws SQLException {
        this.intercept();
    }

    public void updateBytes(String field, byte[] data) throws SQLException {
        this.intercept();
    }

    public void updateTime(String field, Time time) throws SQLException {
        this.intercept();
    }

    public void updateString(String field, String string) throws SQLException {
        this.intercept();
    }

    public void updateAsciiStream(String field, InputStream stream, int length) throws SQLException {
        this.intercept();
    }

    public void updateBinaryStream(String field, InputStream stream, int length) throws SQLException {
        this.intercept();
    }

    public void updateCharacterStream(String field, Reader in, int length) throws SQLException {
        this.intercept();
    }

    public void updateObject(String field, Object object, int length) throws SQLException {
        this.intercept();
    }

    public void updateObject(String field, Object object) throws SQLException {
        this.intercept();
    }

    public java.sql.Array getArray(String field) throws SQLException {
        return this.getArray(this.findColumn(field));
    }

    public void updateBigDecimal(String field, BigDecimal decimal) throws SQLException {
        this.intercept();
    }

    public void updateTimestamp(String field, Timestamp timestamp) throws SQLException {
        this.intercept();
    }

    public void updateDate(String field, Date date) throws SQLException {
        this.intercept();
    }

    public void updateByte(String field, byte value) throws SQLException {
        this.intercept();
    }

    public void updateFloat(String field, float value) throws SQLException {
        this.intercept();
    }

    public void updateDouble(String field, double value) throws SQLException {
        this.intercept();
    }

    public void updateLong(String field, long value) throws SQLException {
        this.intercept();
    }

    public void updateBoolean(String field, boolean huh) throws SQLException {
        this.intercept();
    }

    public String getString(String field) throws SQLException {
        return this.getString(this.findColumn(field));
    }

    public Date getDate(String field, Calendar calendar) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Timestamp getTimestamp(String fieldName, Calendar calendar) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Time getTime(String pos, Calendar calendar) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Date getDate(int field, Calendar calendar) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Timestamp getTimestamp(int fieldName, Calendar calendar) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Time getTime(int pos, Calendar calendar) throws SQLException {
        throw new SQLException("Not supported");
    }

    public BigDecimal getBigDecimal(String field) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Reader getCharacterStream(String field) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Reader getCharacterStream(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Timestamp getTimestamp(String field) throws SQLException {
        throw new SQLException("Not supported");
    }

    public InputStream getAsciiStream(String field) throws SQLException {
        throw new SQLException("Not supported");
    }

    public InputStream getUnicodeStream(String field) throws SQLException {
        throw new SQLException("Not supported");
    }

    public InputStream getBinaryStream(String field) throws SQLException {
        throw new SQLException("Not supported");
    }

    public byte getByte(String field) throws SQLException {
        return this.getByte(this.findColumn(field));
    }

    public short getShort(String field) throws SQLException {
        return this.getShort(this.findColumn(field));
    }

    public int getInt(int pos) throws SQLException {
        this.verify(pos);
        Object column = this.columns[pos - 1];
        if (column instanceof int[]) {
            return ((int[])column)[this.currentRow];
        }
        return Integer.parseInt(((Object[])column)[this.currentRow].toString());
    }

    public int getInt(String field) throws SQLException {
        return this.getInt(this.findColumn(field));
    }

    public long getLong(String field) throws SQLException {
        return this.getLong(this.findColumn(field));
    }

    public BigDecimal getBigDecimal(String field, int pos2) throws SQLException {
        return this.getBigDecimal(this.findColumn(field), pos2);
    }

    public float getFloat(String field) throws SQLException {
        return this.getFloat(this.findColumn(field));
    }

    public double getDouble(String field) throws SQLException {
        return this.getDouble(this.findColumn(field));
    }

    public boolean getBoolean(String field) throws SQLException {
        return this.getBoolean(this.findColumn(field));
    }

    public Clob getClob(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Blob getBlob(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Ref getRef(int pos) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Clob getClob(String field) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Blob getBlob(String field) throws SQLException {
        throw new SQLException("Not supported");
    }

    public Ref getRef(String field) throws SQLException {
        throw new SQLException("Not supported");
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    protected void intercept() throws SQLException {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String name) {
        this.username = name;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void removeRowSetListener(RowSetListener listener) {
    }

    public void setArray(int pos, java.sql.Array array) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setBinaryStream(int pos, InputStream in, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setBoolean(int pos, boolean b) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setByte(int pos, byte b) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setShort(int pos, short s) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setInt(int pos, int value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setLong(int pos, long value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setFloat(int pos, float value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setDouble(int pos, double value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setBigDecimal(int pos, BigDecimal value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setString(int pos, String value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setBytes(int pos, byte[] value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setDate(int pos, Date value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setNull(int pos, int type) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setCharacterStream(int pos, Reader in, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setDate(int pos, Date value, Calendar calendar) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setNull(int pos, int type, String name) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setAsciiStream(int pos, InputStream value, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setUnicodeStream(int pos, InputStream value, int length) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setBlob(int pos, Blob value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setClob(int pos, Clob value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setObject(int pos, Object value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setObject(int pos, Object value, int a) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setObject(int pos, Object value, int a, int b) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setTimestamp(int pos, Timestamp value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setTime(int pos, Time value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setRef(int pos, Ref value) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setConcurrency(int type) {
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    public void setReadOnly(boolean readOnly) {
    }

    public void setTime(int pos, Time value, Calendar calendar) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void setTimestamp(int pos, Timestamp value, Calendar calendar) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateClob(String name, Clob clob) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateClob(int pos, Clob clob) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateBlob(String name, Blob blob) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateBlob(int pos, Blob blob) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateArray(String name, java.sql.Array array) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateArray(int pos, java.sql.Array array) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateRef(String name, Ref ref) throws SQLException {
        throw new SQLException("Not supported");
    }

    public void updateRef(int pos, Ref ref) throws SQLException {
        throw new SQLException("Not supported");
    }
}

