/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.servlet;

import com.evermind.mail.MailUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MailServlet
extends HttpServlet {
    protected String sender;
    protected String receiver;
    protected Session mailSession;
    protected String subject;
    protected String body;
    protected String bodyFile;
    protected String response;
    protected String redirect;
    protected String encoding;
    protected String forward;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String sessionLocation = config.getInitParameter("session");
        if (sessionLocation == null) {
            sessionLocation = "java:comp/env/mailSession";
        }
        try {
            InitialContext context = new InitialContext();
            this.mailSession = (Session)context.lookup(sessionLocation);
            if (this.mailSession == null) {
                throw new ServletException("No Session found at " + sessionLocation);
            }
        }
        catch (NamingException e) {
            throw new ServletException("NamingException: " + e.getMessage());
        }
        catch (ClassCastException e) {
            throw new ServletException(sessionLocation + " didnt contain a javax.mail.Session");
        }
        this.sender = config.getInitParameter("sender");
        this.receiver = config.getInitParameter("receiver");
        this.subject = config.getInitParameter("subject");
        this.body = config.getInitParameter("body");
        this.bodyFile = config.getInitParameter("bodyFile");
        this.response = config.getInitParameter("response");
        this.redirect = config.getInitParameter("redirect");
        this.encoding = config.getInitParameter("encoding");
        this.forward = config.getInitParameter("forward");
        if (this.sender == null || this.receiver == null || this.subject == null || this.body == null && this.bodyFile == null || this.response == null && this.redirect == null && this.forward == null) {
            throw new ServletException("Invalid MailServlet config, one of the following parameters not set: sender, receiver, smtp.server, subject, body/bodyFile");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String subject = this.getSubject(request);
        String body = this.getBody(request);
        String sender = this.getSender(request);
        String receiver = this.getReceiver(request);
        String responseBody = this.getResponse(request);
        response.setContentType("text/html");
        try {
            MailUtils.send(receiver, sender, this.mailSession, subject, body, this.encoding);
            if (this.redirect != null) {
                response.sendRedirect(this.redirect);
            } else if (this.forward != null) {
                request.getRequestDispatcher(this.forward).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                ServletOutputStream out = response.getOutputStream();
                out.println(responseBody);
                out.flush();
                out.close();
            }
        }
        catch (MessagingException e) {
            ServletOutputStream out = response.getOutputStream();
            out.println("Error: " + e.getMessage());
            out.flush();
            out.close();
        }
    }

    public String getSubject(HttpServletRequest request) {
        return MailServlet.format(request, this.subject);
    }

    public String getBody(HttpServletRequest request) throws IOException {
        if (this.bodyFile != null) {
            File file = new File(this.bodyFile).getAbsoluteFile();
            byte[] data = new byte[(int)file.length()];
            FileInputStream in = new FileInputStream(file);
            in.read(data);
            in.close();
            return MailServlet.format(request, new String(data));
        }
        return MailServlet.format(request, this.body);
    }

    public String getSender(HttpServletRequest request) {
        return MailServlet.format(request, this.sender);
    }

    public String getReceiver(HttpServletRequest request) {
        return MailServlet.format(request, this.receiver);
    }

    public String getResponse(HttpServletRequest request) {
        if (this.response == null) {
            return "";
        }
        return MailServlet.format(request, this.response);
    }

    public static String format(HttpServletRequest request, String text) {
        int indexPos;
        StringBuffer buffer = new StringBuffer();
        boolean searchPos = false;
        int indexEndPos = 0;
        while ((indexPos = text.indexOf(123, indexEndPos)) >= 0) {
            Object object;
            if (indexPos > indexEndPos) {
                buffer.append(text.substring(indexEndPos, indexPos));
            }
            if ((indexEndPos = text.indexOf(125, indexPos) + 1) < 0) break;
            String variable = request.getParameter(text.substring(indexPos + 1, indexEndPos - 1));
            if (variable == null && (object = request.getAttribute(text.substring(indexPos + 1, indexEndPos - 1))) != null) {
                variable = object.toString();
            }
            if (variable == null) continue;
            buffer.append(variable);
        }
        if (indexEndPos < text.length()) {
            buffer.append(text.substring(indexEndPos, text.length()));
        }
        return buffer.toString();
    }

    public String getServletInfo() {
        return "MailServlet (c)1999 Evermind (http://www.evermind.net)\nEach parameter is a string and it can contain { } blocks containing the name of the request parameter which it is to be replaced with.\nThe parameters are: sender, receiver, subject, body, encoding";
    }

    public void destroy() {
    }
}

