/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.net.AccessRegionSet;
import com.evermind.net.AddressContainer;
import com.evermind.security.User;
import com.evermind.server.rmi.RMIInterceptorContextImpl;
import com.evermind.server.rmi.RMIPermission;
import java.io.IOException;
import java.security.Permission;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

public class RMIServerInterceptorContext
extends RMIInterceptorContextImpl {
    static final Logger s_traceLogger = TraceLogger.getLogger(RMIServerInterceptorContext.class);
    public static final String SUBJ_ID_PROP_TAG = "subject.propagation";
    public static final Permission SUBJ_ID_PROP_PERM = new RMIPermission("subject.propagation");
    protected AccessRegionSet m_ars_SubjProp;

    public RMIServerInterceptorContext(AddressContainer addressContainer_Sender, AccessRegionSet ars_SubjProp, User user) {
        super(addressContainer_Sender, user);
        this.m_ars_SubjProp = ars_SubjProp;
    }

    protected boolean computeIsTrustedSender(String operationName) throws IOException {
        boolean trustedSender = false;
        if (null != operationName && (operationName.equals(SUBJ_ID_PROP_TAG) || operationName.equals(SUBJ_ID_PROP_TAG)) && (trustedSender = this.checkAccessRegionSet())) {
            trustedSender = this.checkUserPermission(null);
        }
        return trustedSender;
    }

    boolean checkAccessRegionSet() {
        boolean trustedSender;
        boolean bl = trustedSender = null != this.m_addressContainer_Sender && null != this.m_ars_SubjProp;
        if (!trustedSender) {
            return this.logAndReturnResult(false, "AccessRegionSet(missing attributes) -> trusted={0}", null);
        }
        trustedSender = this.m_ars_SubjProp.allow(SUBJ_ID_PROP_TAG, this.m_addressContainer_Sender.getInetAddress());
        return this.logAndReturnResult(trustedSender, "AccessRegionSet.allow({1}) -> trusted={0}", this.m_addressContainer_Sender.getInetAddress());
    }

    boolean checkUserPermission(String actions) {
        if (null == this.m_user) {
            return false;
        }
        Permission permission = null == actions ? SUBJ_ID_PROP_PERM : new RMIPermission(SUBJ_ID_PROP_TAG, actions);
        boolean trustedSender = this.m_user.hasPermission(permission);
        return this.logAndReturnResult(trustedSender, permission + " for user: {1} -> trusted={0}", this.m_user.getName());
    }

    private boolean logAndReturnResult(boolean result, String msg, Object msgArg) {
        if (s_traceLogger.isLoggable(Level.FINE)) {
            s_traceLogger.log(Level.FINE, msg, new Object[]{result, msgArg});
        }
        return result;
    }

    public boolean isTrustedSender(String operationName, String actions) throws IOException {
        if (!this.isTrustedSender(operationName)) {
            return false;
        }
        if (null != actions) {
            return this.checkUserPermission(actions);
        }
        return true;
    }
}

