/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.rmi;

import com.evermind.server.cluster.ServerIdentification;
import com.evermind.server.rmi.RMIClient;
import com.evermind.server.rmi.RmiServerLookupStrategy;
import com.evermind.server.rmi.TunnelledRmiLocation;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import javax.naming.NamingException;
import oracle.j2ee.rmi.RMIMessages;
import oracle.oc4j.rmi.ClientRmiTransport;
import oracle.oc4j.rmi.tunnelling.TunnelledRmiTransport;

public abstract class RMILocation {
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_HTTPS_PORT = 443;
    public static final int DEFAULT_ONS_REQUEST_PORT = 6003;
    public static final String DEFAULT_OC4J_INSTANCE_NAME = "home";
    protected String urlInstance;
    protected int port;
    protected String oc4jInstanceName = "home";
    protected String application = null;
    protected boolean secure = false;
    protected static final InetAddress _localhost = RMILocation.getLocalHost();
    protected static final boolean cacheDnsLookupForever = System.getProperty("sun.net.inetaddr.ttl", "-1").equals("-1");
    protected DnsClient m_dnsClient;
    private boolean isIPv6Host = false;
    static DnsClient DEFAULT_DNS_CLIENT = new DnsClient(){

        public InetAddress getByName(String name) throws UnknownHostException {
            return InetAddress.getByName(name);
        }

        public InetAddress[] getAllByName(String name) throws UnknownHostException {
            return InetAddress.getAllByName(name);
        }
    };

    public static RMILocation createRMILocation(String urlLocation) throws NamingException {
        return RMILocation.createRMILocation(DEFAULT_DNS_CLIENT, urlLocation);
    }

    public static RMILocation createRMILocation(DnsClient dnsClient, String urlLocation) throws NamingException {
        String details;
        if (urlLocation == null) {
            throw new NamingException("Provider URL must not be null");
        }
        int colonPos = urlLocation.indexOf(58);
        if (colonPos < 0) {
            throw new NamingException("Provider URL: " + urlLocation + " has no protocol string");
        }
        String protocol = urlLocation.substring(0, colonPos);
        if (TunnelledRmiLocation.isTunnelingUrl(protocol, details = urlLocation.substring(colonPos + 1))) {
            return new TunnelledRmiLocation(dnsClient, details);
        }
        if (OrmiLocation.isOrmiUrl(protocol, details)) {
            return new OrmiLocation(dnsClient, protocol, details);
        }
        if (protocol.equals("http") || protocol.equals("https")) {
            return new OldTunnelledLocation(dnsClient, protocol, details);
        }
        if (protocol.equals("lookup")) {
            return new LookupLocation(dnsClient, details);
        }
        if (protocol.equals("opmn")) {
            return new OpmnLocation(dnsClient, details);
        }
        throw new NamingException("Invalid provider URL");
    }

    protected RMILocation(DnsClient dnsClient) {
        this.m_dnsClient = dnsClient;
    }

    protected void parseURL() throws NamingException {
        this.stripProtocolAndPunctuation();
        this.stripApplicationFromEnd();
        this.port = this.getDefaultPort();
        boolean rfc2732literal = this.urlInstance != null && this.urlInstance.trim().length() > 0 && this.urlInstance.charAt(0) == '[';
        int startIndex = rfc2732literal ? this.urlInstance.indexOf(93, 1) + 1 : 0;
        int colonPos = this.urlInstance.indexOf(58, startIndex);
        if (colonPos > 0) {
            this.parseValueAfterColon(colonPos);
            this.urlInstance = this.urlInstance.substring(0, colonPos);
        }
        if (rfc2732literal && startIndex > 1) {
            this.urlInstance = this.urlInstance.substring(1, startIndex - 1);
            this.isIPv6Host = rfc2732literal;
        }
    }

    protected void parseValueAfterColon(int colonPos) {
        try {
            this.port = Integer.parseInt(this.urlInstance.substring(colonPos + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected abstract int getDefaultPort();

    protected void stripApplicationFromEnd() {
        int slashPos = this.urlInstance.indexOf("/");
        if (slashPos > 0) {
            this.application = this.urlInstance.substring(slashPos + 1);
            this.urlInstance = this.urlInstance.substring(0, slashPos);
        }
    }

    protected void stripProtocolAndPunctuation() throws NamingException {
        int slashIndex = this.urlInstance.indexOf("//");
        if (slashIndex < 0) {
            throw new NamingException("Invalid provider URL");
        }
        this.urlInstance = this.urlInstance.substring(slashIndex + 2);
    }

    protected ClientRmiTransport getTransport() throws UnknownHostException, MalformedURLException {
        throw new RuntimeException("Not a single connection location");
    }

    String getHost() {
        return this.urlInstance;
    }

    String getLiteralHost() {
        return this.isIPv6Host ? "[" + this.getHost() + "]" : this.getHost();
    }

    public boolean isLookupURL() {
        return false;
    }

    public boolean isLookupURL(boolean ignoreLoopbackAddress) {
        return this.isLookupURL();
    }

    public boolean isSecureProtocol() {
        return this.secure;
    }

    String getOc4jInstanceName() {
        return this.oc4jInstanceName;
    }

    String getApplication() {
        return this.application;
    }

    public boolean isLocal() throws UnknownHostException {
        InetAddress address = this.getAddress();
        return _localhost.equals(address) || address.isLoopbackAddress() || address.getHostAddress().equals("0.0.0.0");
    }

    InetAddress getAddress() throws UnknownHostException {
        InetAddress[] addresses = this.m_dnsClient.getAllByName(this.getHost());
        if (addresses != null) {
            int idx = (int)Math.floor(Math.random() * (double)addresses.length);
            return addresses[idx % addresses.length];
        }
        return this.m_dnsClient.getByName(this.getHost());
    }

    static final InetAddress getLocalHost() {
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            RMIMessages.finerThrowable("Cannot get Localhost: " + e.getMessage(), e);
        }
        try {
            if (localhost == null) {
                localhost = InetAddress.getByName("localhost");
            }
        }
        catch (UnknownHostException e) {
            RMIMessages.finerThrowable("Cannot get Localhost: " + e.getMessage(), e);
        }
        return localhost;
    }

    boolean isRequestForLocalServer(RMIClient server) throws UnknownHostException {
        return this.isLocal() && server.isListeningToPort(this.port) && server.isMatchingApplication(this.application);
    }

    protected RmiServerLookupStrategy createLookupStrategy() throws UnknownHostException {
        throw new RuntimeException("The specified location is not a lookup URL");
    }

    ClientRmiTransport getTransportForServer(ServerIdentification serverIdentification) throws UnknownHostException {
        return ClientRmiTransport.createDirectTransport(InetAddress.getByName(serverIdentification.getAddress()), serverIdentification.getPort(), this.secure);
    }

    class URLProfile {
        InetAddress address;
        boolean isRemote = false;
        boolean hasProvidedURL = false;
        String ipString = null;
        InetAddress[] addresses = null;

        URLProfile() {
        }
    }

    static class OpmnLocation
    extends RMILocation {
        public OpmnLocation(DnsClient dnsClient, String details) throws NamingException {
            super(dnsClient);
            this.urlInstance = details;
            this.secure = this.urlInstance.startsWith("ormis");
            this.parseURL();
        }

        protected void parseValueAfterColon(int colonPos) {
            try {
                int nextColonPos = this.urlInstance.indexOf(":", colonPos + 1);
                if (nextColonPos > 0) {
                    this.port = Integer.parseInt(this.urlInstance.substring(colonPos + 1, nextColonPos));
                    this.oc4jInstanceName = this.urlInstance.substring(nextColonPos + 1);
                } else {
                    this.oc4jInstanceName = this.urlInstance.substring(colonPos + 1);
                    this.port = Integer.parseInt(this.oc4jInstanceName);
                    this.oc4jInstanceName = RMILocation.DEFAULT_OC4J_INSTANCE_NAME;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        protected int getDefaultPort() {
            return 6003;
        }

        protected RmiServerLookupStrategy createLookupStrategy() throws UnknownHostException {
            return RmiServerLookupStrategy.createOpmnLookupStrategy(this.getAddress().getHostName(), this.port, this.getOc4jInstanceName(), this.secure);
        }

        public boolean isLookupURL() {
            return true;
        }
    }

    static class LookupLocation
    extends RMILocation {
        public LookupLocation(DnsClient dnsClient, String details) throws NamingException {
            super(dnsClient);
            this.urlInstance = details;
            if (this.urlInstance.startsWith("ormis:")) {
                this.secure = true;
            }
            this.parseURL();
        }

        protected int getDefaultPort() {
            return this.secure ? 23943 : 23791;
        }

        protected RmiServerLookupStrategy createLookupStrategy() throws UnknownHostException {
            return RmiServerLookupStrategy.createPeerLookupStrategy(this.getHost(), this.port, this.secure);
        }

        public boolean isLookupURL() {
            return true;
        }
    }

    static class OldTunnelledLocation
    extends RMILocation {
        OldTunnelledLocation(DnsClient dnsClient, String protocol, String details) throws NamingException {
            super(dnsClient);
            int atSign;
            this.urlInstance = details;
            this.secure = protocol.equals("https");
            if (!details.startsWith("ormi:")) {
                throw new NamingException("URL does not specify ORMI protocol");
            }
            this.parseURL();
            if (this.application != null && (atSign = this.application.indexOf("@")) != -1) {
                String bigAppNm = this.application;
                this.application = bigAppNm.substring(0, atSign);
            }
        }

        protected int getDefaultPort() {
            return this.secure ? 443 : 80;
        }

        protected ClientRmiTransport getTransport() throws UnknownHostException, MalformedURLException {
            StringBuffer sb = new StringBuffer("http");
            if (this.secure) {
                sb.append('s');
            }
            sb.append("://").append(this.getLiteralHost());
            if (this.port != this.getDefaultPort()) {
                sb.append(':').append(this.port);
            }
            sb.append(TunnelledRmiTransport.getRequestPath(this.application));
            return ClientRmiTransport.createTunnelledTransport(sb.toString());
        }
    }

    static class OrmiLocation
    extends RMILocation {
        public OrmiLocation(DnsClient dnsClient, String protocol, String details) throws NamingException {
            super(dnsClient);
            this.secure = protocol.equals("ormis");
            this.urlInstance = details;
            this.parseURL();
        }

        protected int getDefaultPort() {
            return this.secure ? 23943 : 23791;
        }

        protected ClientRmiTransport getTransport() throws UnknownHostException {
            return ClientRmiTransport.createDirectTransport(this.getAddress(), this.port, this.secure);
        }

        public boolean isLookupURL() {
            try {
                return this.m_dnsClient.getAllByName(this.getHost()).length > 1;
            }
            catch (UnknownHostException e) {
                return false;
            }
        }

        public boolean isLookupURL(boolean ignoreLoopbackAddress) {
            if (!ignoreLoopbackAddress) {
                return this.isLookupURL();
            }
            try {
                int count = 0;
                InetAddress[] addresses = this.m_dnsClient.getAllByName(this.getHost());
                if (addresses.length <= 1) {
                    return false;
                }
                for (int i = 0; i < addresses.length; ++i) {
                    InetAddress address = addresses[i];
                    if (address.isLoopbackAddress() || ++count <= 1) continue;
                    return true;
                }
                return false;
            }
            catch (UnknownHostException e) {
                return false;
            }
        }

        protected RmiServerLookupStrategy createLookupStrategy() throws UnknownHostException {
            if (!this.isLookupURL()) {
                throw new RuntimeException("The specified location is not a lookup URL");
            }
            return RmiServerLookupStrategy.createDnsLookupStrategy(this.m_dnsClient.getAllByName(this.getHost()), this.port);
        }

        private static boolean isOrmiUrl(String protocol, String details) {
            return (protocol.equals("ormi") || protocol.equals("ormis")) && details.startsWith("//");
        }
    }

    static interface DnsClient {
        public InetAddress getByName(String var1) throws UnknownHostException;

        public InetAddress[] getAllByName(String var1) throws UnknownHostException;
    }
}

