/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.JMSRequestHandler;
import com.evermind.server.multicastjms.MessageSelector;

public class ServerMessageListener {
    public int id;
    public JMSRequestHandler handler;
    public MessageSelector selector;
    public long timeout;
    public long endTime;
    public EvermindMessage response;
    public byte acknowledgeMode;

    public ServerMessageListener(MessageSelector selector, byte acknowledgeMode) {
        this.selector = selector;
        this.acknowledgeMode = acknowledgeMode;
    }

    public ServerMessageListener(JMSRequestHandler handler, int id, MessageSelector selector, long timeout, byte acknowledgeMode) {
        this.id = id;
        this.handler = handler;
        this.selector = selector;
        this.timeout = timeout;
        this.acknowledgeMode = acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(EvermindMessage message) {
        if (this.handler != null) {
            this.handler.dispatchMessage(this.id, message, this.acknowledgeMode);
        } else {
            this.response = message;
            ServerMessageListener serverMessageListener = this;
            synchronized (serverMessageListener) {
                this.notify();
            }
        }
    }
}

