/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.multicastjms;

import com.evermind.net.MulticastReceiver;
import com.evermind.net.MulticastSender;
import com.evermind.server.multicastjms.EvermindBytesMessage;
import com.evermind.server.multicastjms.EvermindMapMessage;
import com.evermind.server.multicastjms.EvermindMessage;
import com.evermind.server.multicastjms.EvermindObjectMessage;
import com.evermind.server.multicastjms.EvermindStreamMessage;
import com.evermind.server.multicastjms.EvermindTextMessage;
import com.evermind.server.multicastjms.EvermindTopicConnection;
import com.evermind.util.JMSProperties;
import com.evermind.util.ServerProperties;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.JMSException;

public class MulticastTopicConnection
extends EvermindTopicConnection {
    protected MulticastSender sender;
    protected DataOutputStream dataOut;
    protected MulticastReceiver receiver;
    protected int receiverBufferSize = 200000;
    private boolean haveFailedSending;

    public MulticastTopicConnection(InetAddress address, int port, long id) throws IOException {
        super(address, port);
        this.clientID = id;
        if (JMSProperties.getJMSDebug()) {
            System.out.println("JMS: Creating new Multicast Topic Connection at " + address + ":" + port + " as " + id + "...");
        }
    }

    public synchronized void connect() throws JMSException {
        if (JMSProperties.getJMSDebug()) {
            System.out.println("JMS: Started listening to " + this.address + ":" + this.port + "... (" + this.alive + ")");
        }
        if (this.alive) {
            return;
        }
        this.alive = true;
        try {
            this.sender = new MulticastSender(this.address, this.port, this.clientID);
            this.receiver = new MulticastReceiver(this.address, this.port, this.clientID);
            this.receiver.setReceiverBufferSize(this.receiverBufferSize);
            this.dataOut = new DataOutputStream(this.sender);
            Thread thread = new Thread(this);
            thread.setName("MulticastTopicConnection");
            thread.start();
        }
        catch (IOException e) {
            this.alive = false;
            throw new JMSException("Unable to connect to " + this.address + ":" + this.port + ": " + e.getMessage());
        }
    }

    public synchronized void close() throws JMSException {
        super.close();
        if (!this.alive) {
            return;
        }
        try {
            this.alive = false;
            this.receiver.close();
        }
        catch (IOException e) {
            throw new JMSException("Error while disconnecting");
        }
    }

    protected synchronized void send(String topicName, EvermindMessage message) throws IOException, JMSException {
        Object exception;
        if (topicName == null) {
            throw new NullPointerException("topicName was null");
        }
        if (!this.alive) {
            this.connect();
        }
        this.sender.write(message.getTypeID());
        this.dataOut.writeUTF(topicName);
        message.write(this.sender, this.dataOut);
        if (!this.haveFailedSending) {
            try {
                this.sender.nextMessage();
            }
            catch (AccessControlException e) {
                this.haveFailedSending = true;
            }
        }
        if (this.haveFailedSending && (exception = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    MulticastTopicConnection.this.sender.nextMessage();
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }
        })) != null) {
            throw (IOException)exception;
        }
        EvermindMessage clone = message.cloneMessage();
        clone.sender = this.clientID;
        this.notifySessions(topicName, clone);
    }

    public void run() {
        EvermindMessage message = null;
        String topicName = null;
        if (JMSProperties.getJMSDebug()) {
            System.out.println("Multicast Topic Connection listening...");
        }
        Thread.currentThread().setPriority(ServerProperties.getClusterThreadPriority() < 5 ? 5 : ServerProperties.getClusterThreadPriority());
        if (ServerProperties.getClusterDebug()) {
            System.out.println("MulitcastTopicConnection thread priority = " + Thread.currentThread().getPriority());
        }
        while (this.alive) {
            try {
                byte[] data = this.receiver.nextMessage();
                if (JMSProperties.getJMSDebug()) {
                    System.out.println("JMS: Received multicast fragment from " + this.receiver.getMessageClientID() + "...");
                }
                ByteArrayInputStream in = new ByteArrayInputStream(data, 1, data.length);
                DataInputStream dataIn = new DataInputStream(in);
                message = null;
                switch (data[0]) {
                    case 4: {
                        topicName = dataIn.readUTF();
                        message = new EvermindMapMessage();
                        message.sender = this.receiver.getMessageClientID();
                        message.id = this.receiver.getMessageID();
                        message.read(in, dataIn);
                        break;
                    }
                    case 1: {
                        topicName = dataIn.readUTF();
                        message = new EvermindObjectMessage();
                        message.sender = this.receiver.getMessageClientID();
                        message.id = this.receiver.getMessageID();
                        message.read(in, dataIn);
                        break;
                    }
                    case 5: {
                        topicName = dataIn.readUTF();
                        message = new EvermindTextMessage();
                        message.sender = this.receiver.getMessageClientID();
                        message.id = this.receiver.getMessageID();
                        message.read(in, dataIn);
                        break;
                    }
                    case 6: {
                        topicName = dataIn.readUTF();
                        message = new EvermindMessage();
                        message.sender = this.receiver.getMessageClientID();
                        message.id = this.receiver.getMessageID();
                        message.read(in, dataIn);
                        break;
                    }
                    case 2: {
                        topicName = dataIn.readUTF();
                        message = new EvermindBytesMessage(false);
                        message.sender = this.receiver.getMessageClientID();
                        message.id = this.receiver.getMessageID();
                        message.read(in, dataIn);
                        break;
                    }
                    case 3: {
                        topicName = dataIn.readUTF();
                        message = new EvermindStreamMessage(false);
                        message.sender = this.receiver.getMessageClientID();
                        message.id = this.receiver.getMessageID();
                        message.read(in, dataIn);
                        break;
                    }
                    case 7: {
                        message = null;
                        break;
                    }
                    default: {
                        if (!JMSProperties.getJMSDebug()) break;
                        System.out.println("JMS: Unknown message ID: " + data[0] + "...");
                    }
                }
                if (JMSProperties.getJMSDebug()) {
                    System.out.println("JMS: Received message: " + message + " (" + (message == null ? "none" : message.getJMSType()) + ")");
                }
                if (message == null || !this.started) continue;
                this.notifySessions(topicName, message);
            }
            catch (SocketException e) {
                if (!this.alive) {
                    return;
                }
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void distribute(String topicName, EvermindMessage message) throws IOException, JMSException {
        if (!this.alive) {
            this.connect();
        }
        if (JMSProperties.getJMSDebug()) {
            System.out.println("JMS: Sending multicast fragment to " + topicName + " as " + this.clientID + " (message type: " + message.getTypeID() + ")...");
        }
        this.sender.write(message.getTypeID());
        this.dataOut.writeUTF(topicName);
        message.write(this.sender, this.dataOut);
        this.sender.nextMessage();
    }

    public void registerTopicInterest(String topicName) throws JMSException {
        if (!this.alive) {
            this.connect();
        }
    }
}

